/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.arena;

import com.teamwizardry.librarianlib.features.saving.Save;
import com.teamwizardry.librarianlib.features.saving.SaveInPlace;
import com.teamwizardry.wizardry.api.arena.Arena;
import com.teamwizardry.wizardry.common.entity.angel.EntityAngel;
import com.teamwizardry.wizardry.common.entity.angel.zachriel.EntityZachriel;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

@SaveInPlace
public class ArenaManager {
    public static ArenaManager INSTANCE = new ArenaManager();
    @Save
    private HashSet<Arena> arenas = new HashSet();

    private ArenaManager() {
        new Timer().scheduleAtFixedRate((TimerTask)new ArenaTicker(), 0L, 1L);
    }

    public boolean addArena(@Nonnull Arena arena) {
        for (Arena arena1 : this.arenas) {
            if (arena.getCenter().func_177986_g() != arena1.getCenter().func_177986_g()) continue;
            return false;
        }
        this.arenas.add(arena);
        return true;
    }

    @Nullable
    public Arena getArena(@Nonnull EntityAngel boss) {
        for (Arena arena : this.arenas) {
            if (arena.getBossID() != boss.func_145782_y()) continue;
            return arena;
        }
        return null;
    }

    @SubscribeEvent
    public void tickBoss(LivingEvent.LivingUpdateEvent event) {
        for (Arena arena : this.arenas) {
            if (event.getEntityLiving().func_145782_y() != arena.getBossID() || !(event.getEntityLiving().func_70011_f((double)arena.getCenter().func_177958_n() + 0.5, (double)arena.getCenter().func_177956_o(), (double)arena.getCenter().func_177952_p() + 0.5) > arena.getRadius())) continue;
            event.getEntityLiving().func_70091_d(MoverType.SELF, (double)arena.getCenter().func_177958_n() + 0.5, (double)arena.getCenter().func_177956_o() + 0.5, (double)arena.getCenter().func_177952_p() + 0.5);
        }
    }

    @SubscribeEvent
    public void tickPlayer(TickEvent.PlayerTickEvent event) {
        for (Arena arena : this.arenas) {
            if (!arena.getPlayers().contains(event.player.func_110124_au())) continue;
            if (event.player.func_70011_f((double)arena.getCenter().func_177958_n() + 0.5, (double)arena.getCenter().func_177956_o(), (double)arena.getCenter().func_177952_p() + 0.5) > arena.getRadius()) {
                arena.end();
                continue;
            }
            if (!event.player.field_71075_bZ.field_75100_b) continue;
            event.player.field_71075_bZ.field_75100_b = false;
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        for (Arena arena : this.arenas) {
            if (!arena.getPlayers().contains(event.getPlayer().func_110124_au()) || arena.getWorld() != event.getWorld() || event.getWorld().field_72995_K || !(arena.getBoss() instanceof EntityZachriel)) continue;
            ((EntityZachriel)arena.getBoss()).nemezDrive.trackBlock(event.getPos(), event.getState());
        }
    }

    @SubscribeEvent
    public void placeBlock(BlockEvent.PlaceEvent event) {
        for (Arena arena : this.arenas) {
            if (!arena.getPlayers().contains(event.getPlayer().func_110124_au()) || arena.getWorld() != event.getWorld() || event.getWorld().field_72995_K || !(arena.getBoss() instanceof EntityZachriel)) continue;
            ((EntityZachriel)arena.getBoss()).nemezDrive.trackBlock(event.getPos(), event.getWorld().func_180495_p(event.getPos()));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderWorld(RenderWorldLastEvent event) {
        for (Arena arena : this.arenas) {
        }
    }

    private class ArenaTicker
    extends TimerTask {
        ArenaTicker() {
        }

        @Override
        public void run() {
            if (ArenaManager.this.arenas.isEmpty()) {
                return;
            }
            HashSet<Arena> trash = new HashSet<Arena>();
            for (Arena arena : ArenaManager.this.arenas) {
                if (arena == null) continue;
                if (arena.hasEnded()) {
                    trash.add(arena);
                }
                if (!arena.isActive()) continue;
                Entity entity = arena.getWorld().func_73045_a(arena.getBossID());
                if (entity == null || entity.field_70128_L) {
                    arena.end();
                    continue;
                }
                arena.tick(System.currentTimeMillis() - arena.getStartTick());
            }
            ArenaManager.this.arenas.removeAll(trash);
        }
    }
}

