/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api;

import com.google.common.collect.ImmutableMap;
import com.teamwizardry.wizardry.api.lifetimeobject.LifetimeObject;
import com.teamwizardry.wizardry.api.lifetimeobject.LifetimeObjectManager;
import com.teamwizardry.wizardry.api.spell.IDelayedModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public final class SpellObjectManager {
    private static final ResourceLocation LINGERING = new ResourceLocation("wizardry", "lingering");
    private static final ResourceLocation DELAYED = new ResourceLocation("wizardry", "delayed");
    private static final String NBT_KEY_TYPE = "type";
    private static final String NBT_KEY_DATA = "data";
    private final ImmutableMap<ResourceLocation, Supplier<SpellObject>> factories = ImmutableMap.builder().put((Object)LINGERING, LingeringObject::new).put((Object)DELAYED, DelayedObject::new).build();
    public final LifetimeObjectManager<SpellObject> manager = new LifetimeObjectManager<SpellObject>(new LifetimeObjectManager.Adapter<SpellObject>(){

        @Override
        public void toNbt(SpellObject object, Consumer<NBTTagCompound> consumer) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a(SpellObjectManager.NBT_KEY_TYPE, object.getType().toString());
            compound.func_74782_a(SpellObjectManager.NBT_KEY_DATA, (NBTBase)object.serialize());
            consumer.accept(compound);
        }

        @Override
        public void fromNbt(NBTTagCompound nbt, Consumer<SpellObject> consumer) {
            Supplier factory = (Supplier)SpellObjectManager.this.factories.get((Object)new ResourceLocation(nbt.func_74779_i(SpellObjectManager.NBT_KEY_TYPE)));
            if (factory != null) {
                SpellObject obj = (SpellObject)factory.get();
                obj.deserialize(nbt.func_74775_l(SpellObjectManager.NBT_KEY_DATA));
                consumer.accept(obj);
            }
        }
    });

    public void addLingering(LingeringObject object, int duration) {
        this.manager.add(object, duration);
    }

    public void addDelayed(DelayedObject object, int delay) {
        this.manager.add(object, delay);
    }

    public void tick(Consumer<Boolean> onChange) {
        this.manager.tick(onChange);
    }

    public static final class DelayedObject
    implements SpellObject {
        private World world;
        private SpellData data;
        private SpellRing ring;

        DelayedObject() {
        }

        public DelayedObject(World world, SpellData data, SpellRing ring) {
            this.world = world;
            this.data = data;
            this.ring = ring;
        }

        @Override
        public ResourceLocation getType() {
            return DELAYED;
        }

        @Override
        public void start() {
        }

        @Override
        public void tick() {
        }

        @Override
        public void stop() {
            if (this.ring.getModule() != null && this.ring.getModule().getModuleClass() instanceof IDelayedModule) {
                ((IDelayedModule)((Object)this.ring.getModule().getModuleClass())).runDelayedEffect(this.world, this.data, this.ring);
            }
        }

        @Override
        public NBTTagCompound serialize() {
            NBTTagCompound compound = new NBTTagCompound();
            if (this.ring != null) {
                compound.func_74782_a("spell_ring", (NBTBase)this.ring.serializeNBT());
            }
            if (this.data != null) {
                compound.func_74782_a("spell_data", (NBTBase)this.data.serializeNBT());
            }
            if (this.world != null) {
                compound.func_74768_a("world", this.world.field_73011_w.getDimension());
            }
            return compound;
        }

        @Override
        public void deserialize(NBTTagCompound nbt) {
            if (nbt.func_74764_b("spell_ring")) {
                this.ring = SpellRing.deserializeRing(nbt.func_74775_l("spell_ring"));
            }
            if (nbt.func_74764_b("spell_data")) {
                this.data = SpellData.deserializeData(nbt.func_74775_l("spell_data"));
            }
            if (nbt.func_74764_b("world")) {
                this.world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(nbt.func_74762_e("world"));
            }
        }
    }

    public static final class LingeringObject
    implements SpellObject {
        private World world;
        private SpellData data;
        private SpellRing ring;

        LingeringObject() {
        }

        public LingeringObject(World world, SpellData data, SpellRing ring) {
            this.world = world;
            this.data = data;
            this.ring = ring;
        }

        @Override
        public ResourceLocation getType() {
            return LINGERING;
        }

        @Override
        public void start() {
        }

        @Override
        public void tick() {
            this.ring.runSpellRing(this.world, this.data, false);
        }

        @Override
        public void stop() {
        }

        @Override
        public NBTTagCompound serialize() {
            NBTTagCompound compound = new NBTTagCompound();
            if (this.ring != null) {
                compound.func_74782_a("spell_ring", (NBTBase)this.ring.serializeNBT());
            }
            if (this.data != null) {
                compound.func_74782_a("spell_data", (NBTBase)this.data.serializeNBT());
            }
            if (this.world != null) {
                compound.func_74768_a("world", this.world.field_73011_w.getDimension());
            }
            return compound;
        }

        @Override
        public void deserialize(NBTTagCompound nbt) {
            if (nbt.func_74764_b("spell_ring")) {
                this.ring = SpellRing.deserializeRing(nbt.func_74775_l("spell_ring"));
            }
            if (nbt.func_74764_b("spell_data")) {
                this.data = SpellData.deserializeData(nbt.func_74775_l("spell_data"));
            }
            if (nbt.func_74764_b("world")) {
                this.world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(nbt.func_74762_e("world"));
            }
        }
    }

    private static interface SpellObject
    extends LifetimeObject {
        public ResourceLocation getType();

        public NBTTagCompound serialize();

        public void deserialize(NBTTagCompound var1);
    }
}

