/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.shapes.RenderData;
import mcjty.rftools.shapes.ShapeID;
import mcjty.rftools.shapes.ShapeRenderer;
import mcjty.rftools.shapes.StatePalette;
import mcjty.rftools.varia.RLE;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class PacketReturnShapeData
implements IMessage {
    private ShapeID id;
    private RLE positions;
    private StatePalette statePalette;
    private int count;
    private int offsetY;
    private String msg;
    private BlockPos dimension;

    public void fromBytes(ByteBuf buf) {
        this.id = new ShapeID(buf);
        this.count = buf.readInt();
        this.offsetY = buf.readInt();
        this.msg = NetworkTools.readStringUTF8((ByteBuf)buf);
        this.dimension = NetworkTools.readPos((ByteBuf)buf);
        int size = buf.readInt();
        if (size == 0) {
            this.statePalette = null;
        } else {
            this.statePalette = new StatePalette();
            while (size > 0) {
                String r = NetworkTools.readString((ByteBuf)buf);
                int m = buf.readInt();
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(r));
                this.statePalette.add(block.func_176203_a(m));
                --size;
            }
        }
        size = buf.readInt();
        if (size == 0) {
            this.positions = null;
        } else {
            this.positions = new RLE();
            byte[] data = new byte[size];
            buf.readBytes(data);
            this.positions.setData(data);
        }
    }

    public void toBytes(ByteBuf buf) {
        this.id.toBytes(buf);
        buf.writeInt(this.count);
        buf.writeInt(this.offsetY);
        NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.msg);
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.dimension);
        if (this.statePalette == null) {
            buf.writeInt(0);
        } else {
            buf.writeInt(this.statePalette.getPalette().size());
            for (IBlockState state : this.statePalette.getPalette()) {
                if (state.func_177230_c().getRegistryName() == null) {
                    state = Blocks.field_150348_b.func_176223_P();
                }
                NetworkTools.writeString((ByteBuf)buf, (String)state.func_177230_c().getRegistryName().toString());
                buf.writeInt(state.func_177230_c().func_176201_c(state));
            }
        }
        if (this.positions == null) {
            buf.writeInt(0);
        } else {
            buf.writeInt(this.positions.getData().length);
            buf.writeBytes(this.positions.getData());
        }
    }

    public PacketReturnShapeData() {
    }

    public PacketReturnShapeData(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketReturnShapeData(ShapeID id, RLE positions, StatePalette statePalette, BlockPos dimension, int count, int offsetY, String msg) {
        this.id = id;
        this.positions = positions;
        this.statePalette = statePalette;
        this.dimension = dimension;
        this.count = count;
        this.offsetY = offsetY;
        this.msg = msg;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            int dx = this.dimension.func_177958_n();
            int dy = this.dimension.func_177956_o();
            int dz = this.dimension.func_177952_p();
            RLE rle = this.positions;
            RenderData.RenderPlane plane = null;
            if (rle != null) {
                IBlockState dummy = BuilderSetup.supportBlock.func_176223_P();
                rle.reset();
                int oy = this.offsetY;
                int y = oy - dy / 2;
                RenderData.RenderStrip[] strips = new RenderData.RenderStrip[dx];
                for (int ox = 0; ox < dx; ++ox) {
                    RenderData.RenderStrip strip;
                    int x = ox - dx / 2;
                    strips[ox] = strip = new RenderData.RenderStrip(x);
                    for (int oz = 0; oz < dz; ++oz) {
                        int data = rle.read();
                        if (data < 255) {
                            if (data == 0) {
                                strip.add(dummy);
                                continue;
                            }
                            strip.add(this.statePalette.getPalette().get(--data));
                            continue;
                        }
                        strip.add(null);
                    }
                    strip.close();
                    plane = new RenderData.RenderPlane(strips, y, oy, -dz / 2, this.count);
                }
            }
            ShapeRenderer.setRenderData(this.id, plane, this.offsetY, dy, this.msg);
        });
        ctx.setPacketHandled(true);
    }
}

