/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.EnergyHelpers;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.core.part.PartTypeInterfacePositionedAddon;

public class PartTypeInterfaceEnergy
extends PartTypeInterfacePositionedAddon<IEnergyNetwork, IEnergyStorage, PartTypeInterfaceEnergy, State> {
    public PartTypeInterfaceEnergy(String name) {
        super(name);
    }

    @Override
    protected Capability<IEnergyNetwork> getNetworkCapability() {
        return Capabilities.NETWORK_ENERGY;
    }

    @Override
    protected Capability<IEnergyStorage> getTargetCapability() {
        return CapabilityEnergy.ENERGY;
    }

    @Override
    protected IEnergyStorage getTargetCapabilityInstance(PartPos pos) {
        return EnergyHelpers.getEnergyStorage((PartPos)pos);
    }

    protected State constructDefaultState() {
        return new State();
    }

    public int getConsumptionRate(State state) {
        return GeneralConfig.interfaceEnergyBaseConsumption;
    }

    public static class State
    extends PartTypeInterfacePositionedAddon.State<PartTypeInterfaceEnergy, IEnergyNetwork, IEnergyStorage>
    implements IEnergyStorage {
        @Override
        protected Capability<IEnergyStorage> getTargetCapability() {
            return CapabilityEnergy.ENERGY;
        }

        protected IEnergyStorage getEnergyStorage() {
            return (IEnergyStorage)((IEnergyNetwork)this.getPositionedAddonsNetwork()).getChannelExternal(CapabilityEnergy.ENERGY, this.getChannel());
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.isNetworkAndPositionValid()) {
                return 0;
            }
            this.disablePosition();
            int ret = this.getEnergyStorage().receiveEnergy(maxReceive, simulate);
            this.enablePosition();
            return ret;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.isNetworkAndPositionValid()) {
                return 0;
            }
            this.disablePosition();
            int ret = this.getEnergyStorage().extractEnergy(maxExtract, simulate);
            this.enablePosition();
            return ret;
        }

        public int getEnergyStored() {
            if (!this.isNetworkAndPositionValid()) {
                return 0;
            }
            this.disablePosition();
            int ret = this.getEnergyStorage().getEnergyStored();
            this.enablePosition();
            return ret;
        }

        public int getMaxEnergyStored() {
            if (!this.isNetworkAndPositionValid()) {
                return 0;
            }
            this.disablePosition();
            int ret = this.getEnergyStorage().getMaxEnergyStored();
            this.enablePosition();
            return ret;
        }

        public boolean canExtract() {
            if (!this.isNetworkAndPositionValid()) {
                return false;
            }
            this.disablePosition();
            boolean ret = this.getEnergyStorage().canExtract();
            this.enablePosition();
            return ret;
        }

        public boolean canReceive() {
            if (!this.isNetworkAndPositionValid()) {
                return false;
            }
            this.disablePosition();
            boolean ret = this.getEnergyStorage().canReceive();
            this.enablePosition();
            return ret;
        }
    }
}

