/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import vazkii.arl.item.ItemMod;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.psi.api.cad.ISocketableCapability;
import vazkii.psi.api.cad.ISocketableController;
import vazkii.psi.common.core.PsiCreativeTab;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.base.IPsiItem;

public class ItemExosuitController
extends ItemMod
implements ISocketableController,
IPsiItem {
    private static final String TAG_SELECTED_CONTROL_SLOT = "selectedControlSlot";

    public ItemExosuitController() {
        super("exosuit_controller", new String[0]);
        this.func_77625_d(1);
        this.func_77637_a(PsiCreativeTab.INSTANCE);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (playerIn.func_70093_af()) {
            ItemStack[] stacks;
            if (!worldIn.field_72995_K) {
                worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, PsiSoundHandler.compileError, SoundCategory.PLAYERS, 0.25f, 1.0f);
            } else {
                playerIn.func_184609_a(hand);
            }
            for (ItemStack stack : stacks = this.getControlledStacks(playerIn, itemStackIn)) {
                ISocketableCapability socketable = ISocketableCapability.socketable(stack);
                socketable.setSelectedSlot(3);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public ItemStack[] getControlledStacks(EntityPlayer player, ItemStack stack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            ItemStack armor = (ItemStack)player.field_71071_by.field_70460_b.get(3 - i);
            if (armor.func_190926_b() || !ISocketableCapability.isSocketable(armor)) continue;
            stacks.add(armor);
        }
        return stacks.toArray(new ItemStack[0]);
    }

    @Override
    public int getDefaultControlSlot(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_SELECTED_CONTROL_SLOT, (int)0);
    }

    @Override
    public void setSelectedSlot(EntityPlayer player, ItemStack stack, int controlSlot, int slot) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_SELECTED_CONTROL_SLOT, (int)controlSlot);
        ItemStack[] stacks = this.getControlledStacks(player, stack);
        if (controlSlot < stacks.length && !stacks[controlSlot].func_190926_b()) {
            ISocketableCapability socketable = ISocketableCapability.socketable(stacks[controlSlot]);
            socketable.setSelectedSlot(slot);
        }
    }
}

