/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.gui;

import com.google.common.collect.ImmutableSet;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import vazkii.arl.network.NetworkHandler;
import vazkii.arl.util.RenderHelper;
import vazkii.arl.util.TooltipHandler;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.PieceGroup;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellGrid;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.core.helper.SharingHelper;
import vazkii.psi.client.gui.button.GuiButtonIO;
import vazkii.psi.client.gui.button.GuiButtonPage;
import vazkii.psi.client.gui.button.GuiButtonSideConfig;
import vazkii.psi.client.gui.button.GuiButtonSpellPiece;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.tile.TileProgrammer;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.network.message.MessageSpellModified;
import vazkii.psi.common.spell.SpellCompiler;
import vazkii.psi.common.spell.constant.PieceConstantNumber;

public class GuiProgrammer
extends GuiScreen {
    public static final ResourceLocation texture = new ResourceLocation("psi:textures/gui/programmer.png");
    private static final int PIECES_PER_PAGE = 25;
    public final TileProgrammer programmer;
    public Spell spell;
    public List<String> tooltip = new ArrayList<String>();
    public final Stack<Spell> undoSteps = new Stack();
    public final Stack<Spell> redoSteps = new Stack();
    public static SpellPiece clipboard = null;
    public SpellCompiler compiler;
    public int xSize;
    public int ySize;
    public int padLeft;
    public int padTop;
    public int left;
    public int top;
    public int gridLeft;
    public int gridTop;
    public int cursorX;
    public int cursorY;
    public static int selectedX;
    public static int selectedY;
    public boolean panelEnabled;
    public boolean configEnabled;
    public boolean commentEnabled;
    public int panelX;
    public int panelY;
    public int panelWidth;
    public int panelHeight;
    public int panelCursor;
    public int page = 0;
    public boolean scheduleButtonUpdate = false;
    public final List<SpellPiece> visiblePieces = new ArrayList<SpellPiece>();
    public final List<GuiButton> panelButtons = new ArrayList<GuiButton>();
    public final List<GuiButton> configButtons = new ArrayList<GuiButton>();
    public GuiTextField searchField;
    public GuiTextField spellNameField;
    public GuiTextField commentField;
    public boolean takingScreenshot = false;
    public boolean shareToReddit = false;
    boolean spectator;

    public GuiProgrammer(TileProgrammer programmer) {
        this(programmer, programmer.spell);
    }

    public GuiProgrammer(TileProgrammer tile, Spell spell) {
        this.programmer = tile;
        this.spell = spell;
        this.compiler = new SpellCompiler(spell);
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.xSize = 174;
        this.ySize = 184;
        this.padLeft = 7;
        this.padTop = 7;
        this.left = (this.field_146294_l - this.xSize) / 2;
        this.top = (this.field_146295_m - this.ySize) / 2;
        this.gridLeft = this.left + this.padLeft;
        this.gridTop = this.top + this.padTop;
        this.panelWidth = 100;
        this.panelHeight = 125;
        this.cursorY = -1;
        this.cursorX = -1;
        this.searchField = new GuiTextField(0, this.field_146289_q, 0, 0, 70, 10);
        this.searchField.func_146205_d(false);
        this.searchField.func_146195_b(true);
        this.searchField.func_146185_a(false);
        this.spectator = this.programmer == null ? false : this.programmer.playerLock != null && !this.programmer.playerLock.isEmpty() && !this.programmer.playerLock.equals(this.field_146297_k.field_71439_g.func_70005_c_());
        this.spellNameField = new GuiTextField(0, this.field_146289_q, this.left + this.xSize - 130, this.top + this.ySize - 14, 120, 10);
        this.spellNameField.func_146185_a(false);
        this.spellNameField.func_146203_f(20);
        this.spellNameField.func_146184_c(!this.spectator);
        this.commentField = new GuiTextField(0, this.field_146289_q, this.left, this.top + this.ySize / 2 - 10, this.xSize, 20);
        this.commentField.func_146184_c(false);
        this.commentField.func_146189_e(false);
        this.commentField.func_146203_f(500);
        if (this.spell == null) {
            this.spell = new Spell();
        }
        if (this.programmer != null && this.programmer.spell == null) {
            this.programmer.spell = this.spell;
        }
        this.spellNameField.func_146180_a(this.spell.name);
        this.field_146292_n.clear();
        this.onSelectedChanged();
        this.field_146292_n.add(new GuiButtonIO(this, this.left + this.xSize + 2, this.top + this.ySize - (this.spectator ? 16 : 32), true));
        if (!this.spectator) {
            this.field_146292_n.add(new GuiButtonIO(this, this.left + this.xSize + 2, this.top + this.ySize - 16, false));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        Pair<Integer, Integer> errorPos;
        ItemStack cad;
        int color;
        if (!(this.programmer == null || this.programmer.func_145831_w().func_175625_s(this.programmer.func_174877_v()) == this.programmer && this.programmer.canPlayerInteract((EntityPlayer)this.field_146297_k.field_71439_g))) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        ITooltipFlag.TooltipFlags tooltipFlag = this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
        String comment = "";
        int n = color = Psi.magical ? 0 : 0xFFFFFF;
        if (this.scheduleButtonUpdate) {
            this.updatePanelButtons();
            this.scheduleButtonUpdate = false;
        }
        GlStateManager.func_179094_E();
        this.tooltip.clear();
        this.func_146276_q_();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.left, this.top, 0, 0, this.xSize, this.ySize);
        this.func_73729_b(this.left - 48, this.top + 5, this.xSize, 0, 48, 30);
        int statusX = this.left - 16;
        int statusY = this.top + 13;
        this.func_73729_b(statusX, statusY, this.compiler.isErrored() ? 12 : 0, this.ySize + 28, 12, 12);
        if (mouseX > statusX - 1 && mouseY > statusY - 1 && mouseX < statusX + 13 && mouseY < statusY + 13) {
            if (this.compiler.isErrored()) {
                this.tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"psimisc.errored", (Object[])new Object[0]));
                this.tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)this.compiler.getError(), (Object[])new Object[0]));
                Pair<Integer, Integer> errorPos2 = this.compiler.getErrorLocation();
                if (errorPos2 != null && (Integer)errorPos2.getLeft() != -1 && (Integer)errorPos2.getRight() != -1) {
                    this.tooltip.add(TextFormatting.GRAY + "[" + ((Integer)errorPos2.getLeft() + 1) + ", " + ((Integer)errorPos2.getRight() + 1) + "]");
                }
            } else {
                this.tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"psimisc.compiled", (Object[])new Object[0]));
            }
        }
        if (!(cad = PsiAPI.getPlayerCAD((EntityPlayer)this.field_146297_k.field_71439_g)).func_190926_b()) {
            int cadX = this.left - 42;
            int cadY = this.top + 12;
            GlStateManager.func_179091_B();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            this.field_146297_k.func_175599_af().func_180450_b(cad, cadX, cadY);
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
            if (mouseX > cadX && mouseY > cadY && mouseX < cadX + 16 && mouseY < cadY + 16) {
                List itemTooltip = cad.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)tooltipFlag);
                for (int i = 0; i < itemTooltip.size(); ++i) {
                    if (i == 0) {
                        itemTooltip.set(i, cad.func_77953_t().field_77937_e + (String)itemTooltip.get(i));
                        continue;
                    }
                    itemTooltip.set(i, TextFormatting.GRAY + (String)itemTooltip.get(i));
                }
                this.tooltip.addAll(itemTooltip);
            }
        }
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        if (!this.compiler.isErrored()) {
            int i = 0;
            SpellMetadata meta = this.compiler.getCompiledSpell().metadata;
            for (EnumSpellStat stat : meta.stats.keySet()) {
                int statX = this.left + this.xSize + 3;
                int statY = this.top + (this.takingScreenshot ? 40 : 20) + i * 20;
                int val = meta.stats.get((Object)stat);
                EnumCADStat cadStat = stat.getTarget();
                int cadVal = 0;
                if (cadStat == null) {
                    cadVal = -1;
                } else if (!cad.func_190926_b()) {
                    ICAD cadItem = (ICAD)cad.func_77973_b();
                    cadVal = cadItem.getStatValue(cad, cadStat);
                }
                String s = "" + val;
                s = stat == EnumSpellStat.COST ? s + " (" + Math.max(0, ItemCAD.getRealCost(cad, ItemStack.field_190927_a, val)) + ")" : s + "/" + (cadVal == -1 ? "\u221e" : Integer.valueOf(cadVal));
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(statX, statY, (stat.ordinal() + 1) * 12, this.ySize + 16, 12, 12);
                this.field_146297_k.field_71466_p.func_78276_b(s, statX + 16, statY + 2, cadStat != null && cadVal < val && cadVal != -1 ? 0xFF6666 : 0xFFFFFF);
                this.field_146297_k.func_110434_K().func_110577_a(texture);
                if (mouseX > statX && mouseY > statY && mouseX < statX + 12 && mouseY < statY + 12) {
                    this.tooltip.add((Psi.magical ? TextFormatting.LIGHT_PURPLE : TextFormatting.AQUA) + I18n.func_135052_a((String)stat.getName(), (Object[])new Object[0]));
                    this.tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)stat.getDesc(), (Object[])new Object[0]));
                }
                ++i;
            }
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        SpellPiece piece = null;
        if (SpellGrid.exists(selectedX, selectedY)) {
            piece = this.spell.grid.gridData[selectedX][selectedY];
        }
        if (this.configEnabled && !this.takingScreenshot) {
            this.func_73729_b(this.left - 81, this.top + 55, this.xSize, 30, 81, 115);
            String configStr = I18n.func_135052_a((String)"psimisc.config", (Object[])new Object[0]);
            this.field_146297_k.field_71466_p.func_78276_b(configStr, this.left - this.field_146297_k.field_71466_p.func_78256_a(configStr) - 2, this.top + 45, 0xFFFFFF);
            int i = 0;
            if (piece != null) {
                int param = -1;
                for (int j = 0; j < 4; ++j) {
                    if (!Keyboard.isKeyDown((int)(2 + j))) continue;
                    param = j;
                }
                for (String s : piece.params.keySet()) {
                    int x = this.left - 75;
                    int y = this.top + 70 + i * 26;
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(texture);
                    this.func_73729_b(x + 50, y - 8, this.xSize, 145, 24, 24);
                    String localized = I18n.func_135052_a((String)s, (Object[])new Object[0]);
                    if (i == param) {
                        localized = TextFormatting.UNDERLINE + localized;
                    }
                    this.field_146297_k.field_71466_p.func_78276_b(localized, x, y, 0xFFFFFF);
                    ++i;
                }
            }
        }
        this.cursorX = (mouseX - this.gridLeft) / 18;
        this.cursorY = (mouseY - this.gridTop) / 18;
        if (this.panelEnabled || this.cursorX > 8 || this.cursorY > 8 || this.cursorX < 0 || this.cursorY < 0 || mouseX < this.gridLeft || mouseY < this.gridTop) {
            this.cursorX = -1;
            this.cursorY = -1;
        }
        int tooltipX = mouseX;
        int tooltipY = mouseY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.gridLeft, (float)this.gridTop, (float)0.0f);
        this.spell.draw();
        if (this.compiler.isErrored() && (errorPos = this.compiler.getErrorLocation()) != null && (Integer)errorPos.getLeft() != -1 && (Integer)errorPos.getRight() != -1) {
            int errorX = (Integer)errorPos.getLeft() * 18 + 12;
            int errorY = (Integer)errorPos.getRight() * 18 + 8;
            this.field_146297_k.field_71466_p.func_175063_a("!!", (float)errorX, (float)errorY, 0xFF0000);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        if (selectedX != -1 && selectedY != -1 && !this.takingScreenshot) {
            this.func_73729_b(this.gridLeft + selectedX * 18, this.gridTop + selectedY * 18, 32, this.ySize, 16, 16);
        }
        if (GuiProgrammer.func_175283_s()) {
            this.tooltip.clear();
            this.cursorX = selectedX;
            this.cursorY = selectedY;
            tooltipX = this.gridLeft + this.cursorX * 18 + 10;
            tooltipY = this.gridTop + this.cursorY * 18 + 8;
        }
        SpellPiece pieceAt = null;
        if (this.cursorX != -1 && this.cursorY != -1) {
            pieceAt = this.spell.grid.gridData[this.cursorX][this.cursorY];
            if (pieceAt != null) {
                pieceAt.getTooltip(this.tooltip);
                comment = pieceAt.comment;
            }
            if (!this.takingScreenshot) {
                if (this.cursorX == selectedX && this.cursorY == selectedY) {
                    this.func_73729_b(this.gridLeft + this.cursorX * 18, this.gridTop + this.cursorY * 18, 16, this.ySize, 8, 16);
                } else {
                    this.func_73729_b(this.gridLeft + this.cursorX * 18, this.gridTop + this.cursorY * 18, 16, this.ySize, 16, 16);
                }
            }
        }
        int topy = this.top - 12;
        if (!this.takingScreenshot) {
            int topyText = topy;
            if (this.spectator) {
                String betaTest = TextFormatting.RED + I18n.func_135052_a((String)"psimisc.spectator", (Object[])new Object[0]);
                this.field_146297_k.field_71466_p.func_175063_a(betaTest, (float)this.left + (float)this.xSize / 2.0f - (float)this.field_146297_k.field_71466_p.func_78256_a(betaTest) / 2.0f, (float)topyText, 0xFFFFFF);
                topyText -= 10;
            }
            if (piece != null) {
                String name = I18n.func_135052_a((String)piece.getUnlocalizedName(), (Object[])new Object[0]);
                this.field_146297_k.field_71466_p.func_175063_a(name, (float)this.left + (float)this.xSize / 2.0f - (float)this.field_146297_k.field_71466_p.func_78256_a(name) / 2.0f, (float)topyText, 0xFFFFFF);
            }
            String coords = SpellGrid.exists(this.cursorX, this.cursorY) ? I18n.func_135052_a((String)"psimisc.programmerCoords", (Object[])new Object[]{selectedX + 1, selectedY + 1, this.cursorX + 1, this.cursorY + 1}) : I18n.func_135052_a((String)"psimisc.programmerCoordsNoCursor", (Object[])new Object[]{selectedX + 1, selectedY + 1});
            this.field_146297_k.field_71466_p.func_78276_b(coords, this.left + 4, topy + this.ySize + 14, 0x44FFFFFF);
        }
        if (Psi.magical) {
            this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"psimisc.name", (Object[])new Object[0]), this.left + this.padLeft, this.spellNameField.field_146210_g + 1, color);
        } else {
            this.field_146297_k.field_71466_p.func_175063_a(I18n.func_135052_a((String)"psimisc.name", (Object[])new Object[0]), (float)(this.left + this.padLeft), (float)(this.spellNameField.field_146210_g + 1), color);
        }
        this.spellNameField.func_146194_f();
        if (this.panelEnabled) {
            this.tooltip.clear();
            this.field_146297_k.func_110434_K().func_110577_a(texture);
            GuiProgrammer.func_73734_a((int)this.panelX, (int)this.panelY, (int)(this.panelX + this.panelWidth), (int)(this.panelY + this.panelHeight), (int)-2013265920);
            if (this.panelButtons.size() > 0) {
                GuiButton button = this.panelButtons.get(Math.max(0, Math.min(this.panelCursor, this.panelButtons.size() - 1)));
                int panelPieceX = button.field_146128_h;
                int panelPieceY = button.field_146129_i;
                GuiProgrammer.func_73734_a((int)(panelPieceX - 1), (int)(panelPieceY - 1), (int)(panelPieceX + 17), (int)(panelPieceY + 17), (int)0x559999FF);
            }
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.searchField.field_146209_f - 14, this.searchField.field_146210_g - 2, 0, this.ySize + 16, 12, 12);
            this.searchField.func_146194_f();
            String s = this.page + 1 + "/" + this.getPageCount();
            this.field_146289_q.func_175063_a(s, (float)this.panelX + (float)this.panelWidth / 2.0f - (float)this.field_146289_q.func_78256_a(s) / 2.0f, (float)(this.panelY + this.panelHeight - 12), 0xFFFFFF);
        }
        this.commentField.func_146194_f();
        if (this.commentEnabled) {
            String s = I18n.func_135052_a((String)"psimisc.enterCommit", (Object[])new Object[0]);
            this.field_146297_k.field_71466_p.func_175063_a(s, (float)this.left + (float)this.xSize / 2.0f - (float)this.field_146297_k.field_71466_p.func_78256_a(s) / 2.0f, (float)(this.commentField.field_146210_g + 24), 0xFFFFFF);
            s = I18n.func_135052_a((String)"psimisc.semicolonLine", (Object[])new Object[0]);
            this.field_146297_k.field_71466_p.func_175063_a(s, (float)this.left + (float)this.xSize / 2.0f - (float)this.field_146297_k.field_71466_p.func_78256_a(s) / 2.0f, (float)(this.commentField.field_146210_g + 34), 0xFFFFFF);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.takingScreenshot) {
            this.field_146297_k.func_110434_K().func_110577_a(texture);
            int helpX = this.left + this.xSize + 2;
            int helpY = this.top + this.ySize - (this.spectator ? 32 : 48);
            boolean overHelp = mouseX > helpX && mouseY > helpY && mouseX < helpX + 12 && mouseY < helpY + 12;
            this.func_73729_b(helpX, helpY, this.xSize + (overHelp ? 12 : 0), this.ySize + 9, 12, 12);
            if (overHelp && !GuiProgrammer.func_175283_s()) {
                TooltipHandler.addToTooltip(this.tooltip, (String)"psimisc.programmerHelp", (Object[])new Object[0]);
                String ctrl = I18n.func_135052_a((String)(Minecraft.field_142025_a ? "psimisc.ctrlMac" : "psimisc.ctrlWindows"), (Object[])new Object[0]);
                TooltipHandler.tooltipIfShift(this.tooltip, () -> {
                    int i = 0;
                    while (I18n.func_188566_a((String)("psi.programmerReference" + i))) {
                        this.tooltip.add(I18n.func_135052_a((String)("psi.programmerReference" + i++), (Object[])new Object[]{ctrl}).replaceAll("&", "\u00a7"));
                    }
                });
            }
        }
        ArrayList<String> legitTooltip = null;
        if (GuiProgrammer.func_175283_s()) {
            legitTooltip = new ArrayList<String>(this.tooltip);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (GuiProgrammer.func_175283_s()) {
            this.tooltip = legitTooltip;
        }
        if (!this.takingScreenshot && pieceAt != null) {
            if (this.tooltip != null && !this.tooltip.isEmpty()) {
                pieceAt.drawTooltip(tooltipX, tooltipY, this.tooltip);
            }
            if (comment != null && !comment.isEmpty()) {
                List<String> l = Arrays.asList(comment.split(";"));
                pieceAt.drawCommentText(tooltipX, tooltipY, l);
            }
        } else if (!this.takingScreenshot && this.tooltip != null && !this.tooltip.isEmpty()) {
            RenderHelper.renderTooltip((int)tooltipX, (int)tooltipY, this.tooltip);
        }
        GlStateManager.func_179121_F();
        if (this.takingScreenshot) {
            String name = this.spellNameField.func_146179_b();
            NBTTagCompound cmp = new NBTTagCompound();
            if (this.spell != null) {
                this.spell.writeToNBT(cmp);
            }
            String export = cmp.toString();
            if (this.shareToReddit) {
                SharingHelper.uploadAndShare(name, export);
            } else {
                SharingHelper.uploadAndOpen(name, export);
            }
            this.takingScreenshot = false;
            this.shareToReddit = false;
        }
    }

    public void func_146274_d() throws IOException {
        int next;
        super.func_146274_d();
        int w = Mouse.getEventDWheel();
        int max = this.getPageCount();
        if (w != 0 && (next = this.page - w / Math.abs(w)) >= 0 && next < max) {
            this.page = next;
            this.updatePanelButtons();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.panelEnabled) {
            this.searchField.func_146192_a(mouseX, mouseY, mouseButton);
            if (mouseX < this.panelX || mouseY < this.panelY || mouseX > this.panelX + this.panelWidth || mouseY > this.panelY + this.panelHeight) {
                this.closePanel();
            }
        } else if (!this.commentEnabled) {
            this.spellNameField.func_146192_a(mouseX, mouseY, mouseButton);
            if (this.commentField.func_146176_q()) {
                this.commentField.func_146192_a(mouseX, mouseY, mouseButton);
            }
            if (this.cursorX != -1 && this.cursorY != -1) {
                selectedX = this.cursorX;
                selectedY = this.cursorY;
                if (mouseButton == 1 && !this.spectator) {
                    if (GuiProgrammer.func_146272_n()) {
                        this.pushState(true);
                        this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                        this.onSpellChanged(false);
                        return;
                    }
                    this.openPanel();
                }
                this.onSelectedChanged();
            }
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        if (par2 == 1) {
            if (this.panelEnabled) {
                this.closePanel();
                return;
            }
            if (this.commentEnabled) {
                this.closeComment(false);
                return;
            }
        }
        super.func_73869_a(par1, par2);
        if (this.spectator) {
            return;
        }
        if (this.panelEnabled) {
            String last = this.searchField.func_146179_b();
            this.searchField.func_146201_a(par1, par2);
            if (!this.searchField.func_146179_b().equals(last)) {
                this.page = 0;
                this.updatePanelButtons();
            }
            if (this.panelButtons.size() >= 1) {
                if (par2 == 28) {
                    this.func_146284_a(this.panelButtons.get(this.panelCursor));
                } else if (par2 == 15) {
                    int newCursor = this.panelCursor + (GuiProgrammer.func_146272_n() ? -1 : 1);
                    this.panelCursor = Math.max(0, Math.min(newCursor, this.panelButtons.size() - 1));
                }
            }
        } else if (this.commentEnabled) {
            if (par2 == 28) {
                this.closeComment(true);
            }
            this.commentField.func_146201_a(par1, par2);
        } else {
            boolean pieceHandled = false;
            boolean intercepts = false;
            SpellPiece piece = null;
            if (selectedX != -1 && selectedY != -1 && (piece = this.spell.grid.gridData[selectedX][selectedY]) != null && piece.interceptKeystrokes()) {
                intercepts = true;
                if (piece.onKeyPressed(par1, par2, false)) {
                    this.pushState(true);
                    piece.onKeyPressed(par1, par2, true);
                    this.onSpellChanged(false);
                    pieceHandled = true;
                }
            }
            boolean shift = GuiProgrammer.func_146272_n();
            boolean ctrl = GuiProgrammer.func_146271_m();
            if (!pieceHandled) {
                if (!(par2 != 211 && par2 != 14 || this.spellNameField.func_146206_l())) {
                    if (shift && ctrl && !this.spell.grid.isEmpty()) {
                        this.pushState(true);
                        this.spell = new Spell();
                        this.spellNameField.func_146180_a("");
                        this.onSpellChanged(false);
                        return;
                    }
                    if (selectedX != -1 && selectedY != -1 && piece != null) {
                        this.pushState(true);
                        this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                        this.onSpellChanged(false);
                        return;
                    }
                }
                String lastName = this.spellNameField.func_146179_b();
                this.spellNameField.func_146201_a(par1, par2);
                String currName = this.spellNameField.func_146179_b();
                if (!lastName.equals(currName)) {
                    this.spell.name = currName;
                    this.onSpellChanged(true);
                }
                if (par2 == 15 && !intercepts) {
                    this.spellNameField.func_146195_b(!this.spellNameField.func_146206_l());
                } else if (!this.spellNameField.func_146206_l()) {
                    if (ctrl) {
                        switch (par2) {
                            case 200: {
                                if (shift) {
                                    this.pushState(true);
                                    this.spell.grid.mirrorVertical();
                                    this.onSpellChanged(false);
                                    break;
                                }
                                if (!this.spell.grid.shift(SpellParam.Side.TOP, false)) break;
                                this.pushState(true);
                                this.spell.grid.shift(SpellParam.Side.TOP, true);
                                this.onSpellChanged(false);
                                break;
                            }
                            case 203: {
                                if (shift) {
                                    this.pushState(true);
                                    this.spell.grid.rotate(false);
                                    this.onSpellChanged(false);
                                    break;
                                }
                                if (!this.spell.grid.shift(SpellParam.Side.LEFT, false)) break;
                                this.pushState(true);
                                this.spell.grid.shift(SpellParam.Side.LEFT, true);
                                this.onSpellChanged(false);
                                break;
                            }
                            case 205: {
                                if (shift) {
                                    this.pushState(true);
                                    this.spell.grid.rotate(true);
                                    this.onSpellChanged(false);
                                    break;
                                }
                                if (!this.spell.grid.shift(SpellParam.Side.RIGHT, false)) break;
                                this.pushState(true);
                                this.spell.grid.shift(SpellParam.Side.RIGHT, true);
                                this.onSpellChanged(false);
                                break;
                            }
                            case 208: {
                                if (shift) {
                                    this.pushState(true);
                                    this.spell.grid.mirrorVertical();
                                    this.onSpellChanged(false);
                                    break;
                                }
                                if (!this.spell.grid.shift(SpellParam.Side.BOTTOM, false)) break;
                                this.pushState(true);
                                this.spell.grid.shift(SpellParam.Side.BOTTOM, true);
                                this.onSpellChanged(false);
                                break;
                            }
                            case 44: {
                                if (this.undoSteps.isEmpty()) break;
                                this.redoSteps.add(this.spell.copy());
                                this.spell = this.undoSteps.pop();
                                this.onSpellChanged(false);
                                break;
                            }
                            case 21: {
                                if (this.redoSteps.isEmpty()) break;
                                this.pushState(false);
                                this.spell = this.redoSteps.pop();
                                this.onSpellChanged(false);
                                break;
                            }
                            case 46: {
                                if (piece == null) break;
                                clipboard = piece.copy();
                                break;
                            }
                            case 45: {
                                if (piece == null) break;
                                clipboard = piece.copy();
                                this.pushState(true);
                                this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                                this.onSpellChanged(false);
                                break;
                            }
                            case 47: {
                                if (!SpellGrid.exists(selectedX, selectedY) || clipboard == null) break;
                                this.pushState(true);
                                SpellPiece copy = clipboard.copy();
                                copy.x = selectedX;
                                copy.y = selectedY;
                                this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = copy;
                                this.onSpellChanged(false);
                                break;
                            }
                            case 32: {
                                if (piece == null) break;
                                this.commentField.func_146189_e(true);
                                this.commentField.func_146195_b(true);
                                this.commentField.func_146184_c(true);
                                this.spellNameField.func_146184_c(false);
                                this.commentField.func_146180_a(piece.comment);
                                this.commentEnabled = true;
                                break;
                            }
                            case 34: {
                                this.shareToReddit = false;
                                if (!shift || !GuiProgrammer.func_175283_s()) break;
                                this.takingScreenshot = true;
                                break;
                            }
                            case 19: {
                                this.shareToReddit = true;
                                if (!shift || !GuiProgrammer.func_175283_s()) break;
                                this.takingScreenshot = true;
                            }
                        }
                    } else {
                        int param = -1;
                        for (int i = 0; i < 4; ++i) {
                            if (!Keyboard.isKeyDown((int)(2 + i))) continue;
                            param = i;
                        }
                        switch (par2) {
                            case 200: {
                                if (this.onSideButtonKeybind(piece, param, SpellParam.Side.TOP) || selectedY <= 0) break;
                                --selectedY;
                                this.onSelectedChanged();
                                break;
                            }
                            case 203: {
                                if (this.onSideButtonKeybind(piece, param, SpellParam.Side.LEFT) || selectedX <= 0) break;
                                --selectedX;
                                this.onSelectedChanged();
                                break;
                            }
                            case 205: {
                                if (this.onSideButtonKeybind(piece, param, SpellParam.Side.RIGHT) || selectedX >= 8) break;
                                ++selectedX;
                                this.onSelectedChanged();
                                break;
                            }
                            case 208: {
                                if (this.onSideButtonKeybind(piece, param, SpellParam.Side.BOTTOM) || selectedY >= 8) break;
                                ++selectedY;
                                this.onSelectedChanged();
                                break;
                            }
                            case 28: {
                                this.openPanel();
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean onSideButtonKeybind(SpellPiece piece, int param, SpellParam.Side side) {
        if (param > -1 && piece != null && piece.params.size() >= param) {
            for (GuiButton b : this.configButtons) {
                GuiButtonSideConfig config = (GuiButtonSideConfig)b;
                if (!config.matches(param, side)) continue;
                if (side != SpellParam.Side.OFF && piece.paramSides.get(piece.params.get(config.paramName)) == side) {
                    side = SpellParam.Side.OFF;
                    continue;
                }
                try {
                    this.func_146284_a(config);
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
        return side == SpellParam.Side.OFF;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        super.func_146284_a(button);
        if (button.field_146127_k == 9000) {
            this.closePanel();
        }
        if (button instanceof GuiButtonSpellPiece) {
            this.pushState(true);
            SpellPiece piece = ((GuiButtonSpellPiece)button).piece.copy();
            if (piece.getPieceType() == EnumPieceType.TRICK && this.spellNameField.func_146179_b().isEmpty()) {
                String pieceName = I18n.func_135052_a((String)piece.getUnlocalizedName(), (Object[])new Object[0]);
                String patternStr = I18n.func_135052_a((String)"psimisc.trickPattern", (Object[])new Object[0]);
                Pattern pattern = Pattern.compile(patternStr);
                Matcher matcher = pattern.matcher(pieceName);
                if (matcher.matches()) {
                    String spellName;
                    this.spell.name = spellName = matcher.group(1);
                    this.spellNameField.func_146180_a(spellName);
                }
            }
            this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = piece;
            piece.isInGrid = true;
            piece.x = selectedX;
            piece.y = selectedY;
            this.onSpellChanged(false);
            this.closePanel();
        } else if (button instanceof GuiButtonSideConfig) {
            if (!this.spectator) {
                this.pushState(true);
                ((GuiButtonSideConfig)button).onClick();
                this.onSpellChanged(false);
            }
        } else if (button instanceof GuiButtonPage) {
            int max = this.getPageCount();
            int next = this.page + (((GuiButtonPage)button).right ? 1 : -1);
            if (next >= 0 && next < max) {
                this.page = next;
                this.scheduleButtonUpdate = true;
            }
        } else if (button instanceof GuiButtonIO && GuiProgrammer.func_146272_n()) {
            if (((GuiButtonIO)button).out) {
                NBTTagCompound cmp = new NBTTagCompound();
                if (this.spell != null) {
                    this.spell.writeToNBT(cmp);
                }
                GuiProgrammer.func_146275_d((String)cmp.toString());
            } else {
                if (this.spectator) {
                    return;
                }
                String cb = GuiProgrammer.func_146277_j();
                try {
                    cb = cb.replaceAll("([^a-z0-9])\\d+:", "$1");
                    NBTTagCompound cmp = JsonToNBT.func_180713_a((String)cb);
                    if (cmp.func_74764_b("modsRequired")) {
                        this.field_146297_k.field_71439_g.func_145747_a(new TextComponentTranslation("psimisc.spellOnNewerVersion", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    }
                    this.spell = Spell.createFromNBT(cmp);
                    PlayerDataHandler.PlayerData data = PlayerDataHandler.get((EntityPlayer)this.field_146297_k.field_71439_g);
                    for (int i = 0; i < 9; ++i) {
                        for (int j = 0; j < 9; ++j) {
                            SpellPiece piece = this.spell.grid.gridData[i][j];
                            if (piece == null) continue;
                            PieceGroup group = PsiAPI.groupsForPiece.get(piece.getClass());
                            if (this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d || group != null && data.isPieceGroupUnlocked(group.name, piece.registryKey)) continue;
                            this.field_146297_k.field_71439_g.func_145747_a(new TextComponentTranslation("psimisc.missingPieces", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                            return;
                        }
                    }
                    this.pushState(true);
                    this.spellNameField.func_146180_a(this.spell.name);
                    this.onSpellChanged(false);
                }
                catch (Throwable t) {
                    this.field_146297_k.field_71439_g.func_145747_a(new TextComponentTranslation("psimisc.malformedJson", new Object[]{t.getMessage()}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void openPanel() {
        this.closePanel();
        this.panelEnabled = true;
        this.page = Math.min(this.page, this.getPageCount() - 1);
        this.panelX = this.gridLeft + (selectedX + 1) * 18;
        this.panelY = this.gridTop;
        this.searchField.field_146209_f = this.panelX + 18;
        this.searchField.field_146210_g = this.panelY + 4;
        this.searchField.func_146180_a("");
        this.spellNameField.func_146195_b(false);
        this.updatePanelButtons();
    }

    private void updatePanelButtons() {
        int start;
        int c;
        Comparator<SpellPiece> comparator;
        this.panelCursor = 0;
        this.field_146292_n.removeAll(this.panelButtons);
        this.panelButtons.clear();
        this.visiblePieces.clear();
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((EntityPlayer)this.field_146297_k.field_71439_g);
        TObjectIntHashMap rankings = new TObjectIntHashMap();
        String text = this.searchField.func_146179_b().toLowerCase().trim();
        boolean noSearchTerms = text.isEmpty();
        for (String key : PsiAPI.spellPieceRegistry.func_148742_b()) {
            Class clazz = (Class)PsiAPI.spellPieceRegistry.func_82594_a((Object)key);
            PieceGroup group = PsiAPI.groupsForPiece.get(clazz);
            if (!this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d && (group == null || !data.isPieceGroupUnlocked(group.name, key))) continue;
            SpellPiece p = SpellPiece.create(clazz, this.spell);
            if (noSearchTerms) {
                p.getShownPieces(this.visiblePieces);
                continue;
            }
            int rank = this.ranking(text, p);
            if (rank <= 0) continue;
            rankings.put((Object)clazz, rank);
            p.getShownPieces(this.visiblePieces);
        }
        if (noSearchTerms) {
            comparator = Comparator.comparing(SpellPiece::getSortingName);
        } else {
            comparator = Comparator.comparingInt(arg_0 -> GuiProgrammer.lambda$updatePanelButtons$1((TObjectIntMap)rankings, arg_0));
            comparator = comparator.thenComparing(SpellPiece::getSortingName);
        }
        this.visiblePieces.sort(comparator);
        if (!text.isEmpty() && text.length() <= 5 && (text.matches("\\d+(?:\\.\\d*)?") || text.matches("\\d*(?:\\.\\d+)?"))) {
            SpellPiece p = SpellPiece.create(PieceConstantNumber.class, this.spell);
            ((PieceConstantNumber)p).valueStr = text;
            this.visiblePieces.add(0, p);
        }
        for (int i = start = this.page * 25; i < this.visiblePieces.size() && (c = i - start) < 25; ++i) {
            SpellPiece piece = this.visiblePieces.get(i);
            this.panelButtons.add(new GuiButtonSpellPiece(this, piece, this.panelX + 5 + c % 5 * 18, this.panelY + 20 + c / 5 * 18));
        }
        if (this.page > 0) {
            this.panelButtons.add(new GuiButtonPage(this, this.panelX + 4, this.panelY + this.panelHeight - 15, false));
        }
        if (this.page < this.getPageCount() - 1) {
            this.panelButtons.add(new GuiButtonPage(this, this.panelX + this.panelWidth - 22, this.panelY + this.panelHeight - 15, true));
        }
        this.field_146292_n.addAll(this.panelButtons);
    }

    private int ranking(String token, SpellPiece p) {
        int rank = 0;
        String name = I18n.func_135052_a((String)p.getUnlocalizedName(), (Object[])new Object[0]).toLowerCase();
        String desc = I18n.func_135052_a((String)p.getUnlocalizedDesc(), (Object[])new Object[0]).toLowerCase();
        for (String nameToken : token.split("\\s+")) {
            if (nameToken.isEmpty()) continue;
            if (nameToken.startsWith("in:")) {
                String clippedToken = nameToken.substring(3);
                if (clippedToken.isEmpty()) continue;
                int maxRank = 0;
                for (SpellParam param : p.params.values()) {
                    String type = param.getRequiredTypeString().toLowerCase();
                    maxRank = Math.max(maxRank, this.rankTextToken(type, clippedToken));
                }
                rank += maxRank;
                continue;
            }
            if (nameToken.startsWith("out:")) {
                String clippedToken = nameToken.substring(4);
                if (clippedToken.isEmpty()) continue;
                String type = p.getEvaluationTypeString().toLowerCase();
                rank += this.rankTextToken(type, clippedToken);
                continue;
            }
            if (nameToken.startsWith("@")) {
                String clippedToken = nameToken.substring(1);
                if (clippedToken.isEmpty()) continue;
                String mod = PsiAPI.pieceMods.get(p.getClass());
                if (mod != null) {
                    int modRank = this.rankTextToken(mod, clippedToken);
                    if (modRank <= 0) {
                        return 0;
                    }
                    rank += modRank;
                    continue;
                }
                return 0;
            }
            int nameRank = this.rankTextToken(name, nameToken);
            rank += nameRank;
            if (nameRank != 0) continue;
            rank += this.rankTextToken(desc, nameToken) / 2;
        }
        return rank;
    }

    private int rankTextToken(String haystack, String token) {
        if (token.isEmpty()) {
            return 0;
        }
        if (token.startsWith("_")) {
            String clippedToken = token.substring(1);
            if (clippedToken.isEmpty()) {
                return 0;
            }
            if (haystack.endsWith(clippedToken)) {
                if (!Character.isLetterOrDigit(haystack.charAt(haystack.length() - clippedToken.length() - 1))) {
                    return clippedToken.length() * 3 / 2;
                }
                return clippedToken.length();
            }
        } else if (token.endsWith("_")) {
            String clippedToken = token.substring(0, token.length() - 1);
            if (clippedToken.isEmpty()) {
                return 0;
            }
            if (haystack.startsWith(clippedToken)) {
                if (!Character.isLetterOrDigit(haystack.charAt(clippedToken.length() + 1))) {
                    return clippedToken.length() * 2;
                }
                return clippedToken.length();
            }
        } else {
            int idx;
            if (token.startsWith("has:")) {
                token = token.substring(4);
            }
            if ((idx = haystack.indexOf(token)) >= 0) {
                int multiplier = 2;
                if (idx == 0 || !Character.isLetterOrDigit(haystack.charAt(idx - 1))) {
                    multiplier += 2;
                }
                if (idx + token.length() + 1 >= haystack.length() || !Character.isLetterOrDigit(haystack.charAt(idx + token.length() + 1))) {
                    ++multiplier;
                }
                return token.length() * multiplier / 2;
            }
        }
        return 0;
    }

    private int getPageCount() {
        return this.visiblePieces.size() / 25 + 1;
    }

    private void closePanel() {
        this.panelEnabled = false;
        this.field_146292_n.removeAll(this.panelButtons);
        this.panelButtons.clear();
    }

    private void closeComment(boolean save) {
        SpellPiece piece = null;
        if (selectedX != -1 && selectedY != -1) {
            piece = this.spell.grid.gridData[selectedX][selectedY];
        }
        if (save && piece != null) {
            String text = this.commentField.func_146179_b();
            this.pushState(true);
            piece.comment = text;
            this.onSpellChanged(false);
        }
        this.spellNameField.func_146184_c(!this.spectator && (piece == null || !piece.interceptKeystrokes()));
        this.commentField.func_146195_b(false);
        this.commentField.func_146189_e(false);
        this.commentField.func_146184_c(false);
        this.commentField.func_146180_a("");
        this.commentEnabled = false;
    }

    public void onSpellChanged(boolean nameOnly) {
        if (this.programmer != null) {
            if (!this.spectator) {
                MessageSpellModified message = new MessageSpellModified(this.programmer.func_174877_v(), this.spell);
                NetworkHandler.INSTANCE.sendToServer((IMessage)message);
            }
            this.programmer.spell = this.spell;
            this.programmer.onSpellChanged();
        }
        this.onSelectedChanged();
        this.spellNameField.func_146195_b(nameOnly);
        if (!nameOnly || this.compiler != null && this.compiler.getError() != null && this.compiler.getError().equals("psi.spellerror.noname") || this.spell.name.isEmpty()) {
            this.compiler = new SpellCompiler(this.spell);
        }
    }

    public void pushState(boolean wipeRedo) {
        if (wipeRedo) {
            this.redoSteps.clear();
        }
        this.undoSteps.push(this.spell.copy());
        if (this.undoSteps.size() > 25) {
            this.undoSteps.remove(0);
        }
    }

    public void onSelectedChanged() {
        SpellPiece piece;
        this.field_146292_n.removeAll(this.configButtons);
        this.configButtons.clear();
        this.spellNameField.func_146184_c(!this.spectator);
        this.spellNameField.func_146195_b(false);
        if (selectedX != -1 && selectedY != -1 && (piece = this.spell.grid.gridData[selectedX][selectedY]) != null) {
            boolean intercept = piece.interceptKeystrokes();
            this.spellNameField.func_146184_c(!this.spectator && !intercept);
            if (piece.hasConfig()) {
                int i = 0;
                for (String paramName : piece.params.keySet()) {
                    SpellParam param = piece.params.get(paramName);
                    int x = this.left - 17;
                    int y = this.top + 70 + i * 26;
                    for (SpellParam.Side side : ImmutableSet.of((Object)((Object)SpellParam.Side.TOP), (Object)((Object)SpellParam.Side.BOTTOM), (Object)((Object)SpellParam.Side.LEFT), (Object)((Object)SpellParam.Side.RIGHT), (Object)((Object)SpellParam.Side.OFF))) {
                        if (!side.isEnabled() && !param.canDisable) continue;
                        int xp = x + side.offx * 8;
                        int yp = y + side.offy * 8;
                        this.configButtons.add(new GuiButtonSideConfig(this, selectedX, selectedY, i, paramName, side, xp, yp));
                    }
                    ++i;
                }
                this.field_146292_n.addAll(this.configButtons);
                this.configEnabled = true;
                return;
            }
        }
        this.configEnabled = false;
    }

    private static /* synthetic */ int lambda$updatePanelButtons$1(TObjectIntMap rankings, SpellPiece p) {
        return -rankings.get(p.getClass());
    }
}

