/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostsouls.proxy;

import java.io.File;
import mcjty.lostsouls.ForgeEventHandlers;
import mcjty.lostsouls.config.Config;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public abstract class CommonProxy {
    public static File modConfigDir;
    private Configuration mainConfig;

    public void preInit(FMLPreInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        modConfigDir = e.getModConfigurationDirectory();
        this.mainConfig = new Configuration(new File(modConfigDir.getPath(), "lostsouls.cfg"));
        this.readMainConfig();
    }

    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            cfg.load();
            Config.init(cfg);
        }
        catch (Exception e1) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e1, (String)"Problem loading config file!", (Object[])new Object[0]);
        }
        finally {
            this.saveConfigs();
        }
    }

    private void saveConfigs() {
        if (this.mainConfig.hasChanged()) {
            this.mainConfig.save();
        }
    }

    public void init(FMLInitializationEvent e) {
    }

    public void postInit(FMLPostInitializationEvent e) {
        this.saveConfigs();
        this.mainConfig = null;
    }
}

