/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import zmaster587.libVulpes.util.EmbeddedInventory;

public class FluidUtils {
    private static Map<String, List<String>> fluidEquivalentMapping = new HashMap<String, List<String>>();

    public static boolean containsFluid(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP);
    }

    public static boolean containsFluid(@Nonnull ItemStack stack, Fluid fluid) {
        IFluidHandlerItem fluidItem;
        if (FluidUtils.containsFluid(stack) && (fluidItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP)) != null) {
            FluidStack fluidStack = fluidItem.getTankProperties()[0].getContents();
            return fluidStack != null && FluidUtils.areFluidsSameType(fluidStack.getFluid(), fluid);
        }
        return false;
    }

    public static int getFluidItemCapacity(@Nonnull ItemStack stack) {
        IFluidHandlerItem fluidItem;
        if (FluidUtils.containsFluid(stack) && (fluidItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP)) != null) {
            return fluidItem.getTankProperties()[0].getCapacity();
        }
        return 0;
    }

    public static IFluidHandlerItem getFluidHandler(@Nonnull ItemStack stack) {
        return (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP);
    }

    public static FluidStack getFluidForItem(@Nonnull ItemStack item) {
        if (!FluidUtils.containsFluid(item)) {
            return null;
        }
        IFluidHandlerItem fluidItem = (IFluidHandlerItem)item.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.UP);
        return fluidItem == null ? null : fluidItem.getTankProperties()[0].getContents();
    }

    public static boolean attemptDrainContainerIInv(EmbeddedInventory inv, IFluidHandler tank, @Nonnull ItemStack stack, int inputSlot, int outputSlot) {
        if (FluidUtils.containsFluid(stack)) {
            boolean fill = false;
            boolean toReturn = false;
            FluidActionResult modifiedContainer = null;
            if (stack.func_77973_b() != Items.field_151133_ar && (FluidUtils.getFluidForItem(stack) != null && FluidUtils.getFluidForItem((ItemStack)stack).amount == FluidUtils.getFluidItemCapacity(stack) || tank.getTankProperties()[0].getContents() == null)) {
                modifiedContainer = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)tank, (int)FluidUtils.getFluidItemCapacity(stack), null, (boolean)false);
            } else {
                modifiedContainer = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)tank, (int)FluidUtils.getFluidItemCapacity(stack), null, (boolean)false);
                fill = true;
            }
            if (modifiedContainer.isSuccess()) {
                if (inv.func_70301_a(outputSlot).func_190926_b()) {
                    toReturn = fill ? FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)tank, (int)FluidUtils.getFluidItemCapacity(stack), null, (boolean)true).isSuccess() : FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)tank, (int)FluidUtils.getFluidItemCapacity(stack), null, (boolean)true).isSuccess();
                    inv.func_70301_a(inputSlot).func_190918_g(1);
                    inv.setStackInSlot(outputSlot, modifiedContainer.getResult());
                } else if (inv.func_70301_a(outputSlot).func_77973_b() == modifiedContainer.getResult().func_77973_b() && inv.func_70301_a(outputSlot).func_190916_E() < inv.func_70301_a(outputSlot).func_77976_d()) {
                    toReturn = fill ? FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)tank, (int)FluidUtils.getFluidItemCapacity(stack), null, (boolean)true).isSuccess() : FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)tank, (int)FluidUtils.getFluidItemCapacity(stack), null, (boolean)true).isSuccess();
                    inv.func_70301_a(inputSlot).func_190918_g(1);
                    inv.func_70301_a(outputSlot).func_190917_f(1);
                    return true;
                }
            }
            return toReturn;
        }
        return false;
    }

    public static void addFluidMapping(Fluid in, String altName) {
        String fluidKeyName = in.getName();
        FluidUtils.addFluidMapping(fluidKeyName, altName);
        FluidUtils.addFluidMapping(altName, fluidKeyName);
    }

    private static void addFluidMapping(String in, String altName) {
        List<Object> mappedValues;
        if (!fluidEquivalentMapping.containsKey(in)) {
            mappedValues = new LinkedList();
            fluidEquivalentMapping.put(in, mappedValues);
        } else {
            mappedValues = fluidEquivalentMapping.get(in);
        }
        mappedValues.add(altName);
    }

    public static boolean areFluidsSameType(Fluid in, Fluid otherFluid) {
        String otherFluidName;
        if (in == null || otherFluid == null) {
            return false;
        }
        String inFluidName = in.getName();
        if (inFluidName.equals(otherFluidName = otherFluid.getName())) {
            return true;
        }
        return fluidEquivalentMapping.containsKey(inFluidName) && fluidEquivalentMapping.get(inFluidName).contains(otherFluidName);
    }
}

