/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.core.recipe;

import gr8pefish.ironbackpacks.api.IronBackpacksAPI;
import gr8pefish.ironbackpacks.api.backpack.BackpackInfo;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackVariant;
import gr8pefish.ironbackpacks.core.recipe.RecipeUtil;
import gr8pefish.ironbackpacks.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.DyeUtils;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ColorBackpackRecipe
extends ShapedOreRecipe {
    public ColorBackpackRecipe(@Nonnull BackpackVariant backpackVariant, Object ... recipe) {
        super(new ResourceLocation("ironbackpacks", "color"), IronBackpacksAPI.getStack(backpackVariant), recipe);
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting matrix) {
        ItemStack backpack = RecipeUtil.getFirstBackpackInGrid(matrix);
        if (backpack.func_190926_b()) {
            return super.func_77572_b(matrix);
        }
        ItemStack upgraded = this.func_77571_b().func_77946_l();
        BackpackInfo upgradedInfo = Utils.getBackpackInfoFromStack(backpack);
        upgradedInfo.setRGBColor(this.getDyeColor(matrix));
        return IronBackpacksAPI.applyPackInfo(upgraded, upgradedInfo);
    }

    private int getDyeColor(@Nonnull InventoryCrafting matrix) {
        ItemStack stack = ColorBackpackRecipe.getFirstDyeOrWaterBucketInGrid(matrix);
        if (stack.func_190926_b()) {
            return -1;
        }
        if (stack.func_77973_b().equals(Items.field_151131_as)) {
            return -1;
        }
        return DyeUtils.colorFromStack((ItemStack)stack).map(EnumDyeColor::func_193350_e).orElse(-1);
    }

    @Nonnull
    private static ItemStack getFirstDyeOrWaterBucketInGrid(@Nonnull InventoryCrafting matrix) {
        ItemStack stack = ItemStack.field_190927_a;
        for (int i = 0; i < matrix.func_70302_i_(); ++i) {
            stack = matrix.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (DyeUtils.isDye((ItemStack)stack)) {
                return stack;
            }
            if (!stack.func_77973_b().equals(Items.field_151131_as)) continue;
            return stack;
        }
        return stack;
    }
}

