/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.compat.jei.recipes.animator;

import com.google.common.collect.ImmutableList;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thebetweenlands.api.recipes.IAnimatorRecipe;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.recipe.animator.ToolRepairAnimatorRecipe;
import thebetweenlands.common.recipe.misc.AnimatorRecipe;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.compat.jei.BetweenlandsJEIPlugin;
import thebetweenlands.util.TranslationHelper;

public class AnimatorRecipeJEI
implements IRecipeWrapper {
    private IAnimatorRecipe animatorRecipe;
    private final ItemStack input;
    private int requiredFuel;
    private int requiredLife;
    private ItemStack result;
    private String entityName = null;
    private Entity entity = null;
    private ITickTimer tickTimer;
    private ResourceLocation lootTableName = null;
    private IGuiIngredient<ItemStack> guiIngredient;
    public static final DecimalFormat LIFE_CRYSTAL_PERCENTAGE = new DecimalFormat("##%");

    public AnimatorRecipeJEI(IAnimatorRecipe animatorRecipe) {
        this.animatorRecipe = animatorRecipe;
        if (animatorRecipe instanceof AnimatorRecipe) {
            AnimatorRecipe recipe = (AnimatorRecipe)animatorRecipe;
            this.input = recipe.getInput();
            this.requiredFuel = recipe.getRequiredFuel(this.input);
            this.requiredLife = recipe.getRequiredLife(this.input);
            this.result = recipe.getResult(this.input);
            this.lootTableName = recipe.getLootTable();
        } else {
            ToolRepairAnimatorRecipe recipe = (ToolRepairAnimatorRecipe)animatorRecipe;
            this.input = new ItemStack(recipe.getTool());
            this.result = recipe.getResult(this.input);
        }
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<List<Object>> l = new ArrayList<List<Object>>();
        if (this.animatorRecipe instanceof ToolRepairAnimatorRecipe) {
            int c;
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            for (int i = c = Math.max(1, MathHelper.func_76143_f((double)((double)this.input.func_77958_k() / 15.0))); i < this.input.func_77958_k(); i += c) {
                ItemStack newInput = this.input.func_77946_l();
                newInput.func_77964_b(i);
                inputs.add(newInput);
            }
            l.add(inputs);
        } else {
            l.add(Collections.singletonList(this.input));
        }
        l.add((List<Object>)ImmutableList.of((Object)new ItemStack(ItemRegistry.LIFE_CRYSTAL), (Object)new ItemStack(ItemRegistry.LIFE_CRYSTAL_FRAGMENT)));
        l.add(Collections.singletonList(ItemMisc.EnumItemMisc.SULFUR.create(1)));
        ingredients.setInputLists(VanillaTypes.ITEM, l);
        if (this.result != null) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.result);
        }
        if (this.lootTableName != null) {
            ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(LootTableRegistry.getItemsFromTable(this.lootTableName, (World)Minecraft.func_71410_x().field_71441_e, true)));
        }
    }

    public void setGuiIngredient(IGuiIngredient<ItemStack> guiIngredient) {
        this.guiIngredient = guiIngredient;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.entity == null && this.animatorRecipe.getSpawnEntityClass(this.input) != null) {
            try {
                this.entity = this.animatorRecipe.getSpawnEntityClass(this.input).getConstructor(World.class).newInstance(Minecraft.func_71410_x().field_71441_e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.entity != null) {
                this.entityName = this.entity.func_70005_c_();
                this.tickTimer = BetweenlandsJEIPlugin.jeiHelper.getGuiHelper().createTickTimer(40, 360, false);
            }
        }
        if (this.entity != null) {
            if (this.entity.field_70170_p == null) {
                this.entity.field_70170_p = Minecraft.func_71410_x().field_71441_e;
            }
            ScaledResolution scaledresolution = new ScaledResolution(minecraft);
            int i1 = scaledresolution.func_78326_a();
            int j1 = scaledresolution.func_78328_b();
            int k1 = Mouse.getX() * i1 / minecraft.field_71443_c;
            int l1 = j1 - Mouse.getY() * j1 / minecraft.field_71440_d - 1;
            int posY = l1 - mouseY;
            int posX = k1 - mouseX;
            AnimatorRecipeJEI.doGlScissor(minecraft, posX + 42, posY + 12, 24, 24);
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)54.0f, (float)(34.0f + this.getOffset(this.entity)), (float)200.0f);
            float scale = this.getScale(this.entity);
            GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float rot = this.tickTimer.getValue();
            GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            GlStateManager.func_179137_b((double)0.0, (double)this.entity.func_70033_W(), (double)0.0);
            minecraft.func_175598_ae().func_188391_a(this.entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, true);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GL11.glDisable((int)3089);
            RenderHelper.func_74520_c();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            int fontX = 54 - minecraft.field_71466_p.func_78256_a(this.entityName) / 2;
            Gui.func_73734_a((int)(fontX - 1), (int)-6, (int)(fontX + minecraft.field_71466_p.func_78256_a(this.entityName) + 1), (int)4, (int)-1442840576);
            minecraft.field_71466_p.func_175063_a(this.entityName, (float)fontX, -5.0f, 0xFFFFFF);
        }
    }

    public static void doGlScissor(Minecraft mc, int x, int y, int width, int height) {
        int scaleFactor = 1;
        int k = mc.field_71474_y.field_74335_Z;
        if (k == 0) {
            k = 1000;
        }
        while (scaleFactor < k && mc.field_71443_c / (scaleFactor + 1) >= 320 && mc.field_71440_d / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(x * scaleFactor), (int)(mc.field_71440_d - (y + height) * scaleFactor), (int)(width * scaleFactor), (int)(height * scaleFactor));
    }

    private float getScale(Entity entity) {
        float width = entity.field_70130_N;
        float height = entity.field_70131_O;
        if (width <= height) {
            if ((double)height < 0.7) {
                return 35.0f;
            }
            if ((double)height < 0.9) {
                return 28.0f;
            }
            if (height < 1.0f) {
                return 25.0f;
            }
            if (height < 2.0f) {
                return 12.0f;
            }
            if ((double)height < 2.5) {
                return 10.0f;
            }
            if (height < 3.0f) {
                return 8.5f;
            }
            if (height < 4.0f) {
                return 4.0f;
            }
            return 3.0f;
        }
        if (width < 1.0f) {
            return 28.0f;
        }
        if (width < 2.0f) {
            return 17.0f;
        }
        if (width < 3.0f) {
            return 3.0f;
        }
        return 2.0f;
    }

    private float getOffset(Entity entity) {
        float height = entity.field_70131_O;
        if ((double)height < 0.7) {
            return 0.0f;
        }
        if ((double)height < 0.9) {
            return 0.3f;
        }
        if (height < 1.0f) {
            return 0.8f;
        }
        if (height < 2.0f) {
            return 1.8f;
        }
        if (height < 3.0f) {
            return 1.0f;
        }
        if (height < 4.0f) {
            return 0.5f;
        }
        return -0.8f;
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList<String> processTooltip = new ArrayList<String>();
        if (mouseX >= 18 && mouseX <= 51 && mouseY >= 42 && mouseY <= 66) {
            float lifeAmount = this.guiIngredient != null ? (float)this.animatorRecipe.getRequiredLife((ItemStack)this.guiIngredient.getDisplayedIngredient()) : (float)this.requiredLife;
            processTooltip.add(TranslationHelper.translateToLocal("jei.thebetweenlands.animator.life", LIFE_CRYSTAL_PERCENTAGE.format(lifeAmount / 128.0f)));
        }
        if (mouseX >= 57 && mouseX <= 90 && mouseY >= 42 && mouseY <= 66) {
            processTooltip.add(TranslationHelper.translateToLocal("jei.thebetweenlands.animator.fuel", this.guiIngredient != null ? this.animatorRecipe.getRequiredFuel((ItemStack)this.guiIngredient.getDisplayedIngredient()) : this.requiredFuel));
        }
        if (this.entityName != null && mouseX >= 37 && mouseX <= 71 && mouseY >= 7 && mouseY <= 41) {
            processTooltip.add(TranslationHelper.translateToLocal("jei.thebetweenlands.animator.entity_spawn", this.entityName));
        }
        return processTooltip;
    }

    static {
        LIFE_CRYSTAL_PERCENTAGE.setRoundingMode(RoundingMode.CEILING);
    }
}

