/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.location;

import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.api.storage.ILocalStorageHandler;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageID;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationTokenBucket;

public class TokenBucket {
    private World world;
    private BlockPos pos;
    private ResourceLocation bucketId;
    private float sizeX;
    private float sizeY;
    private float sizeZ;
    private int minTokensPerTick = 1;
    private int maxTokensPerTick = 1;
    private double limitMultiplier = 0.99;
    private double tokensConsumedPerTick = 1.0;
    private long lastCheckedTime = Long.MIN_VALUE;
    private double consumedTokenFraction;

    public TokenBucket() {
    }

    public TokenBucket(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    public TokenBucket(ResourceLocation bucketId, float sizeX, float sizeY, float sizeZ, int minTokensPerTick, int maxTokensPerTick, double limitMultiplier, double tokensConsumedPerTick) {
        this.bucketId = bucketId;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.minTokensPerTick = minTokensPerTick;
        this.maxTokensPerTick = maxTokensPerTick;
        this.limitMultiplier = limitMultiplier;
        this.tokensConsumedPerTick = tokensConsumedPerTick;
    }

    public TokenBucket setWorld(World world) {
        this.world = world;
        if (this.lastCheckedTime == Long.MIN_VALUE) {
            this.lastCheckedTime = world.func_82737_E();
        }
        return this;
    }

    public TokenBucket setPos(BlockPos pos) {
        this.pos = pos;
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("bucketId", this.bucketId.toString());
        nbt.func_74776_a("sizeX", this.sizeX);
        nbt.func_74776_a("sizeY", this.sizeY);
        nbt.func_74776_a("sizeZ", this.sizeZ);
        nbt.func_74768_a("minTokensPerTick", this.minTokensPerTick);
        nbt.func_74768_a("maxTokensPerTick", this.maxTokensPerTick);
        nbt.func_74780_a("limitMultiplier", this.limitMultiplier);
        nbt.func_74780_a("tokensConsumedPerTick", this.tokensConsumedPerTick);
        nbt.func_74772_a("lastCheckedTime", this.lastCheckedTime);
        nbt.func_74780_a("consumedTokenFraction", this.consumedTokenFraction);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.bucketId = new ResourceLocation(nbt.func_74779_i("bucketId"));
        this.sizeX = nbt.func_74760_g("sizeX");
        this.sizeY = nbt.func_74760_g("sizeY");
        this.sizeZ = nbt.func_74760_g("sizeZ");
        this.minTokensPerTick = nbt.func_74762_e("minTokensPerTick");
        this.maxTokensPerTick = nbt.func_74762_e("maxTokensPerTick");
        this.limitMultiplier = nbt.func_74769_h("limitMultiplier");
        this.tokensConsumedPerTick = nbt.func_74769_h("tokensConsumedPerTick");
        this.lastCheckedTime = nbt.func_74763_f("lastCheckedTime");
        this.consumedTokenFraction = nbt.func_74769_h("consumedTokenFraction");
    }

    public long consume() {
        long worldTime;
        long ticks;
        double consumedTokens;
        long wholeConsumedTokens;
        if (this.world == null || this.pos == null || this.bucketId == null) {
            return 0L;
        }
        BetweenlandsWorldStorage storage = BetweenlandsWorldStorage.forWorld(this.world);
        ILocalStorageHandler handler = storage.getLocalStorageHandler();
        LocationTokenBucket tokenBucket = null;
        AxisAlignedBB posAabb = new AxisAlignedBB(this.pos);
        List<LocationTokenBucket> locations = handler.getLocalStorages(LocationTokenBucket.class, posAabb, location -> this.bucketId.equals((Object)location.getBucketId()));
        if (!locations.isEmpty()) {
            tokenBucket = locations.get(0);
        }
        if (tokenBucket == null && !this.world.field_72995_K) {
            tokenBucket = new LocationTokenBucket((IWorldStorage)storage, (StorageID)new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(this.pos), posAabb.func_72314_b((double)(this.sizeX * 0.5f - 0.49f), (double)(this.sizeY * 0.5f - 0.49f), (double)(this.sizeZ * 0.5f - 0.49f)), this.bucketId);
            tokenBucket.setTokensPerTick(this.minTokensPerTick, this.maxTokensPerTick);
            tokenBucket.setLimitMultiplier(this.limitMultiplier);
            handler.addLocalStorage(tokenBucket);
        }
        if (tokenBucket != null && (wholeConsumedTokens = (long)MathHelper.func_76128_c((double)(consumedTokens = (double)(ticks = Math.max((worldTime = this.world.func_82737_E()) - this.lastCheckedTime, 0L)) * this.tokensConsumedPerTick + this.consumedTokenFraction))) > 0L) {
            this.lastCheckedTime = worldTime;
            this.consumedTokenFraction = consumedTokens - (double)wholeConsumedTokens;
            tokenBucket.refreshTicket(new ResourceLocation(this.bucketId.func_110624_b(), String.format("%d_%d_%d", this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p())), posAabb);
            return tokenBucket.consumeTokens(wholeConsumedTokens);
        }
        return 0L;
    }
}

