/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.location;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.math.BlockPos;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageID;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationGuarded;

public class LocationSpiritTree
extends LocationGuarded {
    private List<BlockPos> notGeneratedWispPositions = new ArrayList<BlockPos>();
    private List<BlockPos> generatedWispPositions = new ArrayList<BlockPos>();
    private List<BlockPos> largeFacePositions = new ArrayList<BlockPos>();
    private List<BlockPos> smallFacePositions = new ArrayList<BlockPos>();

    public LocationSpiritTree(IWorldStorage worldStorage, StorageID id, LocalRegion region) {
        super(worldStorage, id, region, "spirit_tree", EnumLocationType.SPIRIT_TREE);
    }

    public void addLargeFacePosition(BlockPos pos) {
        this.largeFacePositions.add(pos);
        this.setDirty(true);
    }

    public void addSmallFacePosition(BlockPos pos) {
        this.smallFacePositions.add(pos);
        this.setDirty(true);
    }

    public List<BlockPos> getLargeFacePositions() {
        return Collections.unmodifiableList(this.largeFacePositions);
    }

    public List<BlockPos> getSmallFacePositions() {
        return Collections.unmodifiableList(this.smallFacePositions);
    }

    public void addGeneratedWispPosition(BlockPos pos) {
        this.generatedWispPositions.add(pos);
        this.setDirty(true);
    }

    public List<BlockPos> getGeneratedWispPositions() {
        return Collections.unmodifiableList(this.generatedWispPositions);
    }

    public void addNotGeneratedWispPosition(BlockPos pos) {
        this.notGeneratedWispPositions.add(pos);
        this.setDirty(true);
    }

    public List<BlockPos> getNotGeneratedWispPositions() {
        return Collections.unmodifiableList(this.notGeneratedWispPositions);
    }

    public int getActiveWisps() {
        int i = 0;
        for (BlockPos pos : this.notGeneratedWispPositions) {
            if (this.getWorldStorage().getWorld().func_180495_p(pos).func_177230_c() != BlockRegistry.WISP) continue;
            ++i;
        }
        for (BlockPos pos : this.generatedWispPositions) {
            if (this.getWorldStorage().getWorld().func_180495_p(pos).func_177230_c() != BlockRegistry.WISP) continue;
            ++i;
        }
        return i;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        this.saveBlockList(nbt, "generatedWispPositions", this.generatedWispPositions);
        this.saveBlockList(nbt, "notGeneratedWispPositions", this.notGeneratedWispPositions);
        this.saveBlockList(nbt, "largeFacePositions", this.largeFacePositions);
        this.saveBlockList(nbt, "smallFacePositions", this.smallFacePositions);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.readBlockList(nbt, "generatedWispPositions", this.generatedWispPositions);
        this.readBlockList(nbt, "notGeneratedWispPositions", this.notGeneratedWispPositions);
        this.readBlockList(nbt, "largeFacePositions", this.largeFacePositions);
        this.readBlockList(nbt, "smallFacePositions", this.smallFacePositions);
    }

    protected void saveBlockList(NBTTagCompound nbt, String name, List<BlockPos> blocks) {
        NBTTagList blockList = new NBTTagList();
        for (BlockPos pos : blocks) {
            blockList.func_74742_a((NBTBase)new NBTTagLong(pos.func_177986_g()));
        }
        nbt.func_74782_a(name, (NBTBase)blockList);
    }

    protected void readBlockList(NBTTagCompound nbt, String name, List<BlockPos> blocks) {
        blocks.clear();
        NBTTagList blockList = nbt.func_150295_c(name, 4);
        for (int i = 0; i < blockList.func_74745_c(); ++i) {
            NBTTagLong posNbt = (NBTTagLong)blockList.func_179238_g(i);
            blocks.add(BlockPos.func_177969_a((long)posNbt.func_150291_c()));
        }
    }
}

