/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.world.storage.LocalRegionData;
import thebetweenlands.common.world.storage.LocalStorageHandlerImpl;

public class LocalRegionCache {
    private final Map<LocalRegion, LocalRegionData> regionData = new HashMap<LocalRegion, LocalRegionData>();
    private final File dir;
    private final LocalStorageHandlerImpl handler;

    public LocalRegionCache(LocalStorageHandlerImpl handler, File dir) {
        this.dir = dir;
        this.handler = handler;
    }

    public LocalStorageHandlerImpl getLocalStorageHandler() {
        return this.handler;
    }

    public File getDir() {
        return this.dir;
    }

    public LocalRegionData getOrCreateRegion(LocalRegion region) {
        return this.getOrCreateRegion(region, true);
    }

    @Nullable
    public LocalRegionData getOrCreateRegion(LocalRegion region, boolean create) {
        LocalRegionData data = this.regionData.get(region);
        if (data == null && (data = LocalRegionData.getOrCreateRegion(this, this.dir, region, create)) != null) {
            this.regionData.put(region, data);
        }
        return data;
    }

    @Nullable
    public LocalRegionData getCachedRegion(LocalRegion region) {
        return this.regionData.get(region);
    }

    public void removeRegion(LocalRegion region) {
        this.regionData.remove(region);
    }

    public void saveAllRegions() {
        ArrayList<LocalRegionData> unloadRegions = new ArrayList<LocalRegionData>();
        for (LocalRegionData data : this.regionData.values()) {
            if (data.isDirty()) {
                data.saveRegion(this.dir);
            }
            if (data.hasReferences()) continue;
            unloadRegions.add(data);
        }
        for (LocalRegionData unloadRegion : unloadRegions) {
            TheBetweenlands.logger.warn(String.format("Unloading dangling local storage region %s. This should not happen...", unloadRegion.getID()));
            this.removeRegion(unloadRegion.getRegion());
        }
    }

    public void clearCache() {
        this.regionData.clear();
    }

    public Map<LocalRegion, LocalRegionData> getRegions() {
        return Collections.unmodifiableMap(this.regionData);
    }
}

