/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage;

import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.spawning.IBiomeSpawnEntriesData;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntriesProvider;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntry;
import thebetweenlands.api.environment.IEnvironmentEvent;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.registries.BiomeRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.biome.BiomeBetweenlands;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.storage.SpiritTreeKillToken;
import thebetweenlands.common.world.storage.WorldStorageImpl;

public class BetweenlandsWorldStorage
extends WorldStorageImpl {
    private BLEnvironmentEventRegistry environmentEventRegistry;
    private AspectManager aspectManager = new AspectManager();
    private Map<ICustomSpawnEntriesProvider, BiomeSpawnEntriesData> biomeSpawnEntriesData = new HashMap<ICustomSpawnEntriesProvider, BiomeSpawnEntriesData>();
    protected final Set<ChunkPos> previousCheckedAmbientChunks = new HashSet<ChunkPos>();
    protected int ambienceTicks;
    protected int updateLCG = new Random().nextInt();
    protected List<SpiritTreeKillToken> spiritTreeKillTokens = new ArrayList<SpiritTreeKillToken>();

    public BLEnvironmentEventRegistry getEnvironmentEventRegistry() {
        return this.environmentEventRegistry;
    }

    public AspectManager getAspectManager() {
        return this.aspectManager;
    }

    @Override
    public BiomeSpawnEntriesData getBiomeSpawnEntriesData(Biome biome) {
        if (biome instanceof ICustomSpawnEntriesProvider) {
            ICustomSpawnEntriesProvider provider = (ICustomSpawnEntriesProvider)biome;
            BiomeSpawnEntriesData data = this.biomeSpawnEntriesData.get(provider);
            if (data == null) {
                data = new BiomeSpawnEntriesData(provider);
                this.biomeSpawnEntriesData.put(provider, data);
            }
            return data;
        }
        return null;
    }

    @Override
    protected void init() {
        this.environmentEventRegistry = new BLEnvironmentEventRegistry(this.getWorld());
        this.environmentEventRegistry.init();
        if (!this.getWorld().field_72995_K) {
            for (IEnvironmentEvent event : this.environmentEventRegistry.getEvents().values()) {
                event.setDefaults();
                event.setLoaded();
            }
            this.aspectManager.loadAndPopulateStaticAspects(null, AspectManager.getAspectsSeed(this.getWorld().func_72912_H().func_76063_b()));
        }
        this.ambienceTicks = this.getWorld().field_73012_v.nextInt(7000);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        if (!this.getWorld().field_72995_K) {
            void var3_7;
            for (IEnvironmentEvent iEnvironmentEvent : this.environmentEventRegistry.getEvents().values()) {
                iEnvironmentEvent.readFromNBT(nbt);
            }
            this.environmentEventRegistry.setDisabled(nbt.func_74767_n("eventsDisabled"));
            this.aspectManager.loadAndPopulateStaticAspects(nbt.func_74775_l("itemAspects"), AspectManager.getAspectsSeed(this.getWorld().func_72912_H().func_76063_b()));
            this.biomeSpawnEntriesData.clear();
            if (nbt.func_150297_b("biomeData", 10)) {
                NBTTagCompound biomesNbt = nbt.func_74775_l("biomeData");
                for (String key : biomesNbt.func_150296_c()) {
                    Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(key));
                    if (!(biome instanceof ICustomSpawnEntriesProvider)) continue;
                    this.getBiomeSpawnEntriesData(biome).readFromNbt(biomesNbt.func_74775_l(key));
                }
            }
            this.spiritTreeKillTokens.clear();
            NBTTagList spiritTreeKillTokensNbt = nbt.func_150295_c("spiritTreeKillTokens", 10);
            boolean bl = false;
            while (var3_7 < spiritTreeKillTokensNbt.func_74745_c()) {
                this.spiritTreeKillTokens.add(SpiritTreeKillToken.readFromNBT(spiritTreeKillTokensNbt.func_150305_b((int)var3_7)));
                ++var3_7;
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        if (!this.getWorld().field_72995_K) {
            for (IEnvironmentEvent event : this.environmentEventRegistry.getEvents().values()) {
                event.writeToNBT(nbt);
            }
            nbt.func_74757_a("eventsDisabled", this.environmentEventRegistry.isDisabled());
            NBTTagCompound aspectData = new NBTTagCompound();
            this.aspectManager.saveStaticAspects(aspectData);
            nbt.func_74782_a("itemAspects", (NBTBase)aspectData);
            NBTTagCompound biomesNbt = new NBTTagCompound();
            for (BiomeBetweenlands biome : BiomeRegistry.REGISTERED_BIOMES) {
                NBTTagCompound biomeSpawnEntriesNbt = new NBTTagCompound();
                this.getBiomeSpawnEntriesData(biome).writeToNbt(biomeSpawnEntriesNbt);
                biomesNbt.func_74782_a(biome.getRegistryName().toString(), (NBTBase)biomeSpawnEntriesNbt);
            }
            nbt.func_74782_a("biomeData", (NBTBase)biomesNbt);
            NBTTagList spiritTreeKillTokensNbt = new NBTTagList();
            for (SpiritTreeKillToken token : this.spiritTreeKillTokens) {
                spiritTreeKillTokensNbt.func_74742_a((NBTBase)token.writeToNBT());
            }
            nbt.func_74782_a("spiritTreeKillTokens", (NBTBase)spiritTreeKillTokensNbt);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getWorld().field_72995_K && this.getWorld().field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
            this.updateAmbientCaveSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateAmbientCaveSounds() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player != null) {
            HashSet<ChunkPos> closeChunks = new HashSet<ChunkPos>();
            int cx = MathHelper.func_76128_c((double)(player.field_70165_t / 16.0));
            int cz = MathHelper.func_76128_c((double)(player.field_70161_v / 16.0));
            int chunkRadius = 3;
            for (int ox = -chunkRadius; ox <= chunkRadius; ++ox) {
                for (int oz = -chunkRadius; oz <= chunkRadius; ++oz) {
                    closeChunks.add(new ChunkPos(ox + cx, oz + cz));
                }
            }
            if (this.ambienceTicks > 0) {
                --this.ambienceTicks;
            } else {
                this.previousCheckedAmbientChunks.retainAll(closeChunks);
                if (this.previousCheckedAmbientChunks.size() >= closeChunks.size()) {
                    this.previousCheckedAmbientChunks.clear();
                }
                int checkedChunks = 0;
                for (ChunkPos chunkpos : closeChunks) {
                    if (this.previousCheckedAmbientChunks.contains(chunkpos)) continue;
                    int bx = chunkpos.field_77276_a * 16;
                    int bz = chunkpos.field_77275_b * 16;
                    Chunk chunk = this.getWorld().func_72964_e(chunkpos.field_77276_a, chunkpos.field_77275_b);
                    if (this.playAmbientCaveSounds((EntityPlayer)player, bx, bz, chunk)) break;
                    this.previousCheckedAmbientChunks.add(chunkpos);
                    if (++checkedChunks < 6) continue;
                    break;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean playAmbientCaveSounds(EntityPlayer player, int x, int z, Chunk chunk) {
        double dst;
        World world = this.getWorld();
        this.updateLCG = this.updateLCG * 3 + 1013904223;
        int rnd = this.updateLCG >> 2;
        int xo = rnd & 0xF;
        int y = rnd >> 16 & 0xFF;
        int zo = rnd >> 8 & 0xF;
        BlockPos pos = new BlockPos(xo + x, y, zo + z);
        IBlockState state = chunk.func_177435_g(pos);
        if (state.func_185904_a() == Material.field_151579_a && world.func_175699_k(pos) <= world.field_73012_v.nextInt(8) && world.func_175642_b(EnumSkyBlock.SKY, pos) <= 0 && (dst = player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5)) > 4.0 && dst < 256.0) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (SoundEvent)SoundRegistry.AMBIENT_CAVE_SPOOK, SoundCategory.AMBIENT, 0.85f, 0.8f + world.field_73012_v.nextFloat() * 0.2f, false);
            this.ambienceTicks = world.field_73012_v.nextInt(7000) + 3000;
            return true;
        }
        return false;
    }

    public static BetweenlandsWorldStorage forWorld(World world) {
        BetweenlandsWorldStorage storage = BetweenlandsWorldStorage.forWorldNullable(world);
        if (storage == null) {
            throw new RuntimeException(String.format("World %s (%s) does not have BetweenlandsWorldStorage capability", world.func_72912_H().func_76065_j(), world.field_73011_w.getClass().getName()));
        }
        return storage;
    }

    @Nullable
    public static BetweenlandsWorldStorage forWorldNullable(World world) {
        IWorldStorage storage = (IWorldStorage)world.getCapability(CAPABILITY_INSTANCE, null);
        if (storage instanceof BetweenlandsWorldStorage) {
            return (BetweenlandsWorldStorage)storage;
        }
        return null;
    }

    public List<SpiritTreeKillToken> getSpiritTreeKillTokens() {
        return this.spiritTreeKillTokens;
    }

    public static class BiomeSpawnEntriesData
    implements IBiomeSpawnEntriesData {
        public final ICustomSpawnEntriesProvider biome;
        private final TObjectLongMap<ResourceLocation> lastSpawnMap = new TObjectLongHashMap();

        protected BiomeSpawnEntriesData(ICustomSpawnEntriesProvider biome) {
            this.biome = biome;
        }

        @Override
        public long getLastSpawn(ICustomSpawnEntry spawnEntry) {
            return this.lastSpawnMap.containsKey((Object)spawnEntry.getID()) ? this.lastSpawnMap.get((Object)spawnEntry.getID()) : -1L;
        }

        @Override
        public void setLastSpawn(ICustomSpawnEntry spawnEntry, long lastSpawn) {
            this.lastSpawnMap.put((Object)spawnEntry.getID(), lastSpawn);
        }

        @Override
        public long removeLastSpawn(ICustomSpawnEntry spawnEntry) {
            return this.lastSpawnMap.remove((Object)spawnEntry.getID());
        }

        public void readFromNbt(NBTTagCompound nbt) {
            this.lastSpawnMap.clear();
            for (ICustomSpawnEntry spawnEntry : this.biome.getCustomSpawnEntries()) {
                if (!spawnEntry.isSaved() || !nbt.func_150297_b(spawnEntry.getID().toString(), 4)) continue;
                this.lastSpawnMap.put((Object)spawnEntry.getID(), nbt.func_74763_f(spawnEntry.getID().toString()));
            }
        }

        public void writeToNbt(NBTTagCompound nbt) {
            for (ICustomSpawnEntry spawnEntry : this.biome.getCustomSpawnEntries()) {
                if (!spawnEntry.isSaved() || !this.lastSpawnMap.containsKey((Object)spawnEntry.getID())) continue;
                nbt.func_74772_a(spawnEntry.getID().toString(), this.lastSpawnMap.get((Object)spawnEntry.getID()));
            }
        }
    }
}

