/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.tree;

import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.block.terrain.BlockLeavesBetweenlands;
import thebetweenlands.common.registries.BlockRegistry;

public class WorldGenSapTree
extends WorldGenerator {
    private IBlockState logX;
    private IBlockState logY;
    private IBlockState logZ;
    private IBlockState roots;
    private IBlockState leaves;

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int height = rand.nextInt(3) + 16;
        int maxRadius = 6;
        this.logX = BlockRegistry.LOG_SAP.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
        this.logY = BlockRegistry.LOG_SAP.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
        this.logZ = BlockRegistry.LOG_SAP.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
        this.roots = BlockRegistry.LOG_SAP.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        this.leaves = BlockRegistry.LEAVES_SAP_TREE.func_176223_P().func_177226_a((IProperty)BlockLeavesBetweenlands.field_176236_b, (Comparable)Boolean.valueOf(false));
        for (int xx = -maxRadius; xx <= maxRadius; ++xx) {
            for (int zz = -maxRadius; zz <= maxRadius; ++zz) {
                for (int yy = 2; yy < height; ++yy) {
                    if (world.func_175623_d(pos.func_177982_a(xx, yy, zz)) || world.func_180495_p(pos.func_177982_a(xx, yy, zz)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        for (int yy = 0; yy < height; ++yy) {
            world.func_180501_a(pos.func_177982_a(0, yy, 0), this.logY, 2);
            if (yy == 0) {
                this.createRoots(world, pos);
            }
            if (yy == height - 1) {
                this.createLeaves(world, pos.func_177982_a(0, yy, 0), true);
            }
            if (yy == height - 8 || yy == height - 12) {
                if (rand.nextBoolean()) {
                    this.createBranch(world, rand, pos.func_177982_a(1, yy - rand.nextInt(2), 0), 1, 2);
                    this.createBranch(world, rand, pos.func_177982_a(-1, yy - rand.nextInt(2), 0), 2, 2);
                    this.createBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), 1), 3, 2);
                    this.createBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), -1), 4, 2);
                } else {
                    this.createBranch(world, rand, pos.func_177982_a(2, yy - rand.nextInt(2), 2), 5, 2);
                    this.createBranch(world, rand, pos.func_177982_a(-2, yy - rand.nextInt(2), -2), 6, 2);
                    this.createBranch(world, rand, pos.func_177982_a(-2, yy - rand.nextInt(2), 2), 7, 2);
                    this.createBranch(world, rand, pos.func_177982_a(2, yy - rand.nextInt(2), -2), 8, 2);
                }
            }
            if (yy != height - 4) continue;
            if (rand.nextBoolean()) {
                this.createBranch(world, rand, pos.func_177982_a(1, yy - rand.nextInt(2), 0), 1, 1);
                this.createBranch(world, rand, pos.func_177982_a(-1, yy - rand.nextInt(2), 0), 2, 1);
                this.createBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), 1), 3, 1);
                this.createBranch(world, rand, pos.func_177982_a(0, yy - rand.nextInt(2), -1), 4, 1);
                continue;
            }
            this.createBranch(world, rand, pos.func_177982_a(2, yy - rand.nextInt(2), 2), 5, 1);
            this.createBranch(world, rand, pos.func_177982_a(-2, yy - rand.nextInt(2), -2), 6, 1);
            this.createBranch(world, rand, pos.func_177982_a(-2, yy - rand.nextInt(2), 2), 7, 1);
            this.createBranch(world, rand, pos.func_177982_a(2, yy - rand.nextInt(2), -2), 8, 1);
        }
        return true;
    }

    private void createBranch(World world, Random rand, BlockPos pos, int dir, int branchLength) {
        boolean branchBend = false;
        int y = 0;
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= 1) {
                ++y;
                branchBend = true;
            }
            if (dir == 1) {
                world.func_180501_a(pos.func_177982_a(i, y, 0), branchBend ? this.logY : this.logX, 2);
                if (i == branchLength) {
                    this.createLeaves(world, pos.func_177982_a(i, y, 0), false);
                }
            }
            if (dir == 2) {
                world.func_180501_a(pos.func_177982_a(-i, y, 0), branchBend ? this.logY : this.logX, 2);
                if (i == branchLength) {
                    this.createLeaves(world, pos.func_177982_a(-i, y, 0), false);
                }
            }
            if (dir == 3) {
                world.func_180501_a(pos.func_177982_a(0, y, i), branchBend ? this.logY : this.logZ, 2);
                if (i == branchLength) {
                    this.createLeaves(world, pos.func_177982_a(0, y, i), false);
                }
            }
            if (dir == 4) {
                world.func_180501_a(pos.func_177982_a(0, y, -i), branchBend ? this.logY : this.logZ, 2);
                if (i == branchLength) {
                    this.createLeaves(world, pos.func_177982_a(0, y, -i), false);
                }
            }
            if (dir == 5) {
                world.func_180501_a(pos.func_177982_a(i - 1, y, i - 1), branchBend ? this.logY : this.logX, 2);
                if (i == branchLength) {
                    this.createLeaves(world, pos.func_177982_a(i - 1, y, i - 1), false);
                }
            }
            if (dir == 6) {
                world.func_180501_a(pos.func_177982_a(-i + 1, y, -i + 1), branchBend ? this.logY : this.logX, 2);
                if (i == branchLength) {
                    this.createLeaves(world, pos.func_177982_a(-i + 1, y, -i + 1), false);
                }
            }
            if (dir == 7) {
                world.func_180501_a(pos.func_177982_a(-i + 1, y, i - 1), branchBend ? this.logY : this.logZ, 2);
                if (i == branchLength) {
                    this.createLeaves(world, pos.func_177982_a(-i + 1, y, i - 1), false);
                }
            }
            if (dir != 8) continue;
            world.func_180501_a(pos.func_177982_a(i - 1, y, -i + 1), branchBend ? this.logY : this.logZ, 2);
            if (i != branchLength) continue;
            this.createLeaves(world, pos.func_177982_a(i - 1, y, -i + 1), false);
        }
    }

    private void createLeaves(World world, BlockPos pos, boolean top) {
        world.func_180501_a(pos.func_177982_a(0, 0, 1), this.leaves, 2);
        world.func_180501_a(pos.func_177982_a(0, 0, -1), this.leaves, 2);
        world.func_180501_a(pos.func_177982_a(1, 0, 0), this.leaves, 2);
        world.func_180501_a(pos.func_177982_a(-1, 0, 0), this.leaves, 2);
        if (top) {
            world.func_180501_a(pos.func_177982_a(0, 1, 0), this.leaves, 2);
        } else {
            world.func_180501_a(pos.func_177982_a(0, -1, 0), this.leaves, 2);
        }
    }

    private void createRoots(World world, BlockPos pos) {
        world.func_180501_a(pos.func_177982_a(0, 0, 1), this.roots, 2);
        world.func_180501_a(pos.func_177982_a(0, 0, -1), this.roots, 2);
        world.func_180501_a(pos.func_177982_a(1, 0, 0), this.roots, 2);
        world.func_180501_a(pos.func_177982_a(-1, 0, 0), this.roots, 2);
    }
}

