/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.common.block.container.BlockLootPot;
import thebetweenlands.common.block.container.BlockMudLootPot;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.tile.TileEntityLootPot;
import thebetweenlands.common.tile.spawner.MobSpawnerLogicBetweenlands;
import thebetweenlands.common.tile.spawner.TileEntityMobSpawnerBetweenlands;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;
import thebetweenlands.common.world.gen.feature.WorldGenHelper;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class WorldGenUnderwaterRuins
extends WorldGenHelper {
    private final IBlockState cragrockBrick = BlockRegistry.CRAGROCK_BRICKS.func_176223_P();
    private final IBlockState cragrockBrickCracked = BlockRegistry.CRAGROCK_BRICKS_CRACKED.func_176223_P();
    private final IBlockState cragrockBrickMossy = BlockRegistry.CRAGROCK_BRICKS_MOSSY.func_176223_P();
    private final IBlockState cragrockTile = BlockRegistry.CRAGROCK_TILES.func_176223_P();
    private final IBlockState cragrockTileCracked = BlockRegistry.CRAGROCK_TILES_CRACKED.func_176223_P();
    private final IBlockState cragrockTileMossy = BlockRegistry.CRAGROCK_TILES_MOSSY.func_176223_P();
    private final IBlockState cragrockChisel = BlockRegistry.CRAGROCK_CHISELED.func_176223_P();
    private final IBlockState cragrockBrickStairs = BlockRegistry.CRAGROCK_BRICK_STAIRS.func_176223_P();
    private static final List<IBlockState> UNDERWATER_PLANTS = ImmutableList.of((Object)BlockRegistry.SWAMP_REED_UNDERWATER.func_176223_P(), (Object)BlockRegistry.WATER_WEEDS.func_176223_P(), (Object)BlockRegistry.SWAMP_KELP.func_176223_P());

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        boolean generated;
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        LocationStorage locationStorage = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(position), "underwater_ruins", EnumLocationType.RUINS);
        switch (rand.nextInt(5)) {
            case 1: {
                generated = this.structureArch(world, rand, position);
                break;
            }
            case 2: {
                generated = this.structurePillars(world, rand, position);
                break;
            }
            case 3: {
                generated = this.structureRing(world, rand, position);
                break;
            }
            case 4: {
                generated = this.structureShrine(world, rand, position);
                break;
            }
            default: {
                generated = this.structureShelter(world, rand, position);
            }
        }
        if (generated) {
            for (int x = -8; x <= 8; ++x) {
                for (int z = -8; z <= 8; ++z) {
                    if (rand.nextInt(4) != 0) continue;
                    IBlockState plant = UNDERWATER_PLANTS.get(rand.nextInt(UNDERWATER_PLANTS.size()));
                    BlockPos pos = position.func_177982_a(x, 0, z);
                    if (plant == BlockRegistry.SWAMP_REED_UNDERWATER.func_176223_P() || plant == BlockRegistry.SWAMP_KELP.func_176223_P()) {
                        BlockPos plantPos;
                        IBlockState state;
                        if (!SurfaceType.DIRT.matches(world.func_180495_p(pos))) continue;
                        int height = rand.nextInt(6) + 3;
                        for (int y = 0; y <= height && ((state = world.func_180495_p(plantPos = pos.func_177981_b(y + 1))).func_177230_c() == Blocks.field_150350_a || SurfaceType.WATER.matches(state)); ++y) {
                            if (!SurfaceType.WATER.matches(state) || !state.func_177230_c().func_176200_f((IBlockAccess)world, plantPos)) continue;
                            world.func_180501_a(plantPos, plant, 18);
                        }
                        continue;
                    }
                    IBlockState state = world.func_180495_p(pos.func_177984_a());
                    if (!SurfaceType.DIRT.matches(world.func_180495_p(pos)) || !SurfaceType.WATER.matches(state) || !state.func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a())) continue;
                    world.func_180501_a(pos.func_177984_a(), plant, 18);
                }
            }
            locationStorage.addBounds(new AxisAlignedBB(position.func_177981_b(4)).func_72314_b(8.0, 4.0, 8.0));
            locationStorage.setLayer(0);
            locationStorage.setSeed(world.func_72905_C());
            locationStorage.setVisible(true);
            locationStorage.setDirty(true);
            worldStorage.getLocalStorageHandler().addLocalStorage(locationStorage);
        }
        return generated;
    }

    private boolean structureRing(World world, Random rand, BlockPos position) {
        int ringsize = MathHelper.func_76125_a((int)(rand.nextInt(6) + 2), (int)4, (int)7);
        int center = ringsize / 2;
        int pillarheight = ringsize + rand.nextInt(3);
        if (!this.checkValidSpace(world, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), ringsize, pillarheight + 1, ringsize)) {
            return false;
        }
        for (int fx = -center; fx <= center; ++fx) {
            for (int fz = -center; fz <= center; ++fz) {
                world.func_180501_a(position.func_177982_a(fx, 0, fz), this.getTileGrade(rand), 18);
                if (fx > -center + 1 && fx < center - 1 && fx != 0 && fz != 0 && rand.nextInt(7) == 0) {
                    this.setLootPot(world, rand, position.func_177982_a(fx, 1, fz));
                }
                if (Math.abs(fx) != center || Math.abs(fz) != center) {
                    if (Math.abs(fx) == center || Math.abs(fz) == center) {
                        world.func_180501_a(position.func_177982_a(fx, 1, fz), this.getBrickGrade(rand), 18);
                        if (rand.nextInt(5) == 0) {
                            this.setLootPot(world, rand, position.func_177982_a(fx, 2, fz));
                        }
                    }
                } else {
                    this.buildPillar(world, rand, position.func_177982_a(fx, 1, fz), pillarheight);
                }
                if (ringsize < 7 || fx != 0 || fz != 0) continue;
                this.buildPillar(world, rand, position.func_177982_a(fx, 1, fz), ringsize);
            }
        }
        return true;
    }

    private void buildPillar(World world, Random rand, BlockPos pos, int height) {
        for (int y = 0; y <= height; ++y) {
            world.func_180501_a(pos.func_177982_a(0, y, 0), this.getTileGrade(rand), 18);
        }
        if (rand.nextInt(4) == 0) {
            this.setLootPot(world, rand, pos.func_177982_a(0, height + 1, 0));
        }
    }

    private boolean structurePillars(World world, Random rand, BlockPos position) {
        if (!this.checkValidSpace(world, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), 7, 9, 7)) {
            return false;
        }
        int basepillar = 3;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (rand.nextInt(3) == 0) {
                    world.func_180501_a(position.func_177982_a(x, 0, z), this.getTileGrade(rand), 18);
                }
                if (rand.nextInt(8) != 0) continue;
                this.setMudLootPot(world, rand, position.func_177982_a(x, 0, z));
            }
        }
        world.func_180501_a(position.func_177982_a(-1, 0, 0), this.getBrickGrade(rand), 18);
        world.func_180501_a(position.func_177982_a(1, 0, 0), this.getBrickGrade(rand), 18);
        world.func_180501_a(position.func_177982_a(0, 0, -1), this.getBrickGrade(rand), 18);
        world.func_180501_a(position.func_177982_a(0, 0, 1), this.getBrickGrade(rand), 18);
        position.func_177982_a(0, 1, 0);
        this.buildPillar2(world, rand, position.func_177982_a(0, 0, -3), rand.nextInt(6) + basepillar);
        this.buildPillar2(world, rand, position.func_177982_a(2, 0, -2), rand.nextInt(6) + basepillar);
        this.buildPillar2(world, rand, position.func_177982_a(3, 0, 0), rand.nextInt(6) + basepillar);
        this.buildPillar2(world, rand, position.func_177982_a(2, 0, 2), rand.nextInt(6) + basepillar);
        this.buildPillar2(world, rand, position.func_177982_a(0, 0, 3), rand.nextInt(6) + basepillar);
        this.buildPillar2(world, rand, position.func_177982_a(-2, 0, 2), rand.nextInt(6) + basepillar);
        this.buildPillar2(world, rand, position.func_177982_a(-3, 0, 0), rand.nextInt(6) + basepillar);
        this.buildPillar2(world, rand, position.func_177982_a(-2, 0, -2), rand.nextInt(6) + basepillar);
        return true;
    }

    private void buildPillar2(World world, Random rand, BlockPos pos, int height) {
        for (int y = 0; y <= height; ++y) {
            world.func_180501_a(pos.func_177982_a(0, y, 0), y == height ? this.cragrockChisel : this.getTileGrade(rand), 18);
        }
        if (rand.nextInt(4) == 0) {
            this.setLootPot(world, rand, pos.func_177982_a(0, height + 1, 0));
        }
    }

    private boolean structureArch(World world, Random rand, BlockPos pos) {
        boolean west;
        boolean east;
        boolean south;
        boolean north;
        if (!this.checkValidSpace(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 7, 7, 7)) {
            return false;
        }
        do {
            north = this.buildArch(world, rand, pos.func_177982_a(1, 0, 1), EnumFacing.NORTH);
            east = this.buildArch(world, rand, pos.func_177982_a(1, 0, 0), EnumFacing.EAST);
            south = this.buildArch(world, rand, pos, EnumFacing.SOUTH);
            west = this.buildArch(world, rand, pos.func_177982_a(0, 0, 1), EnumFacing.WEST);
        } while (!north && !south && !east && !west);
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                if (rand.nextInt(9) != 0) continue;
                world.func_180501_a(pos.func_177982_a(x, 0, z), BlockRegistry.PEARL_BLOCK.func_176223_P(), 18);
            }
        }
        return true;
    }

    private boolean buildArch(World world, Random rand, BlockPos pos, EnumFacing directionIn) {
        if (rand.nextBoolean()) {
            int direction = directionIn.func_176736_b();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            this.rotatedCubeVolume(world, x, y, z, 0, 0, -3, this.getBrickGrade(rand), 1, 4, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 0, 4, -3, this.getStateFromRotation(3, direction, this.cragrockBrickStairs, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 0, 4, -2, this.getStateFromRotation(1, direction, this.cragrockBrickStairs, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 0, 5, -2, this.getStateFromRotation(3, direction, this.cragrockBrickStairs, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
            this.rotatedCubeVolume(world, x, y, z, 0, 5, -1, this.getStateFromRotation(1, direction, this.cragrockBrickStairs, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
            return true;
        }
        return false;
    }

    private boolean structureShelter(World world, Random random, BlockPos pos) {
        boolean basement;
        int length = (random.nextInt(3) + 7) / 2;
        int width = (random.nextInt(3) + 7) / 2;
        boolean bl = basement = random.nextInt(5) == 0;
        if (!this.checkValidSpace(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), length * 2, 5, width * 2)) {
            return false;
        }
        for (int x = -length; x <= length; ++x) {
            for (int z = -width; z <= width; ++z) {
                world.func_180501_a(pos.func_177982_a(x, 0, z), this.getTileGrade(random), 18);
                if (Math.abs(x) == length || Math.abs(z) == width) {
                    int height = random.nextInt(3) + 2;
                    for (int y = 0; y <= height; ++y) {
                        world.func_180501_a(pos.func_177982_a(x, y + 1, z), this.getBrickGrade(random), 18);
                    }
                }
                if ((Math.abs(x) != length || Math.abs(z) != width) && random.nextInt(10) == 0) {
                    this.setMudLootPot(world, random, pos.func_177982_a(x, 0, z));
                }
                if (!basement) continue;
                for (int y = -1; y >= -3; --y) {
                    if (Math.abs(x) == length || Math.abs(z) == width) {
                        world.func_180501_a(pos.func_177982_a(x, y, z), this.getBrickGrade(random), 18);
                    } else if (y == -3) {
                        world.func_180501_a(pos.func_177982_a(x, y, z), this.getTileGrade(random), 18);
                    } else {
                        world.func_175656_a(pos.func_177982_a(x, y, z), BlockRegistry.SWAMP_WATER.func_176223_P());
                    }
                    if (Math.abs(x) == length && Math.abs(z) == width || y != -2 || random.nextInt(3) != 0) continue;
                    this.setLootPot(world, random, pos.func_177982_a(x, y, z));
                }
            }
        }
        return true;
    }

    private boolean structureShrine(World world, Random random, BlockPos pos) {
        int basepillar = 5;
        if (!this.checkValidSpace(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 10, basepillar + 5, 10)) {
            return false;
        }
        for (int fx = -4; fx <= 4; ++fx) {
            for (int fz = -4; fz <= 4; ++fz) {
                if (!random.nextBoolean()) continue;
                world.func_180501_a(pos.func_177982_a(fx, 0, fz), this.getTileGrade(random), 18);
            }
        }
        this.buildPillar3(world, random, pos.func_177982_a(-2, 0, -5), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(0, 0, -5), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(2, 0, -5), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(-5, 0, -2), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(-5, 0, 0), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(-5, 0, 2), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(-2, 0, 5), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(0, 0, 5), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(2, 0, 5), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(5, 0, -2), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(5, 0, 0), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(5, 0, 2), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(-4, 0, -4), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(4, 0, -4), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(-4, 0, 4), random.nextInt(4) + basepillar);
        this.buildPillar3(world, random, pos.func_177982_a(4, 0, 4), random.nextInt(4) + basepillar);
        for (int sx = -2; sx <= 2; ++sx) {
            for (int sz = -2; sz <= 2; ++sz) {
                for (int sy = 1; sy <= 5; ++sy) {
                    if ((Math.abs(sx) != 2 || Math.abs(sz) != 2) && sy == 1) {
                        world.func_180501_a(pos.func_177982_a(sx, sy, sz), this.getTileGrade(random), 18);
                    }
                    if (Math.abs(sx) == 2 && Math.abs(sz) == 2 && sy <= 3) {
                        world.func_180501_a(pos.func_177982_a(sx, sy, sz), this.getBrickGrade(random), 18);
                    }
                    if (!(Math.abs(sx) == 2 && Math.abs(sz) == 2 || sy != 4 || Math.abs(sx) != 2 && Math.abs(sz) != 2)) {
                        world.func_180501_a(pos.func_177982_a(sx, sy, sz), this.getBrickGrade(random), 18);
                    }
                    if ((Math.abs(sx) == 2 && Math.abs(sz) == 0 || Math.abs(sx) == 0 && Math.abs(sz) == 2) && sy == 5) {
                        world.func_180501_a(pos.func_177982_a(sx, sy, sz), this.getBrickGrade(random), 18);
                    }
                    if (sx != 0 || sz != 0 || sy != 2) continue;
                    BlockPos spawnerpos = pos.func_177982_a(sx, sy, sz);
                    world.func_175656_a(spawnerpos, BlockRegistry.MOB_SPAWNER.func_176223_P());
                    TileEntity te = world.func_175625_s(spawnerpos);
                    if (!(te instanceof TileEntityMobSpawnerBetweenlands)) continue;
                    MobSpawnerLogicBetweenlands logic = ((TileEntityMobSpawnerBetweenlands)te).getSpawnerLogic();
                    logic.setNextEntityName("thebetweenlands:angler").setCheckRange(32.0).setSpawnRange(6).setSpawnInAir(false).setMaxEntities(1 + world.field_73012_v.nextInt(3));
                }
            }
        }
        return true;
    }

    private void buildPillar3(World world, Random rand, BlockPos pos, int height) {
        for (int y = 0; y <= height; ++y) {
            world.func_180501_a(pos.func_177982_a(0, y, 0), this.getBrickGrade(rand), 18);
        }
        if (rand.nextInt(4) == 0) {
            this.setLootPot(world, rand, pos.func_177982_a(0, height + 1, 0));
        }
    }

    private boolean checkValidSpace(World world, int posX, int posY, int posZ, int width, int height, int depth) {
        int x = width / 2;
        int z = depth / 2;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int mx = posX - x; mx <= posX + x; ++mx) {
            for (int mz = posZ - z; mz <= posZ + z; ++mz) {
                for (int my = posY; my <= posY + height; ++my) {
                    mutable.func_181079_c(mx, my, mz);
                    if (!(my <= posY + 1 ? !world.func_180495_p(mutable.func_177977_b()).func_185917_h() : !world.func_175623_d((BlockPos)mutable) && !world.func_180495_p((BlockPos)mutable).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)mutable))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private IBlockState getBrickGrade(Random rand) {
        switch (rand.nextInt(3)) {
            case 0: {
                return this.cragrockBrick;
            }
            case 1: {
                return this.cragrockBrickCracked;
            }
            case 2: {
                return this.cragrockBrickMossy;
            }
        }
        return this.cragrockBrick;
    }

    private IBlockState getTileGrade(Random rand) {
        switch (rand.nextInt(3)) {
            case 0: {
                return this.cragrockTile;
            }
            case 1: {
                return this.cragrockTileCracked;
            }
            case 2: {
                return this.cragrockTileMossy;
            }
        }
        return this.cragrockTile;
    }

    private void setLootPot(World world, Random random, BlockPos pos) {
        IBlockState loot = world.func_180495_p(pos) == BlockRegistry.SWAMP_WATER.func_176223_P() ? (random.nextInt(4) == 0 ? BlockRegistry.PEARL_BLOCK.func_176223_P() : this.getRandomMudPot(random)) : this.getRandomPot(random);
        this.func_175903_a(world, pos, loot);
        TileEntityLootPot lootPot = BlockLootPot.getTileEntity((IBlockAccess)world, pos);
        if (lootPot != null) {
            lootPot.setLootTable(LootTableRegistry.CAVE_POT, random.nextLong());
        }
    }

    private IBlockState getRandomPot(Random rand) {
        switch (rand.nextInt(3)) {
            case 1: {
                return BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_2));
            }
            case 2: {
                return BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_3));
            }
        }
        return BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_1));
    }

    private void setMudLootPot(World world, Random random, BlockPos pos) {
        this.func_175903_a(world, pos, this.getRandomMudPot(random));
        TileEntityLootPot lootPot = BlockLootPot.getTileEntity((IBlockAccess)world, pos);
        if (lootPot != null) {
            lootPot.setLootTable(LootTableRegistry.UNDERWATER_RUINS_POT, random.nextLong());
        }
    }

    private IBlockState getRandomMudPot(Random rand) {
        switch (rand.nextInt(3)) {
            case 1: {
                return BlockRegistry.MUD_LOOT_POT.func_176223_P().func_177226_a((IProperty)BlockMudLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_2));
            }
            case 2: {
                return BlockRegistry.MUD_LOOT_POT.func_176223_P().func_177226_a((IProperty)BlockMudLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_3));
            }
        }
        return BlockRegistry.MUD_LOOT_POT.func_176223_P().func_177226_a((IProperty)BlockMudLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_1));
    }
}

