/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.common.block.SoilHelper;
import thebetweenlands.common.block.plant.BlockEdgePlant;
import thebetweenlands.common.block.plant.BlockMoss;
import thebetweenlands.common.block.plant.BlockPlant;
import thebetweenlands.common.block.terrain.BlockCragrock;
import thebetweenlands.common.entity.EntityGreeblingCorpse;
import thebetweenlands.common.entity.mobs.EntityChiromawHatchling;
import thebetweenlands.common.entity.mobs.EntityChiromawMatriarch;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.tile.TileEntityGroundItem;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationChiromawMatriarchNest;
import thebetweenlands.common.world.storage.location.guard.ILocationGuard;

public class WorldGenChiromawNest
extends WorldGenerator {
    public IBlockState CRAGROCK = BlockRegistry.CRAGROCK.func_176223_P();
    public IBlockState NESTING_BLOCK_BONES = BlockRegistry.NESTING_BLOCK_BONES.func_176223_P();
    public IBlockState NESTING_BLOCK_STICKS = BlockRegistry.NESTING_BLOCK_STICKS.func_176223_P();
    public IBlockState ROOT = BlockRegistry.ROOT.func_176223_P();
    public IBlockState BLACK_HAT_MUSHROOM = BlockRegistry.BLACK_HAT_MUSHROOM.func_176223_P();
    public IBlockState FLAT_HEAD_MUSHROOM = BlockRegistry.FLAT_HEAD_MUSHROOM.func_176223_P();
    public IBlockState ROTBULB = BlockRegistry.ROTBULB.func_176223_P();
    public IBlockState SWAMP_TALLGRASS = BlockRegistry.SWAMP_TALLGRASS.func_176223_P();
    public IBlockState SHOOTS = BlockRegistry.SHOOTS.func_176223_P();
    public IBlockState MOSS = BlockRegistry.DEAD_MOSS.func_176223_P();
    public IBlockState LICHEN = BlockRegistry.DEAD_LICHEN.func_176223_P();
    public IBlockState EDGE_SHROOM = BlockRegistry.EDGE_SHROOM.func_176223_P();
    public IBlockState EDGE_MOSS = BlockRegistry.EDGE_MOSS.func_176223_P();
    public IBlockState EDGE_LEAF = BlockRegistry.EDGE_LEAF.func_176223_P();
    public IBlockState GROUND_ITEM = BlockRegistry.GROUND_ITEM.func_176223_P();
    private ILocationGuard guard;

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int xo;
        for (xo = -4; xo <= 4; ++xo) {
            for (int zo = -4; zo <= 4; ++zo) {
                BlockPos checkPos = pos.func_177982_a(xo, -1, zo);
                if (xo * xo + zo * zo > 16 || !world.func_175623_d(checkPos) && !world.func_180495_p(checkPos).func_185904_a().func_76224_d()) continue;
                return false;
            }
        }
        for (xo = -2; xo <= 2; ++xo) {
            for (int yo = 3; yo <= 6; ++yo) {
                for (int zo = -2; zo <= 2; ++zo) {
                    BlockPos checkPos = pos.func_177982_a(xo, yo, zo);
                    IBlockState state = world.func_180495_p(checkPos);
                    if (state.func_177230_c().func_176200_f((IBlockAccess)world, checkPos) || SurfaceType.MIXED_GROUND.apply(state) || state.func_177230_c() instanceof BlockPlant) continue;
                    return false;
                }
            }
        }
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        LocationChiromawMatriarchNest location = new LocationChiromawMatriarchNest(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(pos), pos.func_177981_b(7));
        location.setVisible(true);
        location.addBounds(new AxisAlignedBB(pos).func_72314_b(8.0, 0.0, 8.0).func_72321_a(0.0, 9.0, 0.0));
        location.setSeed(rand.nextLong());
        this.guard = location.getGuard();
        this.generateRockPile(world, rand, pos);
        this.generateNest(world, rand, pos.func_177981_b(6));
        location.setDirty(true);
        worldStorage.getLocalStorageHandler().addLocalStorage(location);
        return true;
    }

    public void generateNest(World world, Random rand, BlockPos pos) {
        for (int xx = -3; xx <= 3; ++xx) {
            for (int zz = -3; zz <= 3; ++zz) {
                for (int yy = 0; yy > -3; --yy) {
                    double dSqDome = Math.pow(xx, 2.0) + Math.pow(zz, 2.0) + Math.pow(yy, 2.0);
                    if (Math.round(Math.sqrt(dSqDome)) < 4L) {
                        this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextInt(4) == 0 ? this.NESTING_BLOCK_BONES : this.NESTING_BLOCK_STICKS);
                        if (yy == 0 && Math.round(Math.sqrt(dSqDome)) == 1L) {
                            this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), Blocks.field_150350_a.func_176223_P());
                            this.addEntitiesAndLootBlocks(world, rand, pos.func_177982_a(xx, yy, zz));
                        }
                        if (yy == 0 && Math.round(Math.sqrt(dSqDome)) == 0L) {
                            this.addMatiarch(world, rand, pos.func_177982_a(xx, yy, zz));
                        }
                    }
                    this.func_175903_a(world, pos.func_177982_a(0, yy, 0), this.CRAGROCK.func_177226_a(BlockCragrock.VARIANT, (Comparable)((Object)this.getCragrockForYLevel(rand, yy + 3))));
                }
            }
        }
    }

    private void addMatiarch(World world, Random rand, BlockPos pos) {
        EntityChiromawMatriarch matriarch = new EntityChiromawMatriarch(world);
        matriarch.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        matriarch.func_180482_a(world.func_175649_E(pos), null);
        world.func_72838_d((Entity)matriarch);
    }

    private void addEntitiesAndLootBlocks(World world, Random rand, BlockPos pos) {
        if (rand.nextBoolean()) {
            EntityChiromawHatchling egg = new EntityChiromawHatchling(world);
            egg.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            if (rand.nextBoolean()) {
                egg.setIsWild(true);
            }
            world.func_72838_d((Entity)egg);
        } else if (rand.nextBoolean() && rand.nextBoolean()) {
            EntityGreeblingCorpse corpse = new EntityGreeblingCorpse(world);
            corpse.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            world.func_72838_d((Entity)corpse);
        } else {
            this.func_175903_a(world, pos, this.GROUND_ITEM);
            this.setScatteredLoot(world, rand, pos);
        }
    }

    public void setScatteredLoot(World world, Random rand, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityGroundItem) {
            ItemStack stack = this.getScatteredLoot(world, rand);
            ((TileEntityGroundItem)tile).setStack(stack);
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
        }
    }

    public ItemStack getScatteredLoot(World world, Random rand) {
        LootContext.Builder lootBuilder;
        List loot;
        LootTable lootTable = world.func_184146_ak().func_186521_a(this.getScatteredLootTable());
        if (lootTable != null && !(loot = lootTable.func_186462_a(rand, (lootBuilder = new LootContext.Builder((WorldServer)world)).func_186471_a())).isEmpty()) {
            Collections.shuffle(loot);
            return (ItemStack)loot.get(0);
        }
        return ItemMisc.EnumItemMisc.SLIMY_BONE.create(1);
    }

    protected ResourceLocation getScatteredLootTable() {
        return LootTableRegistry.CHIROMAW_NEST_SCATTERED_LOOT;
    }

    public void generateRockPile(World world, Random rand, BlockPos pos) {
        for (int xx = -6; xx <= 6; ++xx) {
            for (int zz = -6; zz <= 6; ++zz) {
                for (int yy = 0; yy < 4; ++yy) {
                    double dSqDome = Math.pow(xx, 2.0) + Math.pow(zz, 2.0) + Math.pow(yy, 2.0);
                    if (yy == 0 && rand.nextBoolean() && Math.round(Math.sqrt(dSqDome)) == 5L) {
                        this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.CRAGROCK.func_177226_a(BlockCragrock.VARIANT, (Comparable)((Object)this.getCragrockForYLevel(rand, 1))));
                    }
                    if (yy == 0 && rand.nextBoolean() && Math.round(Math.sqrt(dSqDome)) == 6L && this.isPlantableAbove(world, pos.func_177982_a(xx, yy, zz))) {
                        this.setRandomRoot(world, pos.func_177982_a(xx, yy, zz), rand);
                    }
                    if (Math.round(Math.sqrt(dSqDome)) >= 5L) continue;
                    this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.CRAGROCK.func_177226_a(BlockCragrock.VARIANT, (Comparable)((Object)this.getCragrockForYLevel(rand, yy))));
                }
            }
        }
        for (int yy = -1; yy < 4; ++yy) {
            this.addGroundPlants(world, pos.func_177982_a(-5, 0, -5), rand, 11, yy, 11, false, true, true);
            this.addEdgePlant(world, pos.func_177982_a(-5, 0, -5), rand, 11, yy, 11);
        }
        this.addWallPlants(world, pos.func_177982_a(2, 0, -2), rand, 3, 4, 5, EnumFacing.EAST);
        this.addWallPlants(world, pos.func_177982_a(-4, 0, -2), rand, 3, 4, 5, EnumFacing.WEST);
        this.addWallPlants(world, pos.func_177982_a(-2, 0, -4), rand, 5, 4, 3, EnumFacing.NORTH);
        this.addWallPlants(world, pos.func_177982_a(-2, 0, 2), rand, 5, 4, 3, EnumFacing.SOUTH);
    }

    public void setRandomRoot(World world, BlockPos pos, Random rand) {
        int rnd = rand.nextInt(32);
        if (rnd < 8) {
            this.func_175903_a(world, pos, this.ROOT);
        } else if (rnd < 16) {
            this.func_175903_a(world, pos, this.ROOT);
            if (world.func_175623_d(pos.func_177981_b(1))) {
                this.func_175903_a(world, pos.func_177981_b(1), this.ROOT);
            }
        } else if (rnd < 24) {
            this.func_175903_a(world, pos, this.ROOT);
            if (world.func_175623_d(pos.func_177981_b(1)) && world.func_175623_d(pos.func_177981_b(2))) {
                this.func_175903_a(world, pos.func_177981_b(1), this.ROOT);
                this.func_175903_a(world, pos.func_177981_b(2), this.ROOT);
            }
        } else {
            this.func_175903_a(world, pos, this.ROOT);
            if (world.func_175623_d(pos.func_177981_b(1)) && world.func_175623_d(pos.func_177981_b(2)) && world.func_175623_d(pos.func_177981_b(3))) {
                this.func_175903_a(world, pos.func_177981_b(1), this.ROOT);
                this.func_175903_a(world, pos.func_177981_b(2), this.ROOT);
                this.func_175903_a(world, pos.func_177981_b(3), this.ROOT);
            }
        }
    }

    public void addGroundPlants(World world, BlockPos pos, Random rand, int x, int y, int z, boolean addMoss, boolean addWeeds, boolean addMushrooms) {
        for (int horizontalX = 0; horizontalX < x; ++horizontalX) {
            for (int horizontalZ = 0; horizontalZ < z; ++horizontalZ) {
                if (!this.isPlantableAbove(world, pos.func_177982_a(horizontalX, y, horizontalZ))) continue;
                if (addWeeds && this.plantingChance(rand)) {
                    this.func_175903_a(world, pos.func_177982_a(horizontalX, y + 1, horizontalZ), this.getRandomFloorPlant(rand));
                    continue;
                }
                if (addMushrooms && this.plantingChance(rand)) {
                    this.func_175903_a(world, pos.func_177982_a(horizontalX, y + 1, horizontalZ), this.getRandomMushroom(rand));
                    continue;
                }
                if (!addMoss || !rand.nextBoolean()) continue;
                this.func_175903_a(world, pos.func_177982_a(horizontalX, y + 1, horizontalZ), this.MOSS.func_177226_a((IProperty)BlockMoss.field_176387_N, (Comparable)EnumFacing.UP));
            }
        }
    }

    public void addEdgePlant(World world, BlockPos pos, Random rand, int x, int y, int z) {
        for (int horizontalX = 0; horizontalX < x; ++horizontalX) {
            for (int horizontalZ = 0; horizontalZ < z; ++horizontalZ) {
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    if (!world.func_180495_p(pos.func_177982_a(horizontalX, y + 1, horizontalZ).func_177972_a(facing)).isSideSolid((IBlockAccess)world, pos.func_177982_a(horizontalX, y + 1, horizontalZ).func_177972_a(facing), facing.func_176734_d()) || !this.plantingChance(rand) || !this.isPlantableAbove(world, pos.func_177982_a(horizontalX, y, horizontalZ))) continue;
                    this.func_175903_a(world, pos.func_177982_a(horizontalX, y + 1, horizontalZ), this.getRandomEdgePlant(rand, facing.func_176734_d()));
                }
            }
        }
    }

    public void addWallPlants(World world, BlockPos pos, Random rand, int x, int y, int z, EnumFacing facing) {
        for (int horizontalX = 0; horizontalX < x; ++horizontalX) {
            for (int horizontalZ = 0; horizontalZ < z; ++horizontalZ) {
                for (int vertical = 0; vertical < y; ++vertical) {
                    if (!this.plantingChance(rand) || !this.isPlantableWall(world, pos.func_177982_a(horizontalX, vertical, horizontalZ), facing)) continue;
                    this.func_175903_a(world, pos.func_177982_a(horizontalX, vertical, horizontalZ).func_177972_a(facing), this.MOSS.func_177226_a((IProperty)BlockMoss.field_176387_N, (Comparable)facing));
                }
            }
        }
    }

    public boolean isPlantableAbove(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return SoilHelper.canSustainPlant(state) && world.func_175623_d(pos.func_177984_a());
    }

    public boolean isPlantableWall(World world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_185913_b() && world.func_175623_d(pos.func_177972_a(facing));
    }

    public boolean plantingChance(Random rand) {
        return rand.nextBoolean() && rand.nextBoolean();
    }

    public BlockCragrock.EnumCragrockType getCragrockForYLevel(Random rand, int y) {
        return y < 1 ? BlockCragrock.EnumCragrockType.DEFAULT : (y >= 1 && y < 3 ? (rand.nextBoolean() ? BlockCragrock.EnumCragrockType.DEFAULT : BlockCragrock.EnumCragrockType.MOSSY_2) : BlockCragrock.EnumCragrockType.MOSSY_1);
    }

    public IBlockState getRandomFloorPlant(Random rand) {
        return rand.nextBoolean() ? this.SWAMP_TALLGRASS : this.SHOOTS;
    }

    public IBlockState getRandomMushroom(Random rand) {
        int type = rand.nextInt(30);
        if (type < 10) {
            return this.FLAT_HEAD_MUSHROOM;
        }
        if (type < 20) {
            return this.BLACK_HAT_MUSHROOM;
        }
        return this.ROTBULB;
    }

    public IBlockState getRandomEdgePlant(Random rand, EnumFacing facing) {
        int type = rand.nextInt(3);
        switch (type) {
            case 0: {
                return this.EDGE_SHROOM.func_177226_a((IProperty)BlockEdgePlant.FACING, (Comparable)facing);
            }
            case 1: {
                return this.EDGE_MOSS.func_177226_a((IProperty)BlockEdgePlant.FACING, (Comparable)facing);
            }
            case 2: {
                return this.EDGE_LEAF.func_177226_a((IProperty)BlockEdgePlant.FACING, (Comparable)facing);
            }
        }
        return this.EDGE_SHROOM.func_177226_a((IProperty)BlockEdgePlant.FACING, (Comparable)facing);
    }

    protected void func_175903_a(World worldIn, BlockPos pos, IBlockState state) {
        super.func_175903_a(worldIn, pos, state);
        if (this.guard != null && !(state.func_177230_c() instanceof BlockPlant)) {
            this.guard.setGuarded(worldIn, pos, true);
        }
    }
}

