/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.common.block.structure.BlockBeamLensSupport;
import thebetweenlands.common.block.structure.BlockBeamRelay;
import thebetweenlands.common.block.structure.BlockBeamTube;
import thebetweenlands.common.block.structure.BlockSlabBetweenlands;
import thebetweenlands.common.block.terrain.BlockRottenLog;
import thebetweenlands.common.entity.EntityTriggeredFallingBlock;
import thebetweenlands.common.tile.TileEntityDungeonDoorRunes;
import thebetweenlands.common.world.gen.feature.structure.WorldGenSludgeWormDungeon;
import thebetweenlands.common.world.gen.feature.structure.utils.SludgeWormMazeBlockHelper;

public class LightTowerBuildParts {
    private SludgeWormMazeBlockHelper blockHelper;
    private final WorldGenSludgeWormDungeon dungeon;

    public LightTowerBuildParts(WorldGenSludgeWormDungeon dungeon) {
        this.dungeon = dungeon;
        this.blockHelper = new SludgeWormMazeBlockHelper(dungeon);
    }

    public void buildPitEntrance(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        this.rotatedCubeVolume(world, rand, pos, -7, 12 + level, 4, this.blockHelper.getMudBricksForLevel(rand, 7, 1), 1, 1, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, -7, 13 + level, 4, this.blockHelper.getMudBricksForLevel(rand, 7, 2), 1, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, -7, 14 + level, 4, this.blockHelper.getMudBricksForLevel(rand, 7, 3), 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, -7, 15 + level, 4, this.blockHelper.getMudBricksForLevel(rand, 7, 1), 1, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, -7, 12 + level, 3, this.blockHelper.getMudBricksForLevel(rand, 7, 1), 5, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -7, 13 + level, 3, this.blockHelper.getMudBricksForLevel(rand, 7, 2), 5, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -7, 14 + level, 3, this.blockHelper.getMudBricksForLevel(rand, 7, 3), 5, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -7, 15 + level, 3, this.blockHelper.getMudBricksForLevel(rand, 7, 1), 5, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -3, 12 + level, 4, this.blockHelper.getMudBricksForLevel(rand, 7, 1), 1, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, -3, 13 + level, 4, this.blockHelper.getMudBricksForLevel(rand, 7, 2), 1, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, -3, 14 + level, 4, this.blockHelper.getMudBricksForLevel(rand, 7, 3), 1, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, -3, 15 + level, 4, this.blockHelper.getMudBricksForLevel(rand, 7, 1), 1, 1, 10, facing);
        this.rotatedCubeVolume(world, rand, pos, -3, 12 + level, 8, this.blockHelper.getMudBricksForLevel(rand, 7, 1), 1, 1, 6, facing);
        this.rotatedCubeVolume(world, rand, pos, -3, 13 + level, 8, this.blockHelper.getMudBricksForLevel(rand, 7, 2), 1, 1, 6, facing);
        this.rotatedCubeVolume(world, rand, pos, -3, 14 + level, 8, this.blockHelper.getMudBricksForLevel(rand, 7, 3), 1, 1, 6, facing);
        this.rotatedCubeVolume(world, rand, pos, -4, 15 + level, 5, this.blockHelper.getStairsForLevel(rand, 7, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, -4, 15 + level, 8, this.blockHelper.getStairsForLevel(rand, 7, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 3, facing);
        this.rotatedCubeVolume(world, rand, pos, -6, 12 + level, 7, this.blockHelper.AIR, 3, 3, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, -7, 11 + level, 3, this.blockHelper.MUD_TILES_DECAY, 5, 1, 7, facing);
        this.rotatedCubeVolume(world, rand, pos, -4, 11 + level, 10, this.blockHelper.MUD_TILES_DECAY, 2, 1, 2, facing);
        for (int count = 1; count <= 3; ++count) {
            this.dungeon.func_175903_a(world, pos.func_177982_a(7, 15 + level, 3).func_177967_a(facing.func_176746_e(), count), this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, count, false));
        }
        this.rotatedCubeVolume(world, rand, pos, -3, 12 + level, 7, this.blockHelper.getPillarsForLevel(rand, 7, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -3, 13 + level, 7, this.blockHelper.getPillarsForLevel(rand, 7, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -3, 14 + level, 7, this.blockHelper.getPillarsForLevel(rand, 7, 3), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -4, 14 + level, 7, this.blockHelper.getRandomSupportBeam(facing.func_176746_e(), true, rand), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -6, 14 + level, 7, this.blockHelper.getRandomSupportBeam(facing.func_176734_d().func_176746_e(), true, rand), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -4, 12 + level, 5, this.blockHelper.AIR, 1, 3, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, -5, 12 + level, 5, this.blockHelper.AIR, 1, 4, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, -6, 13 + level, 5, this.blockHelper.AIR, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -6, 12 + level, 6, this.blockHelper.AIR, 1, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -5, 12 + level, 4, this.blockHelper.AIR, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -7, 14 + level, 6, this.blockHelper.AIR, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -4, 12 + level, 11, this.blockHelper.AIR, 1, 1, 1, facing);
    }

    public void buildsMazeGate(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        this.rotatedCubeVolume(world, rand, pos, 1, 0 + level, -2, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 6, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 0 + level, -4, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0 + level, -4, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 2, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 0 + level, -4, this.blockHelper.getTilesForLevel(rand, 0), 3, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 0 + level, -1, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 0 + level, 0, this.blockHelper.getMudSlabsForLevel(rand, 0, BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM), 2, 1, 4, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 4 + level, -3, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 4, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 5 + level, -2, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 5 + level, -4, this.blockHelper.getStairsForLevel(rand, 0, facing, BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 6 + level, -3, this.blockHelper.MUD_TOWER_BEAM_RELAY.func_177226_a((IProperty)BlockBeamRelay.field_176387_N, (Comparable)facing), 1, 1, 2, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 6 + level, -4, this.blockHelper.getPillarsForLevel(rand, 0, 3), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 6 + level, -3, this.blockHelper.MUD_TOWER_BEAM_RELAY.func_177226_a((IProperty)BlockBeamRelay.field_176387_N, (Comparable)facing.func_176734_d().func_176746_e()), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 6 + level, -3, this.blockHelper.getMudBricksForLevel(rand, 0, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 7 + level, -2, this.blockHelper.MUD_BRICK_WALL, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 7 + level, -4, this.blockHelper.MUD_BRICK_WALL, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 7 + level, -3, this.blockHelper.MUD_BRICK_WALL, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 7 + level, -3, this.blockHelper.MUD_BRICK_WALL, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 7 + level, -2, this.blockHelper.MUD_BRICK_WALL, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 7 + level, -4, this.blockHelper.MUD_BRICK_WALL, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 7 + level, -2, this.blockHelper.MUD_BRICK_WALL, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 7 + level, -4, this.blockHelper.MUD_BRICK_WALL, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 8 + level, -3, this.blockHelper.ROOT, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 0 + level, 4, this.blockHelper.getStairsForLevel(rand, 0, facing, BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 0 + level, 4, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 0 + level, 4, this.blockHelper.getStairsForLevel(rand, 0, facing, BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 0 + level, 4, this.blockHelper.getMudSlabsForLevel(rand, 0, BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 0 + level, 1, this.blockHelper.getMudSlabsForLevel(rand, 0, BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 0 + level, 2, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 0 + level, 5, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 3, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 0 + level, 5, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 1 + level, 5, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 2 + level, 5, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 3 + level, 5, this.blockHelper.MUD_BRICK_WALL, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 5 + level, 5, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 6 + level, 5, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 7 + level, 5, this.blockHelper.getMudSlabsForLevel(rand, 0, BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 5 + level, 5, this.blockHelper.getRandomSupportBeam(facing.func_176746_e(), true, rand), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 6 + level, 5, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 5 + level, 5, this.blockHelper.getRandomSupportBeam(facing.func_176734_d().func_176746_e(), true, rand), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 6 + level, 5, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 2 + level, 5, this.blockHelper.getRandomSupportBeam(facing.func_176746_e(), false, rand), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 4, 2 + level, 5, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 2 + level, 5, this.blockHelper.getRandomSupportBeam(facing.func_176734_d().func_176746_e(), false, rand), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 0 + level, -1, this.blockHelper.getMudSlabsForLevel(rand, 0, BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 0 + level, -1, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 1 + level, -2, this.blockHelper.getMudBricksForLevel(rand, 0, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 2 + level, -2, this.blockHelper.getPillarsForLevel(rand, 0, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 3 + level, -2, this.blockHelper.getMudBricksForLevel(rand, 0, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 4 + level, -2, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 4 + level, -2, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 5 + level, -2, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 6 + level, -2, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 0 + level, -1, this.blockHelper.getMudSlabsForLevel(rand, 0, BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 0 + level, -1, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 1 + level, -2, this.blockHelper.getMudBricksForLevel(rand, 0, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 2 + level, -2, this.blockHelper.getPillarsForLevel(rand, 0, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 3 + level, -2, this.blockHelper.getMudBricksForLevel(rand, 0, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 4 + level, -2, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 4 + level, -2, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 5 + level, -2, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 6 + level, -2, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 0, 0 + level, -3, this.blockHelper.getMudSlabsForLevel(rand, 0, BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 0 + level, -3, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 0 + level, -3, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 1 + level, -3, this.blockHelper.getMudSlabsForLevel(rand, 0, BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 3 + level, -3, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 4 + level, -3, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 5 + level, -3, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 0 + level, -3, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 1 + level, -3, this.blockHelper.getMudSlabsForLevel(rand, 0, BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 3 + level, -3, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 4 + level, -3, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 5 + level, -3, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 1 + level, -4, this.blockHelper.getMudBricksForLevel(rand, 0, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 2 + level, -4, this.blockHelper.getPillarsForLevel(rand, 0, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 3 + level, -4, this.blockHelper.getMudBricksForLevel(rand, 0, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 2, 4 + level, -4, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 4 + level, -4, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 5 + level, -4, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 6 + level, -4, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 1 + level, -4, this.blockHelper.getMudBricksForLevel(rand, 0, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 2 + level, -4, this.blockHelper.getPillarsForLevel(rand, 0, 1), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 3 + level, -4, this.blockHelper.getMudBricksForLevel(rand, 0, 2), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 6, 4 + level, -4, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 4 + level, -4, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 5 + level, -4, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 5, 6 + level, -4, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 1 + level, -4, this.blockHelper.MUD_BRICK_WALL, 3, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 3, 0 + level, -3, this.blockHelper.AIR, 3, 1, 1, facing);
        this.dungeon.func_175903_a(world, pos.func_177982_a(3, 2 + level, 4), this.blockHelper.DUNGEON_DOOR_WEST);
        TileEntityDungeonDoorRunes tileLock = (TileEntityDungeonDoorRunes)world.func_175625_s(pos.func_177982_a(3, 2 + level, 4));
        if (tileLock instanceof TileEntityDungeonDoorRunes) {
            tileLock.top_code = 1;
            tileLock.mid_code = 1;
            tileLock.bottom_code = 1;
            tileLock.is_in_dungeon = true;
            tileLock.is_gate_entrance = true;
        }
    }

    public void buildsSpiralStairPart(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer, boolean topEnd) {
        if (topEnd) {
            this.rotatedCubeVolume(world, rand, pos, 13, 0 + level, -2, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 12, 0 + level, -3, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 0 + level, -4, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 3, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 10, 1 + level, -2, this.blockHelper.ROTTEN_PLANK_SLAB_LOWER, 3, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 10, 1 + level, -3, this.blockHelper.ROTTEN_PLANK_SLAB_LOWER, 2, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 13, 1 + level, -2, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 12, 1 + level, -3, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 11, 1 + level, -4, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 10, 1 + level, -4, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 1 + level, -4, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 13, 2 + level, -2, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 12, 2 + level, -3, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 2 + level, -4, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 3, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 12, 3 + level, -3, this.blockHelper.ROOT, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 10, 3 + level, -4, this.blockHelper.ROOT, 1, 5, 1, facing);
        }
        this.rotatedCubeVolume(world, rand, pos, 10, 0 + level, 0, this.blockHelper.ROTTEN_PLANK_SLAB_UPPER, 4, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 10, 1 + level, -1, this.blockHelper.ROTTEN_PLANK_SLAB_LOWER, 4, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 14, -1 + level, 0, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 14, 0 + level, -1, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 14, 0 + level, 0, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 14, 1 + level, -1, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 14, 1 + level, 0, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 14, 2 + level, -1, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 14, 3 + level, -1, this.blockHelper.ROOT, 1, 5, 1, facing);
        if (level < 16) {
            this.rotatedCubeVolume(world, rand, pos, 8, 4 + level, -6, level == 0 ? this.blockHelper.PITSTONE_BRICKS : this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 8, 5 + level, -6, this.blockHelper.getRandomLootUrn(rand, facing), 1, 1, 1, facing);
        }
        if (level == 0) {
            this.rotatedCubeVolume(world, rand, pos, 10, level, 1, this.blockHelper.ROTTEN_PLANKS, 6, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 10, level, 2, this.blockHelper.ROTTEN_PLANKS, 5, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 10, level, 3, this.blockHelper.ROTTEN_PLANKS, 4, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 11, level, 4, this.blockHelper.ROTTEN_PLANKS, 2, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 13, 1 + level, -5, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 13, 1 + level, -6, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 12, 1 + level, -7, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 11, 1 + level, -8, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 11, 1 + level, -9, this.blockHelper.ROOT, 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 1 + level, -10, this.blockHelper.ROOT, 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 1 + level, -12, this.blockHelper.ROOT, 1, 3, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 1 + level, -13, this.blockHelper.ROOT, 1, 4, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 3, 1 + level, -14, this.blockHelper.ROOT, 1, 5, 1, facing);
        }
        if (!topEnd) {
            this.rotatedCubeVolume(world, rand, pos, 10, 1 + level, -2, this.blockHelper.ROTTEN_PLANK_SLAB_UPPER, 4, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 10, 2 + level, -3, this.blockHelper.ROTTEN_PLANK_SLAB_LOWER, 4, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 2 + level, -4, this.blockHelper.ROTTEN_PLANK_SLAB_UPPER, 4, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 3 + level, -5, this.blockHelper.ROTTEN_PLANK_SLAB_LOWER, 4, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 3 + level, -6, this.blockHelper.ROTTEN_PLANK_SLAB_UPPER, 4, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 14, 2 + level, -2, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 14, 3 + level, -3, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 13, 3 + level, -4, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 13, 4 + level, -5, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 13, 4 + level, -6, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 14, 1 + level, -2, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 14, 2 + level, -3, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 13, 2 + level, -4, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 13, 3 + level, -5, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 13, 3 + level, -6, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 14, 0 + level, -2, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 14, 1 + level, -3, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 13, 1 + level, -4, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 13, 2 + level, -5, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 13, 2 + level, -6, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 14, 4 + level, -3, this.blockHelper.ROOT, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 13, 5 + level, -5, this.blockHelper.ROOT, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 4 + level, -7, this.blockHelper.ROTTEN_PLANK_SLAB_LOWER, 3, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 4 + level, -8, this.blockHelper.ROTTEN_PLANK_SLAB_LOWER, 2, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 4 + level, -9, this.blockHelper.ROTTEN_PLANK_SLAB_LOWER, 2, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 4 + level, -10, this.blockHelper.ROTTEN_PLANK_SLAB_LOWER, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 12, 3 + level, -7, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 11, 3 + level, -8, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 11, 3 + level, -9, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 10, 3 + level, -10, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 3 + level, -10, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 12, 4 + level, -7, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 11, 4 + level, -8, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 11, 4 + level, -9, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 10, 4 + level, -10, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 4 + level, -10, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 12, 5 + level, -7, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 11, 5 + level, -8, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 11, 5 + level, -9, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 10, 5 + level, -10, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 5 + level, -10, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 12, 6 + level, -7, this.blockHelper.ROOT, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 11, 6 + level, -9, this.blockHelper.ROOT, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 6 + level, -10, this.blockHelper.ROOT, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 8, 4 + level, -10, this.blockHelper.ROTTEN_PLANK_SLAB_UPPER, 1, 1, 4, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 5 + level, -11, this.blockHelper.ROTTEN_PLANK_SLAB_LOWER, 1, 1, 5, facing);
            this.rotatedCubeVolume(world, rand, pos, 6, 5 + level, -12, this.blockHelper.ROTTEN_PLANK_SLAB_UPPER, 1, 1, 5, facing);
            this.rotatedCubeVolume(world, rand, pos, 8, 3 + level, -11, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 4 + level, -12, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 6, 4 + level, -13, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 8, 4 + level, -11, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 5 + level, -12, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 6, 5 + level, -13, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 8, 5 + level, -11, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 6 + level, -12, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 6, 6 + level, -13, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 7 + level, -12, this.blockHelper.ROOT, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 6 + level, -12, this.blockHelper.ROTTEN_PLANK_SLAB_LOWER, 1, 1, 4, facing);
            this.rotatedCubeVolume(world, rand, pos, 4, 6 + level, -12, this.blockHelper.ROTTEN_PLANK_SLAB_UPPER, 1, 1, 4, facing);
            this.rotatedCubeVolume(world, rand, pos, 3, 7 + level, -13, this.blockHelper.ROTTEN_PLANK_SLAB_LOWER, 1, 1, 4, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 7 + level, -13, this.blockHelper.ROTTEN_PLANK_SLAB_UPPER, 1, 1, 4, facing);
            this.rotatedCubeVolume(world, rand, pos, 1, 8 + level, -13, this.blockHelper.ROTTEN_PLANK_SLAB_LOWER, 1, 1, 4, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 5 + level, -13, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 4, 5 + level, -13, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 3, 6 + level, -14, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 6 + level, -14, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 1, 7 + level, -14, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 6 + level, -13, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 4, 6 + level, -13, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 3, 7 + level, -14, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 7 + level, -14, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 1, 8 + level, -14, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 7 + level, -13, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 4, 7 + level, -13, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 3, 8 + level, -14, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 8 + level, -14, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 1, 9 + level, -14, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 8 + level, -13, this.blockHelper.ROOT, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 3, 9 + level, -14, this.blockHelper.ROOT, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 1, 10 + level, -14, this.blockHelper.ROOT, 1, 5, 1, facing);
        }
    }

    public void addTowerFloor(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        if (level == 0 || level == 8) {
            this.rotatedCubeVolume(world, rand, pos, 0, 1 + level, 0, this.blockHelper.ENERGY_BARRIER_MUD, 1, 7, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 8, 0 + level, 0, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM, level != 0), 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, 8, 0 + level, 2, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.BOTTOM, level != 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 0 + level, 2, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.BOTTOM, level != 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 0 + level, 3, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM, level != 0), 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, 6, 0 + level, 4, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.BOTTOM, level != 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 6, 0 + level, 5, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM, level != 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 6, 0 + level, 6, level == 0 ? this.blockHelper.SMOOTH_PITSTONE : this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 0 + level, 6, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.BOTTOM, level != 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 4, 0 + level, 6, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM, level != 0), 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, 3, 0 + level, 7, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.BOTTOM, level != 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 0 + level, 7, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM, level != 0), 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, 1, 0 + level, 8, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.BOTTOM, level != 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 0 + level, 0, level == 0 ? this.blockHelper.SMOOTH_PITSTONE : this.blockHelper.PITSTONE_BRICKS, 6, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, 1, 0 + level, 2, level == 0 ? this.blockHelper.SMOOTH_PITSTONE : this.blockHelper.PITSTONE_BRICKS, 6, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, 1, 0 + level, 4, level == 0 ? this.blockHelper.SMOOTH_PITSTONE : this.blockHelper.PITSTONE_BRICKS, 5, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, 1, 0 + level, 6, level == 0 ? this.blockHelper.SMOOTH_PITSTONE : this.blockHelper.PITSTONE_BRICKS, 3, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 1, 0 + level, 7, level == 0 ? this.blockHelper.SMOOTH_PITSTONE : this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 1, 1 + level, 1, this.blockHelper.getEnergyBarrier(facing == EnumFacing.SOUTH ? true : facing == EnumFacing.NORTH), 1, 7, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 1 + level, 2, this.blockHelper.getEnergyBarrier(facing == EnumFacing.SOUTH ? true : facing == EnumFacing.NORTH), 1, 7, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 3, 1 + level, 3, this.blockHelper.getEnergyBarrier(facing == EnumFacing.SOUTH ? true : facing == EnumFacing.NORTH), 1, 7, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 4, 1 + level, 4, this.blockHelper.getEnergyBarrier(facing == EnumFacing.SOUTH ? true : facing == EnumFacing.NORTH), 1, 7, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 1 + level, 5, this.blockHelper.getEnergyBarrier(facing == EnumFacing.SOUTH ? true : facing == EnumFacing.NORTH), 1, 7, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 6, 1 + level, 6, this.blockHelper.getEnergyBarrier(facing == EnumFacing.SOUTH ? true : facing == EnumFacing.NORTH), 1, 7, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 8, 7 + level, 0, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP, level != 0), 1, 1, 3, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 7 + level, 2, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.TOP, level != 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 7 + level, 3, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP, level != 0), 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, 6, 7 + level, 4, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.TOP, level != 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 6, 7 + level, 5, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP, level != 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 6, 7 + level, 6, level == 0 ? this.blockHelper.SMOOTH_PITSTONE : this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 7 + level, 6, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.TOP, level != 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 4, 7 + level, 6, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP, level != 0), 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, 3, 7 + level, 7, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.TOP, level != 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 7 + level, 7, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP, level != 0), 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, 1, 7 + level, 8, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.TOP, level != 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 0, 8 + level, 0, this.blockHelper.MUD_TOWER_BEAM_TUBE, 1, 1, 1, facing);
        }
        if (level == 16) {
            this.rotatedCubeVolume(world, rand, pos, 0, 0 + level, 1, this.blockHelper.SMOOTH_PITSTONE_SLAB_LOWER, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -1, 0 + level, 2, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.BOTTOM, false), 2, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -1, 0 + level, 1, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.BOTTOM, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 0 + level, 1, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.BOTTOM, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -1, 0 + level, 3, this.blockHelper.getRandomBeam(facing, rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 0, 0 + level, 3, this.blockHelper.getRandomBeam(facing, rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 0 + level, 1, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 0 + level, 2, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 0 + level, 3, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 0 + level, 4, this.blockHelper.getRandomBeam(facing, rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 0 + level, 4, this.blockHelper.getRandomBeam(facing, rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -4, 0 + level, 4, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -4, 0 + level, 3, this.blockHelper.getRandomBeam(facing.func_176746_e(), rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 0 + level, 2, this.blockHelper.getRandomBeam(facing, rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -4, 0 + level, 2, this.blockHelper.getRandomBeam(facing, rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 0 + level, 5, this.blockHelper.LOG_ROTTEN_BARK.func_177226_a((IProperty)BlockRottenLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k())), 1, 1, 3, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 0 + level, 3, this.blockHelper.LOG_ROTTEN_BARK.func_177226_a((IProperty)BlockRottenLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176746_e().func_176740_k())), 3, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 0 + level, 3, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 1 + level, 3, this.blockHelper.getRandomBeam(facing, rand, level, 0, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 2 + level, 3, this.blockHelper.BRAZIER_BOTTOM, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 3 + level, 3, this.blockHelper.BRAZIER_TOP, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -4, 1 + level, 3, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -4, 1 + level, 2, this.blockHelper.getStairsForLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -4, 1 + level, 4, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 1 + level, 2, this.blockHelper.getStairsForLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 1 + level, 3, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.BOTTOM, true), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 1 + level, 4, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.BOTTOM), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 1 + level, 2, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.BOTTOM, true), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 1 + level, 4, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.BOTTOM, true), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -4, 2 + level, 3, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM, true), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -5, 1 + level, 3, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM, true), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -5, 0 + level, 6, this.blockHelper.PITSTONE_BRICKS, 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 0 + level, 5, this.blockHelper.PITSTONE_BRICKS, 2, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 0 + level, 4, this.blockHelper.PITSTONE_BRICKS, 2, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -4, 0 + level, 5, this.blockHelper.PITSTONE_BRICKS, 1, 1, 3, facing);
            this.rotatedCubeVolume(world, rand, pos, -5, 0 + level, 4, this.blockHelper.PITSTONE_BRICKS, 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 0 + level, 5, this.blockHelper.PITSTONE_BRICKS, 5, 1, 3, facing);
            this.rotatedCubeVolume(world, rand, pos, -1, 0 + level, 4, this.blockHelper.PITSTONE_BRICKS, 3, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 0 + level, 8, this.blockHelper.PITSTONE_BRICKS, 3, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 0 + level, 1, this.blockHelper.PITSTONE_BRICKS, 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 1 + level, 8, this.blockHelper.PITSTONE_PILLAR, 1, 3, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 4 + level, 8, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 4 + level, 7, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.TOP, false), 3, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -1, 4 + level, 8, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.TOP, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 0, 4 + level, 8, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.TOP, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 4 + level, 8, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 5 + level, 8, this.blockHelper.SMOOTH_PITSTONE_SLAB_LOWER, 2, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -4, 5 + level, 8, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.BOTTOM, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -5, 6 + level, 6, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.BOTTOM, false), 1, 1, 3, facing);
            this.rotatedCubeVolume(world, rand, pos, -6, 6 + level, 7, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM, false), 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 6 + level, 7, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.BOTTOM, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 6 + level, 6, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 6 + level, 6, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.BOTTOM, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 6 + level, 5, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.BOTTOM, false), 3, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 1 + level, 9, this.blockHelper.PITSTONE_BRICKS, 1, 3, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 4 + level, 9, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM, true), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -1, 4 + level, 9, this.blockHelper.PITSTONE_BRICKS, 2, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -1, 5 + level, 9, this.blockHelper.SMOOTH_PITSTONE_SLAB_LOWER, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -1, 5 + level, 7, this.blockHelper.SMOOTH_PITSTONE_SLAB_LOWER, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 0, 5 + level, 9, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.BOTTOM, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 0, 5 + level, 7, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.BOTTOM, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -1, 5 + level, 8, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 0, 5 + level, 8, this.blockHelper.SMOOTH_PITSTONE, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -1, 3 + level, 9, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.TOP, true), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 1 + level, 8, this.blockHelper.PITSTONE_BRICKS, 1, 2, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 3 + level, 8, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.BOTTOM, true), 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, -5, 1 + level, 8, this.blockHelper.PITSTONE_BRICKS, 2, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -6, 1 + level, 6, this.blockHelper.PITSTONE_BRICKS, 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 1 + level, 6, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 1 + level, 4, this.blockHelper.PITSTONE_BRICKS, 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, -9, 1 + level, 3, this.blockHelper.PITSTONE_BRICKS, 2, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -9, 1 + level, 2, this.blockHelper.PITSTONE_BRICKS, 1, 3, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 1 + level, 2, this.blockHelper.PITSTONE_PILLAR, 1, 3, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 4 + level, 2, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -5, 2 + level, 8, this.blockHelper.PITSTONE_TILES, 2, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -6, 2 + level, 6, this.blockHelper.PITSTONE_TILES, 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 2 + level, 6, this.blockHelper.PITSTONE_TILES, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 2 + level, 4, this.blockHelper.PITSTONE_TILES, 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, -5, 3 + level, 8, this.blockHelper.PITSTONE_PILLAR, 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -5, 5 + level, 8, this.blockHelper.SMOOTH_PITSTONE, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -6, 5 + level, 7, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.TOP, false), 2, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -6, 5 + level, 8, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -6, 3 + level, 6, this.blockHelper.PITSTONE_PILLAR, 1, 3, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -6, 6 + level, 6, this.blockHelper.SMOOTH_PITSTONE, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -6, 7 + level, 6, this.blockHelper.SMOOTH_PITSTONE_SLAB_LOWER, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 3 + level, 5, this.blockHelper.PITSTONE_PILLAR, 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 5 + level, 5, this.blockHelper.SMOOTH_PITSTONE, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 5 + level, 4, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.BOTTOM, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 5 + level, 5, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.TOP, false), 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 5 + level, 6, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.TOP, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 5 + level, 2, this.blockHelper.SMOOTH_PITSTONE_SLAB_LOWER, 1, 1, 2, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 4 + level, 1, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.TOP, false), 1, 1, 3, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 5 + level, 1, this.blockHelper.SMOOTH_PITSTONE_SLAB_LOWER, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 5 + level, 1, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.BOTTOM, false), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -9, 5 + level, 1, this.blockHelper.SMOOTH_PITSTONE_SLAB_LOWER, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -9, 4 + level, 1, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -9, 4 + level, 2, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.BOTTOM, true), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -9, 3 + level, 3, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.BOTTOM, true), 2, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 4 + level, 3, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d(), BlockStairs.EnumHalf.TOP, true), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -9, 3 + level, 1, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.TOP, true), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -8, 4 + level, 1, this.blockHelper.getStairsForTowerLevel(rand, level, facing, BlockStairs.EnumHalf.TOP, false), 1, 1, 1, facing);
        }
    }

    public void addTowerDoorways(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int layer) {
        this.rotatedCubeVolume(world, rand, pos, 0, 1 + level, 9, this.blockHelper.AIR, 1, 3, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, -1, 1 + level, 9, this.blockHelper.AIR, 1, 2, 1, facing);
        this.rotatedCubeVolume(world, rand, pos, 1, 1 + level, 9, this.blockHelper.AIR, 1, 2, 1, facing);
        if (level == 0) {
            this.rotatedCubeVolume(world, rand, pos, 1, 3 + level, 9, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP, true), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -1, 3 + level, 9, this.blockHelper.getStairsForTowerLevel(rand, level, facing.func_176746_e(), BlockStairs.EnumHalf.TOP, true), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 0, 3 + level, 9, this.blockHelper.PITSTONE_BRICK_SLAB_UPPER, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 0, 4 + level, 9, this.blockHelper.PITSTONE_BRICK_SLAB_UPPER, 1, 1, 1, facing);
        }
        if (level == 8) {
            this.rotatedCubeVolume(world, rand, pos, 1, 3 + level, 9, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176734_d().func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -1, 3 + level, 9, this.blockHelper.getStairsForLevel(rand, 0, facing.func_176746_e(), BlockStairs.EnumHalf.TOP), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -3, 1 + level, 8, this.blockHelper.getPillarsForLevel(rand, 0, 1), 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 3, 1 + level, 8, this.blockHelper.getPillarsForLevel(rand, 0, 1), 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 0, 3 + level, 9, this.blockHelper.getMudSlabsForLevel(rand, 0, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 0, 4 + level, 9, this.blockHelper.getMudSlabsForLevel(rand, 0, BlockSlabBetweenlands.EnumBlockHalfBL.TOP), 1, 1, 1, facing);
        }
    }

    public void addLightBeams(World world, BlockPos pos, EnumFacing facing, Random rand, int level, int i) {
        if (level == 0) {
            this.rotatedCubeVolume(world, rand, pos, -2, 2 + level, 4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 1 + level, 4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 2 + level, 4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 1 + level, 4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 1 + level, 4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 1 + level, 4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 15, 6 + level, -1, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 14, 6 + level, -1, this.blockHelper.AIR, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 14, 7 + level, -1, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 15, 7 + level, -1, this.blockHelper.getRandomSupportBeam(facing.func_176734_d().func_176746_e(), false, rand), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 3 + level, -4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 1 + level, -4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 3 + level, -4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 1 + level, -4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 1 + level, -4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 1 + level, -4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 7 + level, -1, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 6 + level, -1, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 8, 6 + level, -1, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS.func_177226_a((IProperty)BlockBeamLensSupport.field_176387_N, (Comparable)facing.func_176746_e()), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 9, 6 + level, -1, this.blockHelper.MUD_TOWER_BEAM_TUBE.func_177226_a((IProperty)BlockBeamTube.field_176387_N, (Comparable)facing.func_176746_e()), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 1 + level, 4, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 2 + level, 4, this.blockHelper.PITSTONE_PILLAR, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 7 + level, 4, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 1 + level, -4, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 2 + level, -4, this.blockHelper.PITSTONE_PILLAR, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 5, 7 + level, -4, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -5, 1 + level, 4, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -5, 2 + level, 4, this.blockHelper.PITSTONE_PILLAR, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -5, 7 + level, 4, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -5, 1 + level, -4, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -5, 2 + level, -4, this.blockHelper.PITSTONE_PILLAR, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -5, 7 + level, -4, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
        }
        if (level == 8) {
            this.rotatedCubeVolume(world, rand, pos, 0, 2 + level, 0, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 0, 1 + level, 0, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 0 + level, 4, this.blockHelper.MUD_TOWER_BEAM_TUBE, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 3 + level, 4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 1 + level, 4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 0 + level, 4, this.blockHelper.MUD_TOWER_BEAM_TUBE, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 2 + level, 4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 1 + level, 4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, -1 + level, 4, this.blockHelper.MUD_TOWER_BEAM_TUBE, 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 1 + level, 4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 3 + level, 4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 4 + level, 4, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 5 + level, 4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 6 + level, 4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 7 + level, 4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, -1 + level, 4, this.blockHelper.MUD_TOWER_BEAM_TUBE, 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 6 + level, 4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 7 + level, 4, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 8 + level, 4, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 1 + level, 0, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 2 + level, 0, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 0 + level, -4, this.blockHelper.MUD_TOWER_BEAM_TUBE, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 1 + level, -4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 4, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -2, 4 + level, -4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 0 + level, -4, this.blockHelper.MUD_TOWER_BEAM_TUBE, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 1 + level, -4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 2, 2 + level, -4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, -1 + level, -4, this.blockHelper.MUD_TOWER_BEAM_TUBE, 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 1 + level, -4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 3, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 4 + level, -4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 5 + level, -4, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 6 + level, -4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 7 + level, -4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 6 + level, -1, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 7 + level, -1, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 8, 6 + level, -1, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS.func_177226_a((IProperty)BlockBeamLensSupport.field_176387_N, (Comparable)facing.func_176746_e()), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 0 + level, -1, this.blockHelper.MUD_TOWER_BEAM_TUBE, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 0 + level, -2, this.blockHelper.PITSTONE_BRICKS, 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 2 + level, -2, this.blockHelper.PITSTONE_PILLAR, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 7 + level, -2, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 0 + level, 2, this.blockHelper.PITSTONE_BRICKS, 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 2 + level, 2, this.blockHelper.PITSTONE_PILLAR, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 7 + level, 2, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 0 + level, 2, this.blockHelper.PITSTONE_BRICKS, 1, 2, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 2 + level, 2, this.blockHelper.PITSTONE_PILLAR, 1, 5, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 7 + level, 2, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 2 + level, -4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 1 + level, -4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 3 + level, -4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 4 + level, -4, this.blockHelper.getMudBricksForLevel(rand, 0, 0), 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 5 + level, -4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 6 + level, -4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, 7 + level, -4, this.blockHelper.PITSTONE_BRICKS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, 7, -1 + level, -4, this.blockHelper.MUD_TOWER_BEAM_TUBE, 1, 2, 1, facing);
        }
        if (level == 16) {
            this.rotatedCubeVolume(world, rand, pos, 0, 5 + level, 0, this.blockHelper.MUD_TOWER_BEAM_ORIGIN, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 2 + level, 4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 1 + level, 4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 0 + level, 4, this.blockHelper.MUD_TOWER_BEAM_TUBE, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 2 + level, -4, this.blockHelper.MUD_TOWER_BEAM_RELAY, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 1 + level, -4, this.blockHelper.MUD_TOWER_BEAM_LENS_SUPPORTS, 1, 1, 1, facing);
            this.rotatedCubeVolume(world, rand, pos, -7, 0 + level, -4, this.blockHelper.MUD_TOWER_BEAM_TUBE, 1, 1, 1, facing);
        }
    }

    public void rotatedCubeVolume(World world, Random rand, BlockPos pos, int offsetA, int offsetB, int offsetC, IBlockState state, int sizeWidth, int sizeHeight, int sizeDepth, EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int xx = offsetA; xx < offsetA + sizeWidth; ++xx) {
                        for (int zz = offsetC; zz < offsetC + sizeDepth; ++zz) {
                            this.dungeon.func_175903_a(world, pos.func_177982_a(xx, yy, zz), state);
                            if (state != this.blockHelper.ROTTEN_PLANK_SLAB_LOWER || rand.nextInt(10) != 0) continue;
                            this.addTriggeredFallingBlockEntity(world, pos.func_177982_a(xx, yy, zz));
                        }
                    }
                }
                break;
            }
            case EAST: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int zz = -offsetA; zz > -offsetA - sizeWidth; --zz) {
                        for (int xx = offsetC; xx < offsetC + sizeDepth; ++xx) {
                            this.dungeon.func_175903_a(world, pos.func_177982_a(xx, yy, zz), state);
                            if (state != this.blockHelper.ROTTEN_PLANK_SLAB_LOWER || rand.nextInt(10) != 0) continue;
                            this.addTriggeredFallingBlockEntity(world, pos.func_177982_a(xx, yy, zz));
                        }
                    }
                }
                break;
            }
            case NORTH: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int xx = -offsetA; xx > -offsetA - sizeWidth; --xx) {
                        for (int zz = -offsetC; zz > -offsetC - sizeDepth; --zz) {
                            this.dungeon.func_175903_a(world, pos.func_177982_a(xx, yy, zz), state);
                            if (state != this.blockHelper.ROTTEN_PLANK_SLAB_LOWER || rand.nextInt(10) != 0) continue;
                            this.addTriggeredFallingBlockEntity(world, pos.func_177982_a(xx, yy, zz));
                        }
                    }
                }
                break;
            }
            case WEST: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int zz = offsetA; zz < offsetA + sizeWidth; ++zz) {
                        for (int xx = -offsetC; xx > -offsetC - sizeDepth; --xx) {
                            this.dungeon.func_175903_a(world, pos.func_177982_a(xx, yy, zz), state);
                            if (state != this.blockHelper.ROTTEN_PLANK_SLAB_LOWER || rand.nextInt(10) != 0) continue;
                            this.addTriggeredFallingBlockEntity(world, pos.func_177982_a(xx, yy, zz));
                        }
                    }
                }
                break;
            }
        }
    }

    private void addTriggeredFallingBlockEntity(World world, BlockPos pos) {
        EntityTriggeredFallingBlock trap = new EntityTriggeredFallingBlock(world);
        trap.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
        trap.setWalkway(true);
        world.func_72838_d((Entity)trap);
    }

    public void destroyTowerBeamLenses(World world, BlockPos pos) {
        this.removeBlock(world, pos, -2, 2, 4);
        this.removeBlock(world, pos, 2, 2, 4);
        this.removeBlock(world, pos, -7, 1, 4);
        this.removeBlock(world, pos, 7, 1, 4);
        this.removeBlock(world, pos, 15, 6, -1);
        this.removeBlock(world, pos, -2, 3, -4);
        this.removeBlock(world, pos, 2, 3, -4);
        this.removeBlock(world, pos, -7, 1, -4);
        this.removeBlock(world, pos, 7, 1, -4);
        this.removeBlock(world, pos, 7, 6, -1);
        this.removeBlock(world, pos, 0, 10, 0);
        this.removeBlock(world, pos, -2, 11, 4);
        this.removeBlock(world, pos, 2, 10, 4);
        this.removeBlock(world, pos, -7, 11, 4);
        this.removeBlock(world, pos, -7, 14, 4);
        this.removeBlock(world, pos, 7, 14, 4);
        this.removeBlock(world, pos, 2, 10, 0);
        this.removeBlock(world, pos, -2, 12, -4);
        this.removeBlock(world, pos, 2, 10, -4);
        this.removeBlock(world, pos, -7, 12, -4);
        this.removeBlock(world, pos, -7, 14, -4);
        this.removeBlock(world, pos, 7, 14, -1);
        this.removeBlock(world, pos, 7, 10, -4);
        this.removeBlock(world, pos, 7, 14, -4);
        this.removeBlock(world, pos, 0, 21, 0);
        this.removeBlock(world, pos, -7, 18, 4);
        this.removeBlock(world, pos, -7, 18, -4);
    }

    public void destroyGateBeamLenses(World world, BlockPos pos) {
        this.removeBlock(world, pos, -8, 0, 0);
        this.removeBlock(world, pos, -8, 4, 0);
        this.removeBlock(world, pos, -1, 4, 0);
        this.removeBlock(world, pos, 0, 4, 0);
        this.removeBlock(world, pos, 0, 4, -1);
    }

    private void removeBlock(World world, BlockPos pos, int x, int y, int z) {
        world.func_175655_b(pos.func_177982_a(x, y, z), false);
    }
}

