/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import thebetweenlands.common.block.misc.BlockOfferingTable;
import thebetweenlands.common.block.structure.BlockSimulacrum;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityGroundItem;
import thebetweenlands.common.tile.TileEntitySimulacrum;

public class WorldGenSimulacrum
extends WorldGenerator {
    private final List<BlockSimulacrum> variants;
    private final ResourceLocation lootTableLocation;

    public WorldGenSimulacrum(List<BlockSimulacrum> variants, ResourceLocation lootTable) {
        this.variants = variants;
        this.lootTableLocation = lootTable;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        if (!world.field_72995_K && world.func_175623_d(position)) {
            for (int i = 0; i < 8 && world.func_175623_d(position); ++i) {
                position = position.func_177977_b();
            }
            if (world.func_175623_d(position = position.func_177984_a()) && world.isSideSolid(position.func_177977_b(), EnumFacing.UP) && this.canGenerateHere(world, rand, position)) {
                BlockSimulacrum block = this.variants.get(rand.nextInt(this.variants.size()));
                EnumFacing facing = null;
                if (world instanceof WorldServer && this.shouldGenerateOfferingTable(rand)) {
                    ArrayList<EnumFacing> offsets = new ArrayList<EnumFacing>(Arrays.asList(EnumFacing.field_176754_o));
                    Collections.shuffle(offsets, rand);
                    for (EnumFacing dir : offsets) {
                        LootContext.Builder lootBuilder;
                        List loot;
                        LootTable lootTable;
                        BlockPos offset = position.func_177972_a(dir);
                        if (!world.func_175623_d(offset) || !world.isSideSolid(offset.func_177977_b(), EnumFacing.UP)) continue;
                        this.func_175903_a(world, offset, BlockRegistry.OFFERING_TABLE.func_176223_P().func_177226_a((IProperty)BlockOfferingTable.FACING, (Comparable)dir.func_176734_d()));
                        facing = dir;
                        TileEntity tile = world.func_175625_s(offset);
                        if (!(tile instanceof TileEntityGroundItem) || (lootTable = ((WorldServer)world).func_184146_ak().func_186521_a(this.lootTableLocation)) == null || (loot = lootTable.func_186462_a(rand, (lootBuilder = new LootContext.Builder((WorldServer)world)).func_186471_a())).isEmpty()) break;
                        ((TileEntityGroundItem)tile).setStack((ItemStack)loot.get(0));
                        break;
                    }
                }
                IBlockState state = block.func_176223_P().func_177226_a(BlockSimulacrum.VARIANT, (Comparable)((Object)BlockSimulacrum.Variant.values()[rand.nextInt(BlockSimulacrum.Variant.values().length)])).func_177226_a((IProperty)BlockSimulacrum.FACING, facing == null ? EnumFacing.field_176754_o[rand.nextInt(EnumFacing.field_176754_o.length)] : facing);
                this.func_175903_a(world, position, state);
                TileEntity tile = world.func_175625_s(position);
                if (tile instanceof TileEntitySimulacrum) {
                    ((TileEntitySimulacrum)tile).setEffect(TileEntitySimulacrum.Effect.values()[rand.nextInt(TileEntitySimulacrum.Effect.values().length)]);
                }
                int torches = rand.nextInt(3);
                for (int i = 0; i < 32 && torches > 0; ++i) {
                    BlockPos offset;
                    int rx = rand.nextInt(5) - 2;
                    int rz = rand.nextInt(5) - 2;
                    if (rx == 0 && rz == 0 || Math.abs(rx) + Math.abs(rz) > 2 || !world.func_175623_d(offset = position.func_177982_a(rx, rand.nextInt(3) - 2, rz)) || !world.isSideSolid(offset.func_177977_b(), EnumFacing.UP)) continue;
                    this.func_175903_a(world, offset, BlockRegistry.MUD_FLOWER_POT_CANDLE.func_176223_P());
                    --torches;
                }
                return true;
            }
        }
        return false;
    }

    protected boolean shouldGenerateOfferingTable(Random rand) {
        return rand.nextInt(3) != 0;
    }

    protected boolean canGenerateHere(World world, Random rand, BlockPos pos) {
        return true;
    }
}

