/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.ArrayList;
import java.util.Random;
import java.util.Stack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.feature.WorldGenCave;

public class WorldGenCaveGrass
extends WorldGenCave {
    private static final int MIN_RADIUS = 2;
    private static final int MAX_RADIUS = 7;

    public WorldGenCaveGrass() {
        super(false);
    }

    private boolean canPlaceGrass(World world, BlockPos pos) {
        return world.func_175623_d(pos) && BlockRegistry.CAVE_GRASS.func_176196_c(world, pos);
    }

    public boolean func_180709_b(World world, Random random, BlockPos origin) {
        if (!this.canPlaceGrass(world, origin)) {
            return false;
        }
        int radius = random.nextInt(6) + 2;
        int radiusSq = radius * radius;
        Stack<BlockPos> searching = new Stack<BlockPos>();
        ArrayList<BlockPos> checked = new ArrayList<BlockPos>();
        ArrayList<BlockPos> locations = new ArrayList<BlockPos>();
        BlockPos start = origin;
        searching.push(start);
        checked.add(start);
        while (!searching.isEmpty()) {
            BlockPos pos = (BlockPos)searching.pop();
            double distSq = pos.func_177954_c((double)origin.func_177958_n(), (double)origin.func_177956_o(), (double)origin.func_177952_p());
            if ((double)(random.nextFloat() / 1.4f) > distSq / (double)radiusSq) {
                locations.add(pos);
            }
            for (EnumFacing dir : this.directions) {
                BlockPos p;
                BlockPos offsetPos = pos.func_177972_a(dir);
                if (offsetPos.func_177954_c((double)origin.func_177958_n(), (double)origin.func_177956_o(), (double)origin.func_177952_p()) > (double)radiusSq) continue;
                if (this.canPlaceGrass(world, offsetPos.func_177982_a(0, 1, 0))) {
                    p = offsetPos.func_177982_a(0, 1, 0);
                    if (checked.contains(p)) continue;
                    searching.push(p);
                    checked.add(p);
                    continue;
                }
                if (this.canPlaceGrass(world, offsetPos)) {
                    p = offsetPos;
                    if (checked.contains(p)) continue;
                    searching.push(p);
                    checked.add(p);
                    continue;
                }
                if (!this.canPlaceGrass(world, offsetPos.func_177982_a(0, -1, 0)) || checked.contains(p = offsetPos.func_177982_a(0, -1, 0))) continue;
                searching.push(p);
                checked.add(p);
            }
        }
        if (locations.size() < 3) {
            return false;
        }
        for (BlockPos pos : locations) {
            this.func_175903_a(world, pos, BlockRegistry.CAVE_GRASS.func_176223_P());
        }
        return true;
    }
}

