/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.gen.biome.BiomeWeights;
import thebetweenlands.common.world.gen.biome.feature.BiomeFeature;
import thebetweenlands.common.world.gen.biome.generator.BiomeGenerator;

public class SiltBeachFeature
extends BiomeFeature {
    private NoiseGeneratorPerlin siltNoiseGen;
    private double[] siltNoise = new double[256];
    private final float terrainWeightThreshold;

    public SiltBeachFeature() {
        this(1.0f);
    }

    public SiltBeachFeature(float terrainWeightThreshold) {
        this.terrainWeightThreshold = terrainWeightThreshold;
    }

    @Override
    public void initializeGenerators(long seed, Biome biome) {
        Random rng = new Random(seed);
        this.siltNoiseGen = new NoiseGeneratorPerlin(rng, 4);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, Biome biome) {
        this.siltNoise = this.siltNoiseGen.func_151599_a(this.siltNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.0625, 0.0625, 1.0);
    }

    @Override
    public void replaceStackBlocks(int x, int z, double baseBlockNoise, ChunkPrimer chunkPrimer, ChunkGeneratorBetweenlands chunkGenerator, Biome[] biomesForGeneration, Biome biome, BiomeWeights biomeWeights, BiomeGenerator.EnumGeneratorPass pass) {
        if (pass == BiomeGenerator.EnumGeneratorPass.POST_GEN_CAVES) {
            float biomeWeight = biomeWeights.get(x, z);
            if (this.siltNoise[x * 16 + z] / (double)1.6f + 1.5 <= 0.0 && biomeWeight <= this.terrainWeightThreshold) {
                int y = 120;
                Block currentBlock = chunkPrimer.func_177856_a(x, y, z).func_177230_c();
                Block blockAbove = chunkPrimer.func_177856_a(x, y + 1, z).func_177230_c();
                if (currentBlock == biome.field_76752_A.func_177230_c() && (blockAbove == null || blockAbove == Blocks.field_150350_a)) {
                    chunkPrimer.func_177855_a(x, y, z, BlockRegistry.SILT.func_176223_P());
                }
            }
        }
    }
}

