/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.gen.biome.BiomeWeights;
import thebetweenlands.common.world.gen.biome.feature.BiomeFeature;
import thebetweenlands.common.world.gen.biome.generator.BiomeGenerator;

public class DeepWatersFeature
extends BiomeFeature {
    private NoiseGeneratorPerlin islandNoiseGen;
    private double[] terrainNoise = new double[256];

    @Override
    public void initializeGenerators(long seed, Biome biome) {
        Random rng = new Random(seed);
        this.islandNoiseGen = new NoiseGeneratorPerlin(rng, 4);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, Biome biome) {
        this.terrainNoise = this.islandNoiseGen.func_151599_a(this.terrainNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.05, 0.05, 1.0);
    }

    @Override
    public void replaceStackBlocks(int x, int z, double baseBlockNoise, ChunkPrimer chunkPrimer, ChunkGeneratorBetweenlands chunkGenerator, Biome[] biomesForGeneration, Biome biome, BiomeWeights biomeWeights, BiomeGenerator.EnumGeneratorPass pass) {
        if (pass == BiomeGenerator.EnumGeneratorPass.PRE_REPLACE_BIOME_BLOCKS) {
            float biomeWeight = biomeWeights.get(x, z);
            int layerHeight = 120;
            int lowestBlock = 0;
            for (int yOff = 0; yOff < layerHeight; ++yOff) {
                int y = layerHeight - yOff;
                Block currentBlock = chunkPrimer.func_177856_a(x, y, z).func_177230_c();
                if (currentBlock == chunkGenerator.layerBlock) continue;
                lowestBlock = y;
                break;
            }
            double noise = this.terrainNoise[x * 16 + z] / 12.0;
            int y = lowestBlock;
            while ((double)y < DeepWatersFeature.lerp((double)((float)layerHeight - (float)(layerHeight - lowestBlock) / 2.5f) + noise * (double)(layerHeight - lowestBlock) - 2.0, lowestBlock, biomeWeight)) {
                chunkPrimer.func_177855_a(x, y, z, chunkGenerator.baseBlockState);
                ++y;
            }
        }
    }
}

