/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.common.block.terrain.BlockCragrock;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.gen.biome.BiomeWeights;
import thebetweenlands.common.world.gen.biome.feature.BiomeFeature;
import thebetweenlands.common.world.gen.biome.generator.BiomeGenerator;

public class CragSpiresFeature
extends BiomeFeature {
    private final IBlockState cragrockDefault = BlockRegistry.CRAGROCK.func_176223_P().func_177226_a(BlockCragrock.VARIANT, (Comparable)((Object)BlockCragrock.EnumCragrockType.DEFAULT));
    private final IBlockState cragrockMossy1 = BlockRegistry.CRAGROCK.func_176223_P().func_177226_a(BlockCragrock.VARIANT, (Comparable)((Object)BlockCragrock.EnumCragrockType.MOSSY_1));
    private final IBlockState cragrockMossy2 = BlockRegistry.CRAGROCK.func_176223_P().func_177226_a(BlockCragrock.VARIANT, (Comparable)((Object)BlockCragrock.EnumCragrockType.MOSSY_2));
    private NoiseGeneratorPerlin spireNoiseGen;
    private double[] spireNoise = new double[256];

    @Override
    public void initializeGenerators(long seed, Biome biome) {
        Random rng = new Random(seed);
        this.spireNoiseGen = new NoiseGeneratorPerlin(rng, 4);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, Biome biome) {
        this.spireNoise = this.spireNoiseGen.func_151599_a(this.spireNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.16, 0.16, 1.0);
    }

    @Override
    public void replaceStackBlocks(int x, int z, double baseBlockNoise, ChunkPrimer chunkPrimer, ChunkGeneratorBetweenlands chunkGenerator, Biome[] biomesForGeneration, Biome biome, BiomeWeights biomeWeights, BiomeGenerator.EnumGeneratorPass pass) {
        block10: {
            int layerHeight;
            double noise;
            float biomeWeight;
            block11: {
                if (pass != BiomeGenerator.EnumGeneratorPass.PRE_REPLACE_BIOME_BLOCKS) break block10;
                biomeWeight = biomeWeights.get(x, z);
                noise = this.spireNoise[x * 16 + z] / 1.5 * (double)biomeWeight + (double)2.4f;
                layerHeight = 120;
                if (chunkPrimer.func_177856_a(x, layerHeight, z).func_177230_c() != chunkGenerator.layerBlock) {
                    return;
                }
                int lowestBlock = 0;
                for (int yOff = 0; yOff < layerHeight; ++yOff) {
                    int y = layerHeight - yOff;
                    Block currentBlock = chunkPrimer.func_177856_a(x, y, z).func_177230_c();
                    if (currentBlock == chunkGenerator.layerBlock) continue;
                    lowestBlock = y;
                    break;
                }
                if (120 - lowestBlock < 3) {
                    return;
                }
                if (!(-noise * 12.0 >= 1.0)) break block11;
                for (int y = lowestBlock; y < layerHeight; ++y) {
                    chunkPrimer.func_177855_a(x, y, z, this.cragrockDefault);
                }
                int rockHeight = (int)Math.floor(-noise * 12.0);
                for (int yOff = 0; yOff < rockHeight; ++yOff) {
                    int y = layerHeight + yOff;
                    if (yOff == rockHeight - 2) {
                        chunkPrimer.func_177855_a(x, y, z, this.cragrockMossy2);
                        continue;
                    }
                    if (yOff == rockHeight - 1) {
                        chunkPrimer.func_177855_a(x, y, z, this.cragrockMossy1);
                        continue;
                    }
                    chunkPrimer.func_177855_a(x, y, z, this.cragrockDefault);
                }
                break block10;
            }
            boolean validSpire = false;
            block3: for (int xo = -4; xo < 4; ++xo) {
                for (int zo = -4; zo < 4; ++zo) {
                    int nx = x + xo;
                    int nz = z + zo;
                    int n = nx < 0 ? 0 : (nx = nx > 15 ? 15 : nx);
                    double sNoise = this.spireNoise[nx * 16 + (nz = nz < 0 ? 0 : (nz > 15 ? 15 : nz))] * (double)biomeWeight / 1.5 + (double)2.4f;
                    if (!(-sNoise * 12.0 >= 1.0)) continue;
                    validSpire = true;
                    continue block3;
                }
            }
            if (!validSpire) break block10;
            int rockHeight = (int)Math.floor(-noise * 12.0);
            for (int y = lowestBlock; y < layerHeight + rockHeight; ++y) {
                chunkPrimer.func_177855_a(x, y, z, this.cragrockDefault);
            }
        }
    }
}

