/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.sky.BLSnowRenderer;
import thebetweenlands.common.block.terrain.BlockSnowBetweenlands;
import thebetweenlands.common.network.datamanager.GenericDataManager;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.event.TimedEnvironmentEvent;

public class EventSnowfall
extends TimedEnvironmentEvent {
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "snowfall");
    protected static final ResourceLocation[] VISION_TEXTURES = new ResourceLocation[]{new ResourceLocation("thebetweenlands:textures/events/snowfall.png")};
    private float snowingStrength = 0.0f;
    protected static final DataParameter<Float> TARGET_SNOWING_STRENGTH = GenericDataManager.createKey(EventSnowfall.class, DataSerializers.field_187193_c);

    public EventSnowfall(BLEnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    protected void initDataParameters() {
        super.initDataParameters();
        this.dataManager.register(TARGET_SNOWING_STRENGTH, Float.valueOf(0.0f));
    }

    public static float getSnowingStrength(World world) {
        WorldProviderBetweenlands provider;
        if (world != null && (provider = WorldProviderBetweenlands.getProvider(world)) != null) {
            return provider.getEnvironmentEventRegistry().snowfall.getSnowingStrength();
        }
        return 0.0f;
    }

    public float getSnowingStrength() {
        return this.snowingStrength;
    }

    public boolean isSnowing() {
        return this.snowingStrength > 0.0f;
    }

    @Override
    protected boolean canActivate() {
        return this.getRegistry().winter.isActive();
    }

    @Override
    public ResourceLocation getEventName() {
        return ID;
    }

    @Override
    public void setActive(boolean active) {
        if (!this.getWorld().field_72995_K) {
            if (active) {
                this.dataManager.set(TARGET_SNOWING_STRENGTH, Float.valueOf(0.5f + this.getWorld().field_73012_v.nextFloat() * 7.5f));
            } else {
                this.dataManager.set(TARGET_SNOWING_STRENGTH, Float.valueOf(0.0f));
            }
        }
        super.setActive(active);
    }

    @Override
    public void update(World world) {
        float targetSnowingStrength;
        super.update(world);
        if (!world.field_72995_K) {
            if (this.isActive() && !this.getRegistry().winter.isActive()) {
                this.setActive(false);
            }
            if (this.isActive() && world.field_73011_w instanceof WorldProviderBetweenlands && world instanceof WorldServer && world.field_73012_v.nextInt(5) == 0) {
                WorldServer worldServer = (WorldServer)world;
                Iterator iterator = worldServer.getPersistentChunkIterable(worldServer.func_184164_w().func_187300_b());
                while (iterator.hasNext()) {
                    int layers;
                    Chunk chunk = (Chunk)iterator.next();
                    int cbx = world.field_73012_v.nextInt(16);
                    int cbz = world.field_73012_v.nextInt(16);
                    BlockPos pos = chunk.func_177440_h(new BlockPos(chunk.func_76632_l().func_180334_c() + cbx, -999, chunk.func_76632_l().func_180333_d() + cbz)).func_177977_b();
                    if (world.field_73012_v.nextInt(Math.max(20 - (int)(this.getSnowingStrength() / 8.0f * 18.0f), 2)) != 0) continue;
                    IBlockState stateAbove = world.func_180495_p(pos.func_177984_a());
                    if (stateAbove.func_177230_c() == Blocks.field_150350_a && BlockRegistry.SNOW.func_176196_c(world, pos.func_177984_a())) {
                        world.func_175656_a(pos.func_177984_a(), BlockRegistry.SNOW.func_176223_P());
                        continue;
                    }
                    if (!(stateAbove.func_177230_c() instanceof BlockSnowBetweenlands) || (layers = ((Integer)stateAbove.func_177229_b((IProperty)BlockSnowBetweenlands.field_176315_a)).intValue()) >= 5) continue;
                    boolean hasEnoughSnowAround = true;
                    BlockPos.PooledMutableBlockPos checkPos = BlockPos.PooledMutableBlockPos.func_185346_s();
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        checkPos.func_181079_c(pos.func_177958_n() + dir.func_82601_c(), pos.func_177956_o() + 1, pos.func_177952_p() + dir.func_82599_e());
                        if (world.func_175667_e((BlockPos)checkPos)) {
                            IBlockState neighourState = world.func_180495_p((BlockPos)checkPos);
                            if (!BlockRegistry.SNOW.func_176196_c(world, (BlockPos)checkPos) || neighourState.func_177230_c() == BlockRegistry.SNOW && (Integer)neighourState.func_177229_b((IProperty)BlockSnowBetweenlands.field_176315_a) >= layers) continue;
                            hasEnoughSnowAround = false;
                            continue;
                        }
                        hasEnoughSnowAround = false;
                        break;
                    }
                    checkPos.func_185344_t();
                    if (!hasEnoughSnowAround) continue;
                    world.func_175656_a(pos.func_177984_a(), stateAbove.func_177226_a((IProperty)BlockSnowBetweenlands.field_176315_a, (Comparable)Integer.valueOf(layers + 1)));
                }
            }
        } else {
            this.updateSnowRenderer(world);
        }
        if (!this.isActive()) {
            this.dataManager.set(TARGET_SNOWING_STRENGTH, Float.valueOf(0.0f));
        }
        if (this.snowingStrength < (targetSnowingStrength = this.dataManager.get(TARGET_SNOWING_STRENGTH).floatValue())) {
            this.snowingStrength += 0.01f;
            if (this.snowingStrength > targetSnowingStrength) {
                this.snowingStrength = targetSnowingStrength;
            }
        } else if (this.snowingStrength > targetSnowingStrength) {
            this.snowingStrength -= 0.01f;
            if (this.snowingStrength < targetSnowingStrength) {
                this.snowingStrength = targetSnowingStrength;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateSnowRenderer(World world) {
        BLSnowRenderer.INSTANCE.update(world);
    }

    @Override
    public void saveEventData() {
        super.saveEventData();
        NBTTagCompound nbt = this.getData();
        nbt.func_74776_a("targetSnowingStrength", this.dataManager.get(TARGET_SNOWING_STRENGTH).floatValue());
    }

    @Override
    public void loadEventData() {
        super.loadEventData();
        NBTTagCompound nbt = this.getData();
        this.dataManager.set(TARGET_SNOWING_STRENGTH, Float.valueOf(nbt.func_74760_g("targetSnowingStrength")));
    }

    @Override
    public int getOffTime(Random rnd) {
        return 18000 + rnd.nextInt(18000);
    }

    @Override
    public int getOnTime(Random rnd) {
        return 4800 + rnd.nextInt(6000);
    }

    @Override
    public ResourceLocation[] getVisionTextures() {
        return VISION_TEXTURES;
    }

    @Override
    public SoundEvent getChimesSound() {
        return SoundRegistry.CHIMES_SNOWFALL;
    }
}

