/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntry;
import thebetweenlands.common.entity.mobs.EntityAngler;
import thebetweenlands.common.entity.mobs.EntityBloodSnail;
import thebetweenlands.common.entity.mobs.EntityBoulderSprite;
import thebetweenlands.common.entity.mobs.EntityBubblerCrab;
import thebetweenlands.common.entity.mobs.EntityCaveFish;
import thebetweenlands.common.entity.mobs.EntityChiromaw;
import thebetweenlands.common.entity.mobs.EntityChiromawGreeblingRider;
import thebetweenlands.common.entity.mobs.EntityFirefly;
import thebetweenlands.common.entity.mobs.EntityFrog;
import thebetweenlands.common.entity.mobs.EntityGecko;
import thebetweenlands.common.entity.mobs.EntityGiantToad;
import thebetweenlands.common.entity.mobs.EntityLeech;
import thebetweenlands.common.entity.mobs.EntityMireSnail;
import thebetweenlands.common.entity.mobs.EntityOlm;
import thebetweenlands.common.entity.mobs.EntityShambler;
import thebetweenlands.common.entity.mobs.EntitySporeling;
import thebetweenlands.common.entity.mobs.EntityStalker;
import thebetweenlands.common.entity.mobs.EntitySwampHag;
import thebetweenlands.common.entity.mobs.EntitySwarm;
import thebetweenlands.common.entity.mobs.EntityTarBeast;
import thebetweenlands.common.entity.mobs.EntityWight;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.biome.BiomeBetweenlands;
import thebetweenlands.common.world.biome.spawning.spawners.BetweenstoneCaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.CaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.GreeblingSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.PitstoneCaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SkySpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SporelingSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SurfaceSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SwampHagCaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.TarSpawnEntry;
import thebetweenlands.common.world.gen.biome.decorator.BiomeDecoratorSwamplands;
import thebetweenlands.common.world.gen.biome.feature.AlgaeFeature;
import thebetweenlands.common.world.gen.biome.feature.FlatLandFeature;
import thebetweenlands.common.world.gen.biome.feature.PatchFeature;
import thebetweenlands.common.world.gen.biome.feature.SiltBeachFeature;

public class BiomeSwamplands
extends BiomeBetweenlands {
    public BiomeSwamplands() {
        super(new ResourceLocation("thebetweenlands", "swamplands"), new Biome.BiomeProperties("Swamplands").func_185398_c(118.0f).func_185400_d(1.0f).func_185402_a(1589792).func_185410_a(0.8f).func_185395_b(0.9f));
        this.setWeight(25);
        this.getBiomeGenerator().setFillerBlockState(BlockRegistry.COARSE_SWAMP_DIRT.func_176223_P()).setTopBlockState(BlockRegistry.DEAD_GRASS.func_176223_P()).addFeature(new FlatLandFeature(120, 8)).addFeature(new PatchFeature(0.18, 0.18, BlockRegistry.SWAMP_GRASS.func_176223_P())).addFeature(new PatchFeature(0.05, 0.05, BlockRegistry.SWAMP_GRASS.func_176223_P())).addFeature(new PatchFeature(0.74, 0.74, BlockRegistry.COARSE_SWAMP_DIRT.func_176223_P())).addFeature(new PatchFeature(0.65, 0.65, BlockRegistry.MUD.func_176223_P(), 0.7407407407407407, 1.72)).addFeature(new AlgaeFeature()).addFeature(new SiltBeachFeature(0.98f)).setDecorator(new BiomeDecoratorSwamplands(this));
        this.setFoliageColors(2817792, 5418842);
        this.setSecondaryFoliageColors(5283904, 8761169);
    }

    @Override
    public void addTypes() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER});
    }

    @Override
    protected void addSpawnEntries(List<ICustomSpawnEntry> entries) {
        super.addSpawnEntries(entries);
        entries.add(new SurfaceSpawnEntry(0, EntityFirefly.class, EntityFirefly::new, 95).setCanSpawnOnWater(true).setSpawnCheckRadius(32.0));
        entries.add(new SurfaceSpawnEntry(1, EntityGecko.class, EntityGecko::new, 40).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(600));
        entries.add(new SurfaceSpawnEntry(2, EntityMireSnail.class, EntityMireSnail::new, 60).setGroupSize(1, 5).setSpawnCheckRadius(32.0).setSpawningInterval(1000));
        entries.add(new SurfaceSpawnEntry(3, EntityFrog.class, EntityFrog::new, 26).setCanSpawnOnWater(true).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(1000));
        entries.add(new CaveSpawnEntry(4, EntityOlm.class, EntityOlm::new, 30).setCanSpawnInWater(true).setGroupSize(3, 5).setSpawnCheckRadius(32.0));
        entries.add(new SporelingSpawnEntry(5, EntitySporeling.class, EntitySporeling::new, 120).setGroupSize(2, 5).setSpawnCheckRadius(32.0));
        entries.add(new SurfaceSpawnEntry(6, EntityGiantToad.class, EntityGiantToad::new, 12).setSpawnCheckRadius(64.0).setSpawningInterval(800));
        entries.add(new CaveSpawnEntry(7, EntityGiantToad.class, EntityGiantToad::new, 8).setSpawnCheckRadius(64.0).setSpawningInterval(800));
        entries.add(new GreeblingSpawnEntry(8, 20).setGroupSize(1, 3).setSpawnCheckRadius(64.0).setGroupSpawnRadius(4.0).setSpawningInterval(24000));
        entries.add(new TarSpawnEntry(9, EntityTarBeast.class, EntityTarBeast::new, 80).setHostile(true));
        entries.add(new SurfaceSpawnEntry(10, EntityLeech.class, EntityLeech::new, 35).setHostile(true).setSpawnCheckRadius(24.0).setSpawningInterval(1000));
        entries.add(new SurfaceSpawnEntry(11, EntityAngler.class, EntityAngler::new, 40).setCanSpawnInWater(true).setHostile(true));
        entries.add(new CaveSpawnEntry(12, EntityAngler.class, EntityAngler::new, 35).setCanSpawnInWater(true).setHostile(true).setGroupSize(1, 3));
        entries.add(new SurfaceSpawnEntry(13, EntitySwampHag.class, EntitySwampHag::new, 90).setHostile(true));
        entries.add(new SwampHagCaveSpawnEntry(14, 140).setHostile(true).setSpawnCheckRadius(24.0).setGroupSize(1, 3));
        entries.add(new SurfaceSpawnEntry(15, EntityWight.class, EntityWight::new, 24).setHostile(true).setSpawnCheckRadius(64.0).setSpawnCheckRangeY(16.0).setSpawningInterval(6000));
        entries.add(new CaveSpawnEntry(16, EntityWight.class, EntityWight::new, 28).setHostile(true).setSpawnCheckRadius(64.0));
        entries.add(new SurfaceSpawnEntry(17, EntityBloodSnail.class, EntityBloodSnail::new, 25).setHostile(true).setSpawnCheckRadius(32.0).setSpawningInterval(1000));
        entries.add(new SurfaceSpawnEntry(18, EntityChiromaw.class, EntityChiromaw::new, 40).setHostile(true).setSpawnCheckRadius(30.0));
        entries.add(new CaveSpawnEntry(19, EntityChiromaw.class, EntityChiromaw::new, 60).setHostile(true).setSpawnCheckRadius(20.0).setGroupSize(1, 3));
        entries.add(new BetweenstoneCaveSpawnEntry(20, EntityBoulderSprite.class, EntityBoulderSprite::new, 60).setHostile(true).setSpawnCheckRadius(16.0).setSpawnCheckRangeY(8.0));
        entries.add(new SkySpawnEntry(21, EntityChiromawGreeblingRider.class, EntityChiromawGreeblingRider::new, 20).setSpawnCheckRadius(64.0).setGroupSize(1, 3).setSpawningInterval(600).setHostile(true));
        entries.add(new PitstoneCaveSpawnEntry(22, EntityStalker.class, EntityStalker::new, 20).setConstantWeight(true).setHostile(true).setSpawnCheckRadius(64.0).setSpawnCheckRangeY(16.0).setSpawningInterval(6000));
        entries.add(new CaveSpawnEntry(23, EntitySwarm.class, EntitySwarm::new, 65).setConstantWeight(true).setHostile(true).setSpawnCheckRadius(32.0));
        entries.add(new SurfaceSpawnEntry(24, EntityShambler.class, EntityShambler::new, 30).setHostile(true));
        entries.add(new CaveSpawnEntry(25, EntityCaveFish.class, EntityCaveFish::new, 30).setCanSpawnInWater(true).setGroupSize(1, 3).setSpawnCheckRadius(32.0));
        entries.add(new SurfaceSpawnEntry(26, EntityBubblerCrab.class, EntityBubblerCrab::new, 50).setSurfacePredicate((Predicate<IBlockState>)((Predicate)state -> state.func_177230_c() == BlockRegistry.SILT)).setHostile(true).setGroupSize(2, 8).setSpawnCheckRadius(32.0).setSpawnCheckRangeY(16.0).setSpawningInterval(1000));
    }
}

