/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntry;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.entity.mobs.EntityAngler;
import thebetweenlands.common.entity.mobs.EntityBloodSnail;
import thebetweenlands.common.entity.mobs.EntityBoulderSprite;
import thebetweenlands.common.entity.mobs.EntityCaveFish;
import thebetweenlands.common.entity.mobs.EntityChiromaw;
import thebetweenlands.common.entity.mobs.EntityChiromawGreeblingRider;
import thebetweenlands.common.entity.mobs.EntityDragonFly;
import thebetweenlands.common.entity.mobs.EntityEmberlingWild;
import thebetweenlands.common.entity.mobs.EntityFirefly;
import thebetweenlands.common.entity.mobs.EntityFrog;
import thebetweenlands.common.entity.mobs.EntityGecko;
import thebetweenlands.common.entity.mobs.EntityLeech;
import thebetweenlands.common.entity.mobs.EntityLurker;
import thebetweenlands.common.entity.mobs.EntityMireSnail;
import thebetweenlands.common.entity.mobs.EntityOlm;
import thebetweenlands.common.entity.mobs.EntityShambler;
import thebetweenlands.common.entity.mobs.EntitySiltCrab;
import thebetweenlands.common.entity.mobs.EntitySporeling;
import thebetweenlands.common.entity.mobs.EntityStalker;
import thebetweenlands.common.entity.mobs.EntitySwampHag;
import thebetweenlands.common.entity.mobs.EntitySwarm;
import thebetweenlands.common.entity.mobs.EntityWight;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.biome.BiomeBetweenlands;
import thebetweenlands.common.world.biome.spawning.spawners.BetweenstoneCaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.CaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.GreeblingSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.PitstoneCaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SkySpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SporelingSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SurfaceSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SwampHagCaveSpawnEntry;
import thebetweenlands.common.world.gen.biome.decorator.BiomeDecoratorPatchyIslands;
import thebetweenlands.common.world.gen.biome.feature.AlgaeFeature;
import thebetweenlands.common.world.gen.biome.feature.SiltBeachFeature;

public class BiomePatchyIslands
extends BiomeBetweenlands {
    public BiomePatchyIslands() {
        super(new ResourceLocation("thebetweenlands", "patchy_islands"), new Biome.BiomeProperties("Patchy Islands").func_185398_c(118.75f).func_185400_d(4.75f).func_185402_a(1589792).func_185410_a(0.8f).func_185395_b(0.9f));
        this.setWeight(20);
        this.getBiomeGenerator().setDecorator(new BiomeDecoratorPatchyIslands(this)).addFeature(new SiltBeachFeature()).addFeature(new AlgaeFeature());
        this.setFoliageColors(2082413, 44412);
        this.setSecondaryFoliageColors(2082365, -1);
    }

    @Override
    public void addTypes() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER});
    }

    @Override
    protected void addSpawnEntries(List<ICustomSpawnEntry> entries) {
        super.addSpawnEntries(entries);
        entries.add(new SurfaceSpawnEntry(0, EntityDragonFly.class, EntityDragonFly::new, 35).setCanSpawnOnWater(true).setGroupSize(1, 3).setSpawnCheckRadius(64.0).setSpawningInterval(400));
        entries.add(new SurfaceSpawnEntry(1, EntityFirefly.class, EntityFirefly::new, 60).setCanSpawnOnWater(true).setSpawnCheckRadius(32.0));
        entries.add(new SurfaceSpawnEntry(2, EntityMireSnail.class, EntityMireSnail::new, 60).setGroupSize(1, 5).setSpawnCheckRadius(32.0).setSpawningInterval(1000));
        entries.add(new SurfaceSpawnEntry(3, EntityFrog.class, EntityFrog::new, 32).setCanSpawnOnWater(true).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(1000));
        entries.add(new CaveSpawnEntry(4, EntityOlm.class, EntityOlm::new, 30).setCanSpawnInWater(true).setGroupSize(3, 5).setSpawnCheckRadius(32.0));
        entries.add(new SurfaceSpawnEntry(5, EntityGecko.class, EntityGecko::new, 40).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(600));
        entries.add(new SporelingSpawnEntry(6, EntitySporeling.class, EntitySporeling::new, 80).setGroupSize(2, 5).setSpawnCheckRadius(32.0));
        entries.add(new GreeblingSpawnEntry(7, 20).setGroupSize(1, 3).setSpawnCheckRadius(64.0).setGroupSpawnRadius(4.0).setSpawningInterval(24000));
        entries.add(new SurfaceSpawnEntry(8, EntityEmberlingWild.class, EntityEmberlingWild::new, 20).setSurfacePredicate((Predicate<IBlockState>)((Predicate)state -> state.func_177230_c() == BlockRegistry.LOG_HEARTHGROVE)).setHostile(true).setGroupSize(1, 1).setSpawnCheckRadius(32.0));
        entries.add(new SurfaceSpawnEntry(9, EntityLurker.class, EntityLurker::new, 35).setCanSpawnInWater(true).setHostile(true).setSpawnCheckRadius(16.0));
        entries.add(new SurfaceSpawnEntry(10, EntityAngler.class, EntityAngler::new, 45).setCanSpawnInWater(true).setHostile(true).setGroupSize(1, 3));
        entries.add(new CaveSpawnEntry(11, EntityAngler.class, EntityAngler::new, 35).setCanSpawnInWater(true).setHostile(true).setGroupSize(1, 3));
        entries.add(new SurfaceSpawnEntry(12, EntitySwampHag.class, EntitySwampHag::new, 90).setHostile(true));
        entries.add(new SwampHagCaveSpawnEntry(13, 80).setHostile(true).setSpawnCheckRadius(24.0).setGroupSize(1, 3));
        entries.add(new SurfaceSpawnEntry(14, EntityWight.class, EntityWight::new, 16).setHostile(true).setSpawnCheckRadius(64.0).setSpawnCheckRangeY(16.0).setSpawningInterval(6000));
        entries.add(new CaveSpawnEntry(15, EntityWight.class, EntityWight::new, 18).setHostile(true).setSpawnCheckRadius(64.0));
        entries.add(new SurfaceSpawnEntry(16, EntitySiltCrab.class, EntitySiltCrab::new, 50).setSurfacePredicate((Predicate<IBlockState>)((Predicate)state -> state.func_177230_c() == BlockRegistry.SILT)).setHostile(true).setGroupSize(2, 8).setSpawnCheckRadius(32.0).setSpawnCheckRangeY(16.0).setSpawningInterval(1000));
        entries.add(new SurfaceSpawnEntry(17, EntityBloodSnail.class, EntityBloodSnail::new, 30).setHostile(true).setSpawnCheckRadius(32.0).setSpawningInterval(1000));
        entries.add(new SurfaceSpawnEntry(18, EntityLeech.class, EntityLeech::new, 35).setHostile(true).setSpawnCheckRadius(24.0).setSpawningInterval(1000));
        entries.add(new SurfaceSpawnEntry(19, EntityChiromaw.class, EntityChiromaw::new, 40).setHostile(true).setSpawnCheckRadius(30.0));
        entries.add(new CaveSpawnEntry(20, EntityChiromaw.class, EntityChiromaw::new, 60).setHostile(true).setSpawnCheckRadius(20.0).setGroupSize(1, 3));
        entries.add(new BetweenstoneCaveSpawnEntry(21, EntityBoulderSprite.class, EntityBoulderSprite::new, 60).setHostile(true).setSpawnCheckRadius(16.0).setSpawnCheckRangeY(8.0));
        entries.add(new SkySpawnEntry(22, EntityChiromawGreeblingRider.class, EntityChiromawGreeblingRider::new, 20).setSpawnCheckRadius(64.0).setGroupSize(1, 3).setSpawningInterval(600).setHostile(true));
        entries.add(new PitstoneCaveSpawnEntry(23, EntityStalker.class, EntityStalker::new, 13).setConstantWeight(true).setHostile(true).setSpawnCheckRadius(64.0).setSpawnCheckRangeY(16.0).setSpawningInterval(6000));
        entries.add(new CaveSpawnEntry(24, EntitySwarm.class, EntitySwarm::new, 50).setConstantWeight(true).setHostile(true).setSpawnCheckRadius(32.0));
        entries.add(new SurfaceSpawnEntry(25, EntityShambler.class, EntityShambler::new, 30).setHostile(true));
        entries.add(new SurfaceSpawnEntry(26, EntityAnadia.class, EntityAnadia::new, 60).setCanSpawnInWater(true).setHostile(false).setGroupSize(1, 5));
        entries.add(new CaveSpawnEntry(27, EntityCaveFish.class, EntityCaveFish::new, 30).setCanSpawnInWater(true).setGroupSize(1, 3).setSpawnCheckRadius(32.0));
    }
}

