/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.container.BlockCrabPotFilter;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.recipe.misc.CrabPotFilterRecipeBubbler;
import thebetweenlands.common.recipe.misc.CrabPotFilterRecipeSilt;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityBasicInventory;
import thebetweenlands.common.tile.TileEntityCrabPot;

public class TileEntityCrabPotFilter
extends TileEntityBasicInventory
implements ITickable,
ISidedInventory {
    private static final int EVENT_RESET_FILTERING_PROGRESS = 80;
    protected int maxFilteringTime = 200;
    private int baitProgress = 0;
    private int filteringProgress = 0;
    private int itemsToFilterCount = 3;
    private int prevFilteringAnimationTicks;
    private int filteringAnimationTicks;
    private boolean active;
    private int horizontalIndex = 0;
    private final int baitSlot = 0;
    private final int inputSlot = 1;
    private final int outputSlot = 2;
    private final int[] resultSideSlot = new int[]{2};
    private final int[] allSideSlots = new int[]{0, 1};

    public TileEntityCrabPotFilter() {
        super(3, "container.bl.crab_pot_filter");
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        BlockPos pos = this.func_174877_v();
        if (this.func_145831_w().field_72995_K) {
            this.prevFilteringAnimationTicks = this.filteringAnimationTicks;
            if (this.func_145831_w().func_180495_p(pos).func_177230_c() instanceof BlockCrabPotFilter && this.active && this.canFilterSlots(1, 2)) {
                this.filteringAnimationTicks = Math.min(this.filteringAnimationTicks + 1, this.maxFilteringTime);
            } else {
                this.filteringAnimationTicks = 0;
                this.prevFilteringAnimationTicks = 0;
            }
            return;
        }
        if (this.func_145831_w().func_180495_p(pos.func_177984_a()).func_177230_c() == BlockRegistry.CRAB_POT && !this.active && this.hasCrabInTile()) {
            this.active = true;
            this.markForUpdate();
        }
        if (this.func_145831_w().func_180495_p(pos.func_177984_a()).func_177230_c() == BlockRegistry.CRAB_POT && this.hasCrabInTile()) {
            this.checkForAnmation();
        }
        if (this.active && (this.func_145831_w().func_180495_p(pos.func_177984_a()).func_177230_c() != BlockRegistry.CRAB_POT || !this.hasCrabInTile())) {
            this.active = false;
            this.markForUpdate();
        }
        if (this.func_145831_w().func_180495_p(pos).func_177230_c() instanceof BlockCrabPotFilter && this.active) {
            if (this.hasBait() && this.canFilterSlots(1, 2)) {
                if (this.getBaitProgress() == 0) {
                    this.consumeBait();
                }
                this.setBaitProgress(this.getBaitProgress() + 1);
            }
            if (this.canFilterSlots(1, 2)) {
                this.setSlotProgress(this.getSlotProgress() + 1);
                if (this.getSlotProgress() >= this.maxFilteringTime) {
                    this.filterItem(1, 2);
                    this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 80, 0);
                }
                if (this.getSlotProgress() % 10 == 0) {
                    this.markForUpdate();
                }
            } else if (this.getSlotProgress() > 0) {
                this.setSlotProgress(0);
                this.markForUpdate();
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 80) {
            if (this.field_145850_b.field_72995_K) {
                this.filteringAnimationTicks = 0;
                this.prevFilteringAnimationTicks = 0;
            }
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public boolean isActive() {
        return this.active;
    }

    private void checkForAnmation() {
        TileEntityCrabPot tile = (TileEntityCrabPot)this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (tile != null && (tile.hasSiltCrab() || tile.hasBubblerCrab())) {
            if (this.canFilterSlots(1, 2) && !tile.animate) {
                tile.animate = true;
                tile.markForUpdate();
            }
            if (!this.canFilterSlots(1, 2) && tile.animate) {
                tile.animate = false;
                tile.markForUpdate();
            }
        }
    }

    private boolean hasCrabInTile() {
        TileEntityCrabPot tile = (TileEntityCrabPot)this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        return tile != null && (tile.hasSiltCrab() || tile.hasBubblerCrab());
    }

    public ItemStack getRecipeOutput(ItemStack input, boolean checkAnyIfNoCrabs, boolean checkAny) {
        TileEntityCrabPot tile = (TileEntityCrabPot)this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (checkAny || checkAnyIfNoCrabs && (tile == null || !tile.hasSiltCrab() && !tile.hasBubblerCrab())) {
            ItemStack output = ItemStack.field_190927_a;
            output = CrabPotFilterRecipeSilt.getRecipeOutput(input);
            if (!output.func_190926_b()) {
                return output;
            }
            output = CrabPotFilterRecipeBubbler.getRecipeOutput(input);
            if (!output.func_190926_b()) {
                return output;
            }
        } else if (tile != null) {
            if (tile.hasSiltCrab()) {
                return CrabPotFilterRecipeSilt.getRecipeOutput(input);
            }
            if (tile.hasBubblerCrab()) {
                return CrabPotFilterRecipeBubbler.getRecipeOutput(input);
            }
        }
        return ItemStack.field_190927_a;
    }

    private void setSlotProgress(int counter) {
        this.filteringProgress = counter;
    }

    public int getSlotProgress() {
        return this.filteringProgress;
    }

    public void consumeBait() {
        ItemStack baitStack = this.func_70301_a(0);
        this.setBaitProgress(0);
        this.markForUpdate();
        baitStack.func_190918_g(1);
    }

    private boolean canFilterSlots(int input, int output) {
        if (!this.active || !this.hasBait() || this.func_70301_a(input).func_190926_b() || !this.func_70301_a(output).func_190926_b() && this.func_70301_a(output).func_77973_b() != this.getRecipeOutput(this.func_70301_a(input), false, false).func_77973_b()) {
            return false;
        }
        ItemStack result = this.getRecipeOutput(this.func_70301_a(input), false, false);
        return !result.func_190926_b();
    }

    public boolean hasBait() {
        ItemStack baitStack = this.func_70301_a(0);
        if (!baitStack.func_190926_b()) {
            return true;
        }
        return this.getBaitProgress() > 0;
    }

    public void filterItem(int input, int output) {
        if (this.canFilterSlots(input, output)) {
            ItemStack itemstack = this.func_70301_a(input);
            ItemStack result = this.getRecipeOutput(itemstack, false, false);
            ItemStack itemstack2 = this.func_70301_a(output);
            if (!itemstack2.func_190926_b() && result.func_77973_b() == itemstack2.func_77973_b()) {
                itemstack2.func_190917_f(1);
                this.func_70299_a(output, itemstack2);
            }
            if (itemstack2.func_190926_b()) {
                this.func_70299_a(output, result.func_77946_l());
            }
            this.setSlotProgress(0);
            this.markForUpdate();
            if (this.getBaitProgress() > this.maxFilteringTime * this.itemsToFilterCount) {
                this.setBaitProgress(0);
                this.markForUpdate();
            }
            itemstack.func_190918_g(1);
        }
    }

    public void setBaitProgress(int duration) {
        this.baitProgress = duration;
    }

    public int getBaitProgress() {
        return this.baitProgress;
    }

    public int getBaitProgressScaled(int count) {
        return this.getBaitProgress() * count / (this.maxFilteringTime * this.itemsToFilterCount);
    }

    public int getFilteringProgressScaled(int count) {
        return this.getSlotProgress() * count / this.maxFilteringTime;
    }

    public float getFilteringAnimationScaled(int count, float partialTicks) {
        return ((float)this.prevFilteringAnimationTicks + (float)(this.filteringAnimationTicks - this.prevFilteringAnimationTicks) * partialTicks) * (float)count / (float)this.maxFilteringTime;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_72314_b(0.0, 1.0, 0.0);
    }

    public void markForUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 2);
    }

    public void setRotation(int horizontalIndexIn) {
        this.horizontalIndex = horizontalIndexIn;
    }

    public int getRotation() {
        return this.horizontalIndex;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.active = nbt.func_74767_n("active");
        this.baitProgress = nbt.func_74762_e("bait_progress");
        this.filteringProgress = nbt.func_74762_e("filtering_progress");
        this.setRotation(nbt.func_74762_e("horizontalIndex"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("bait_progress", this.baitProgress);
        nbt.func_74768_a("filtering_progress", this.filteringProgress);
        nbt.func_74768_a("horizontalIndex", this.getRotation());
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0 && ItemMisc.EnumItemMisc.ANADIA_REMAINS.isItemOf(stack)) {
            return true;
        }
        return slot == 1 && !this.getRecipeOutput(stack, true, false).func_190926_b();
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.resultSideSlot : this.allSideSlots;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return direction == EnumFacing.DOWN && slot == 2;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(slot, stack);
    }
}

