/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntriesProvider;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntry;
import thebetweenlands.common.entity.mobs.EntityBubblerCrab;
import thebetweenlands.common.entity.mobs.EntitySiltCrab;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.item.misc.ItemMob;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityBasicInventory;
import thebetweenlands.common.world.storage.location.TokenBucket;

public class TileEntityCrabPot
extends TileEntityBasicInventory
implements ITickable {
    public static final ResourceLocation CRAB_POT_SPAWNING_TOKEN_BUCKET_ID = new ResourceLocation("thebetweenlands", "crab_pot_spawning");
    private boolean active;
    public int fallCounter = 16;
    public int fallCounterPrev;
    private int horizontalIndex = 0;
    public int prevAnimationTicks;
    public int animationTicks;
    public boolean animate = false;
    private EntityPlayer placer;
    private UUID placerUUID;
    private int catchTimer;
    private int catchTimerMax;
    private TokenBucket tokenBucket = new TokenBucket(CRAB_POT_SPAWNING_TOKEN_BUCKET_ID, 64.0f, 48.0f, 64.0f, 1, 4, 0.99, 1.0);

    public TileEntityCrabPot() {
        super(1, "container.bl.crab_pot");
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.updatePlacerFromUUID();
        this.tokenBucket.setWorld(this.field_145850_b);
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        this.tokenBucket.setPos(posIn);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.fallCounterPrev = this.fallCounter;
            if (!this.hasBaitItem()) {
                if (this.fallCounter > 0) {
                    --this.fallCounter;
                }
                if (this.fallCounter <= 0) {
                    this.fallCounter = 0;
                }
            }
            if (this.hasBaitItem() && this.fallCounter != 32) {
                this.fallCounter = 32;
            }
            this.prevAnimationTicks = this.animationTicks++;
            if (this.animate) {
                // empty if block
            }
            if (!this.animate && this.animationTicks > 0) {
                this.animationTicks = 0;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.catchTimerMax == 0) {
                this.resetCatchTimer();
            }
            if (this.placerUUID != null && this.getPlacer() == null && this.field_145850_b.func_82737_E() % 20L == 0L && this.updatePlacerFromUUID()) {
                this.markForUpdate();
            }
            if (this.hasBaitItem() && !this.active) {
                this.active = true;
                this.func_70296_d();
            }
            if (!this.hasBaitItem() && this.active) {
                this.active = false;
                this.func_70296_d();
            }
            if (this.active && !(this.func_70301_a(0).func_77973_b() instanceof ItemMob)) {
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    ItemStack stack;
                    ItemMob itemMob;
                    EntitySiltCrab entity = null;
                    this.updateCatchTimer();
                    int remainingCatchTicks = this.getRemainingCatchTicks();
                    if (remainingCatchTicks <= 0 && this.field_145850_b.func_82736_K().func_82766_b("doMobSpawning") && this.field_145850_b.func_184137_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 32.0, false) == null && this.field_145850_b.func_175678_i(this.field_174879_c.func_177984_a())) {
                        int checks = 64;
                        int spawnableBlocks = 0;
                        HashMap<Biome, Boolean> spawnableBiomes = new HashMap<Biome, Boolean>();
                        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
                        for (int i = 0; i < checks; ++i) {
                            checkPos.func_181079_c(this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextInt(13) - 6, this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextInt(5) - 1, this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextInt(13) - 6);
                            if (this.field_145850_b.func_180495_p((BlockPos)checkPos).func_185904_a() != Material.field_151586_h || !this.field_145850_b.func_175678_i((BlockPos)checkPos)) continue;
                            Biome biome = this.field_145850_b.func_180494_b((BlockPos)checkPos);
                            if (spawnableBiomes.containsKey(biome)) {
                                if (!((Boolean)spawnableBiomes.get(biome)).booleanValue()) continue;
                                ++spawnableBlocks;
                                continue;
                            }
                            boolean biomeSpawnable = false;
                            if (biome instanceof ICustomSpawnEntriesProvider) {
                                for (ICustomSpawnEntry spawnEntry : ((ICustomSpawnEntriesProvider)biome).getCustomSpawnEntries()) {
                                    if (!EntitySiltCrab.class.isAssignableFrom(spawnEntry.getEntityType())) continue;
                                    biomeSpawnable = true;
                                    break;
                                }
                            }
                            spawnableBiomes.put(biome, biomeSpawnable);
                            if (!biomeSpawnable) continue;
                            ++spawnableBlocks;
                        }
                        float probability = Math.min(1.0f, (float)Math.pow((float)spawnableBlocks / (float)checks * 2.0f, 2.0) * 2.0f);
                        if (this.field_145850_b.field_73012_v.nextFloat() <= probability) {
                            entity = this.createRandomCatch(spawnableBiomes.entrySet().stream().filter(e -> (Boolean)e.getValue()).map(e -> (Biome)e.getKey()).collect(Collectors.toSet()));
                        }
                        this.resetCatchTimer();
                    }
                    if (entity == null) {
                        this.lureCloseCrab();
                        entity = this.checkCatch();
                    }
                    if (entity != null && (itemMob = entity.getCrabPotItem()) != null && !(stack = itemMob.capture((Entity)entity)).func_190926_b()) {
                        entity.func_184174_b(false);
                        entity.func_70106_y();
                        this.func_70299_a(0, stack);
                        EntityPlayer placer = this.getPlacer();
                        if (placer == null) {
                            this.updatePlacerFromUUID();
                            placer = this.getPlacer();
                        }
                        this.func_70296_d();
                        if ((this.hasSiltCrab() || this.hasBubblerCrab()) && placer instanceof EntityPlayerMP) {
                            AdvancementCriterionRegistry.CRAB_POT.trigger((EntityPlayerMP)placer);
                        }
                    }
                    super.func_70296_d();
                }
            } else {
                this.resetCatchTimer();
            }
            if (this.func_145831_w().func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() != BlockRegistry.CRAB_POT_FILTER && this.animate) {
                this.animate = false;
                this.markForUpdate();
            }
        }
    }

    public void resetCatchTimer() {
        this.catchTimerMax = 24000 + this.field_145850_b.field_73012_v.nextInt(36000);
        this.catchTimer = 0;
    }

    private void updateCatchTimer() {
        long increment = this.tokenBucket.consume();
        this.catchTimer = MathHelper.func_76125_a((int)(this.catchTimer + (int)increment), (int)0, (int)this.catchTimerMax);
    }

    public int getRemainingCatchTicks() {
        return MathHelper.func_76125_a((int)(this.catchTimerMax - this.catchTimer), (int)0, (int)this.catchTimerMax);
    }

    private boolean updatePlacerFromUUID() {
        EntityPlayer player;
        if (this.placerUUID != null && (player = this.field_145850_b.func_152378_a(this.placerUUID)) != null && player != this.getPlacer()) {
            this.setPlacer(player);
            return true;
        }
        return false;
    }

    @Nullable
    private EntitySiltCrab createRandomCatch(Set<Biome> biomes) {
        EntitySiltCrab crab = null;
        switch (this.field_145850_b.field_73012_v.nextInt(2)) {
            case 0: {
                crab = new EntitySiltCrab(this.field_145850_b);
                break;
            }
            case 1: {
                crab = new EntityBubblerCrab(this.field_145850_b);
            }
        }
        if (crab != null) {
            crab.randomizeSiltCrabProperties();
        }
        return crab;
    }

    @Nullable
    private EntitySiltCrab checkCatch() {
        List list = this.func_145831_w().func_175647_a(EntityLiving.class, new AxisAlignedBB(this.field_174879_c.func_177984_a()).func_72314_b(-0.25, 0.0, -0.25), e -> e instanceof EntitySiltCrab);
        if (!list.isEmpty()) {
            return (EntitySiltCrab)list.get(this.field_145850_b.field_73012_v.nextInt(list.size()));
        }
        return null;
    }

    public void lureCloseCrab() {
        List list = this.func_145831_w().func_175647_a(EntityLiving.class, this.extendRangeBox(), e -> e.func_70090_H() && e instanceof EntitySiltCrab);
        if (!list.isEmpty()) {
            ((EntitySiltCrab)list.get(this.field_145850_b.field_73012_v.nextInt(list.size()))).lureToCrabPot(this.field_174879_c);
        }
    }

    public AxisAlignedBB extendRangeBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72314_b(12.0, 5.0, 12.0);
    }

    public boolean hasBaitItem() {
        ItemStack baitItem = this.func_70301_a(0);
        return !baitItem.func_190926_b() && baitItem.func_77973_b() == ItemMisc.EnumItemMisc.ANADIA_REMAINS.getItem();
    }

    public boolean hasSiltCrab() {
        ItemStack crabItem = this.func_70301_a(0);
        return !crabItem.func_190926_b() && crabItem.func_77973_b() == ItemRegistry.SILT_CRAB;
    }

    public boolean hasBubblerCrab() {
        ItemStack crabItem = this.func_70301_a(0);
        return !crabItem.func_190926_b() && crabItem.func_77973_b() == ItemRegistry.BUBBLER_CRAB;
    }

    public void markForUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 2);
    }

    public Entity getEntity() {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemMob && ((ItemMob)stack.func_77973_b()).hasEntityData(stack)) {
            return ((ItemMob)stack.func_77973_b()).createCapturedEntity(this.field_145850_b, 0.0, 0.0, 0.0, stack, false);
        }
        return null;
    }

    public void setRotation(int horizontalIndexIn) {
        this.horizontalIndex = horizontalIndexIn;
    }

    public int getRotation() {
        return this.horizontalIndex;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.markForUpdate();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.active = nbt.func_74767_n("active");
        this.animate = nbt.func_74767_n("animate");
        this.setRotation(nbt.func_74762_e("horizontalIndex"));
        if (nbt.func_150297_b("OwnerUUID", 8)) {
            this.placerUUID = nbt.func_186857_a("OwnerUUID");
        }
        this.catchTimer = nbt.func_74762_e("catchTimer");
        this.catchTimerMax = nbt.func_74762_e("catchTimerMax");
        if (nbt.func_150297_b("tokenBucket", 10)) {
            this.tokenBucket = new TokenBucket(nbt.func_74775_l("tokenBucket"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("horizontalIndex", this.getRotation());
        nbt.func_74757_a("animate", this.animate);
        EntityPlayer placer = this.getPlacer();
        if (placer != null) {
            nbt.func_186854_a("OwnerUUID", placer.func_110124_au());
        }
        nbt.func_74768_a("catchTimer", this.catchTimer);
        nbt.func_74768_a("catchTimerMax", this.catchTimerMax);
        nbt.func_74782_a("tokenBucket", (NBTBase)this.tokenBucket.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    private EntityPlayer getPlacer() {
        return this.placer;
    }

    public void setPlacer(EntityPlayer player) {
        this.placer = player;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return side != EnumFacing.DOWN && slot == 0 && this.func_70301_a(slot).func_190926_b() && ItemMisc.EnumItemMisc.ANADIA_REMAINS.isItemOf(stack) && stack.func_190916_E() == 1;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return side == EnumFacing.DOWN && slot == 0 && !ItemMisc.EnumItemMisc.ANADIA_REMAINS.isItemOf(stack);
    }
}

