/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import net.minecraft.block.BlockFire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.block.structure.BlockBeamLensSupport;
import thebetweenlands.common.block.structure.BlockBeamOrigin;
import thebetweenlands.common.block.structure.BlockBeamRelay;
import thebetweenlands.common.block.structure.BlockBeamTube;
import thebetweenlands.common.block.structure.BlockDiagonalEnergyBarrier;
import thebetweenlands.common.block.structure.BlockEnergyBarrierMud;
import thebetweenlands.common.entity.mobs.EntityEmberlingShaman;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityBeamRelay;

public class TileEntityBeamOrigin
extends TileEntity
implements ITickable {
    public boolean active;
    public float prevVisibility = 0.0f;
    public float visibility = 0.0f;
    public float prevRotation = 0.7853982f;
    public float rotation = 0.7853982f;
    private int particleTimer = 0;
    public boolean beam_1_active = false;
    public boolean beam_2_active = false;
    public boolean beam_3_active = false;
    public boolean beam_4_active = false;

    public void func_73660_a() {
        int litBraziers = this.checkForLitBraziers();
        if (this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c() != null) {
            if (litBraziers == 4) {
                if (!this.active) {
                    this.setActive(true);
                    if (!this.field_145850_b.field_72995_K) {
                        this.spawnEmberling(this.func_145831_w(), this.func_174877_v().func_177982_a(3, -1, 3));
                        this.spawnEmberling(this.func_145831_w(), this.func_174877_v().func_177982_a(3, -1, -3));
                        this.spawnEmberling(this.func_145831_w(), this.func_174877_v().func_177982_a(-3, -1, 3));
                        this.spawnEmberling(this.func_145831_w(), this.func_174877_v().func_177982_a(-3, -1, -3));
                    }
                }
            } else if (this.active) {
                this.setActive(false);
            }
        }
        if (this.func_145831_w().func_82737_E() % 10L == 0L) {
            if (this.checkForLitBrazier(this.func_174877_v().func_177982_a(3, -1, 3))) {
                if (this.field_145850_b.field_72995_K) {
                    this.spawnBrazierParticles(new Vec3d(3.0, -1.0, 3.0));
                }
                if (!this.field_145850_b.field_72995_K && !this.beam_1_active) {
                    this.setBeam1Active(true);
                    this.func_145831_w().func_184133_a((EntityPlayer)null, this.func_174877_v().func_177982_a(3, -1, 3), (SoundEvent)SoundRegistry.PORTAL_ACTIVATE, SoundCategory.BLOCKS, 0.125f, 0.25f);
                }
            } else if (!this.field_145850_b.field_72995_K && this.beam_1_active) {
                this.setBeam1Active(false);
            }
            if (this.checkForLitBrazier(this.func_174877_v().func_177982_a(3, -1, -3))) {
                if (this.field_145850_b.field_72995_K) {
                    this.spawnBrazierParticles(new Vec3d(3.0, -1.0, -3.0));
                }
                if (!this.field_145850_b.field_72995_K && !this.beam_2_active) {
                    this.setBeam2Active(true);
                    this.func_145831_w().func_184133_a((EntityPlayer)null, this.func_174877_v().func_177982_a(3, -1, -3), (SoundEvent)SoundRegistry.PORTAL_ACTIVATE, SoundCategory.BLOCKS, 0.125f, 0.25f);
                }
            } else if (!this.field_145850_b.field_72995_K && this.beam_2_active) {
                this.setBeam2Active(false);
            }
            if (this.checkForLitBrazier(this.func_174877_v().func_177982_a(-3, -1, 3))) {
                if (this.field_145850_b.field_72995_K) {
                    this.spawnBrazierParticles(new Vec3d(-3.0, -1.0, 3.0));
                }
                if (!this.field_145850_b.field_72995_K && !this.beam_3_active) {
                    this.setBeam3Active(true);
                    this.func_145831_w().func_184133_a((EntityPlayer)null, this.func_174877_v().func_177982_a(-3, -1, 3), (SoundEvent)SoundRegistry.PORTAL_ACTIVATE, SoundCategory.BLOCKS, 0.125f, 0.25f);
                }
            } else if (!this.field_145850_b.field_72995_K && this.beam_3_active) {
                this.setBeam3Active(false);
            }
            if (this.checkForLitBrazier(this.func_174877_v().func_177982_a(-3, -1, -3))) {
                if (this.field_145850_b.field_72995_K) {
                    this.spawnBrazierParticles(new Vec3d(-3.0, -1.0, -3.0));
                }
                if (!this.field_145850_b.field_72995_K && !this.beam_4_active) {
                    this.setBeam4Active(true);
                    this.func_145831_w().func_184133_a((EntityPlayer)null, this.func_174877_v().func_177982_a(-3, -1, -3), (SoundEvent)SoundRegistry.PORTAL_ACTIVATE, SoundCategory.BLOCKS, 0.125f, 0.25f);
                }
            } else if (!this.field_145850_b.field_72995_K && this.beam_4_active) {
                this.setBeam4Active(false);
            }
        }
        this.prevVisibility = this.visibility;
        this.prevRotation = this.rotation;
        this.rotation += (float)litBraziers * 0.0025f;
        float targetVisibility = 0.2f + 0.8f * (float)litBraziers / 4.0f;
        if (this.visibility < targetVisibility) {
            this.visibility += 0.02f;
            if (this.visibility > targetVisibility) {
                this.visibility = targetVisibility;
            }
        } else if (this.visibility > targetVisibility) {
            this.visibility -= 0.02f;
            if (this.visibility < targetVisibility) {
                this.visibility = targetVisibility;
            }
        }
        if (this.active) {
            this.activateBlock();
        } else {
            this.deactivateBlock();
        }
    }

    private void spawnEmberling(World world, BlockPos pos) {
        EntityEmberlingShaman entity = new EntityEmberlingShaman(world);
        entity.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
        entity.func_180482_a(world.func_175649_E(pos), null);
        world.func_72838_d((Entity)entity);
    }

    public int checkForLitBraziers() {
        int braziers = 0;
        if (this.checkForLitBrazier(this.func_174877_v().func_177982_a(3, -1, 3))) {
            ++braziers;
        }
        if (this.checkForLitBrazier(this.func_174877_v().func_177982_a(3, -1, -3))) {
            ++braziers;
        }
        if (this.checkForLitBrazier(this.func_174877_v().func_177982_a(-3, -1, 3))) {
            ++braziers;
        }
        if (this.checkForLitBrazier(this.func_174877_v().func_177982_a(-3, -1, -3))) {
            ++braziers;
        }
        return braziers;
    }

    public boolean checkForLitBrazier(BlockPos targetPos) {
        IBlockState flame = this.func_145831_w().func_180495_p(targetPos);
        return flame.func_177230_c() instanceof BlockFire;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnBrazierParticles(Vec3d target) {
        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.BEAM, BLParticles.PUZZLE_BEAM_2.create(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + target.field_72450_a, (double)this.field_174879_c.func_177956_o() + 0.5 + target.field_72448_b, (double)this.field_174879_c.func_177952_p() + 0.5 + target.field_72449_c, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(0.0, 0.0, 0.0)).withColor(255.0f, 102.0f, 0.0f, 1.0f)).withScale(1.5f)).withData(30, target.func_186678_a(-1.0))));
        for (int i = 0; i < 2; ++i) {
            float offsetLen = this.field_145850_b.field_73012_v.nextFloat();
            Vec3d offset = new Vec3d(target.field_72450_a * (double)offsetLen + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.2f) - (double)0.1f, target.field_72448_b * (double)offsetLen + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.2f) - (double)0.1f, target.field_72449_c * (double)offsetLen + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.2f) - (double)0.1f);
            float vx = (this.field_145850_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.0025f;
            float vy = (this.field_145850_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.0025f + 0.008f;
            float vz = (this.field_145850_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.0025f;
            float scale = 0.5f + this.field_145850_b.field_73012_v.nextFloat();
            if (ShaderHelper.INSTANCE.canUseShaders() && this.field_145850_b.field_73012_v.nextBoolean()) {
                BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.HEAT_HAZE_BLOCK_ATLAS, BLParticles.SMOOTH_SMOKE.create(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + offset.field_72450_a, (double)this.field_174879_c.func_177956_o() + 0.5 + offset.field_72448_b, (double)this.field_174879_c.func_177952_p() + 0.5 + offset.field_72449_c, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(vx, vy, vz)).withColor(1.0f, 1.0f, 1.0f, 0.2f)).withScale(scale * 8.0f)).withData(80, true, Float.valueOf(0.0f), true)));
                continue;
            }
            BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.PUZZLE_BEAM.create(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + offset.field_72450_a, (double)this.field_174879_c.func_177956_o() + 0.5 + offset.field_72448_b, (double)this.field_174879_c.func_177952_p() + 0.5 + offset.field_72449_c, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(vx, vy, vz)).withColor(255.0f, 102.0f, 0.0f, 1.0f)).withScale(scale)).withData(100)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnBeamParticles(Vec3d target) {
        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.BEAM, BLParticles.PUZZLE_BEAM_2.create(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(0.0, 0.0, 0.0)).withColor(40.0f, 220.0f, 130.0f, 1.0f)).withScale(2.5f)).withData(30, target)));
        for (int i = 0; i < 3; ++i) {
            float offsetLen = this.field_145850_b.field_73012_v.nextFloat();
            Vec3d offset = new Vec3d(target.field_72450_a * (double)offsetLen + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.2f) - (double)0.1f, target.field_72448_b * (double)offsetLen + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.2f) - (double)0.1f, target.field_72449_c * (double)offsetLen + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.2f) - (double)0.1f);
            float vx = (this.field_145850_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.0025f;
            float vy = (this.field_145850_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.0025f + 0.008f;
            float vz = (this.field_145850_b.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.0025f;
            float scale = 0.5f + this.field_145850_b.field_73012_v.nextFloat();
            if (ShaderHelper.INSTANCE.canUseShaders() && this.field_145850_b.field_73012_v.nextBoolean()) {
                BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.HEAT_HAZE_BLOCK_ATLAS, BLParticles.SMOOTH_SMOKE.create(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + offset.field_72450_a, (double)this.field_174879_c.func_177956_o() + 0.5 + offset.field_72448_b, (double)this.field_174879_c.func_177952_p() + 0.5 + offset.field_72449_c, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(vx, vy, vz)).withColor(1.0f, 1.0f, 1.0f, 0.2f)).withScale(scale * 8.0f)).withData(80, true, Float.valueOf(0.0f), true)));
                continue;
            }
            BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.PUZZLE_BEAM.create(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + offset.field_72450_a, (double)this.field_174879_c.func_177956_o() + 0.5 + offset.field_72448_b, (double)this.field_174879_c.func_177952_p() + 0.5 + offset.field_72449_c, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(vx, vy, vz)).withColor(40.0f, 220.0f, 130.0f, 1.0f)).withScale(scale)).withData(100)));
        }
    }

    public void activateBlock() {
        IBlockState state;
        if (!this.field_145850_b.field_72995_K && !((Boolean)(state = this.func_145831_w().func_180495_p(this.func_174877_v())).func_177229_b((IProperty)BlockBeamOrigin.POWERED)).booleanValue()) {
            this.func_145831_w().func_175656_a(this.func_174877_v(), BlockRegistry.MUD_TOWER_BEAM_ORIGIN.func_176223_P().func_177226_a((IProperty)BlockBeamOrigin.POWERED, (Comparable)Boolean.valueOf(true)));
            this.func_145831_w().func_184133_a((EntityPlayer)null, this.func_174877_v(), (SoundEvent)SoundRegistry.BEAM_ACTIVATE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        EnumFacing facing = EnumFacing.DOWN;
        BlockPos targetPos = this.func_174877_v().func_177967_a(facing, this.getDistanceToObstruction(facing));
        if (this.field_145850_b.field_72995_K) {
            if (this.particleTimer++ >= 20) {
                this.particleTimer = 0;
                this.spawnBeamParticles(new Vec3d((double)(targetPos.func_177958_n() - this.field_174879_c.func_177958_n()), (double)(targetPos.func_177956_o() - this.field_174879_c.func_177956_o()), (double)(targetPos.func_177952_p() - this.field_174879_c.func_177952_p())));
            }
        } else {
            IBlockState stateofTarget = this.func_145831_w().func_180495_p(targetPos);
            if (stateofTarget.func_177230_c() instanceof BlockBeamRelay && this.func_145831_w().func_175625_s(targetPos) instanceof TileEntityBeamRelay) {
                TileEntityBeamRelay targetTile = (TileEntityBeamRelay)this.func_145831_w().func_175625_s(targetPos);
                targetTile.setTargetIncomingBeam(facing.func_176734_d(), true);
                if (!((Boolean)this.func_145831_w().func_180495_p(targetPos).func_177229_b((IProperty)BlockBeamRelay.POWERED)).booleanValue()) {
                    stateofTarget = stateofTarget.func_177231_a((IProperty)BlockBeamRelay.POWERED);
                    this.func_145831_w().func_180501_a(targetPos, stateofTarget, 3);
                }
            }
        }
    }

    public void deactivateBlock() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (((Boolean)state.func_177229_b((IProperty)BlockBeamOrigin.POWERED)).booleanValue()) {
            this.func_145831_w().func_175656_a(this.func_174877_v(), BlockRegistry.MUD_TOWER_BEAM_ORIGIN.func_176223_P().func_177226_a((IProperty)BlockBeamOrigin.POWERED, (Comparable)Boolean.valueOf(false)));
            EnumFacing facing = EnumFacing.DOWN;
            BlockPos targetPos = this.func_174877_v().func_177967_a(facing, this.getDistanceToObstruction(facing));
            IBlockState stateofTarget = this.func_145831_w().func_180495_p(targetPos);
            if (stateofTarget.func_177230_c() instanceof BlockBeamRelay && this.func_145831_w().func_175625_s(targetPos) instanceof TileEntityBeamRelay) {
                TileEntityBeamRelay targetTile = (TileEntityBeamRelay)this.func_145831_w().func_175625_s(targetPos);
                targetTile.setTargetIncomingBeam(facing.func_176734_d(), false);
                if (!targetTile.isGettingBeamed() && ((Boolean)this.func_145831_w().func_180495_p(targetPos).func_177229_b((IProperty)BlockBeamRelay.POWERED)).booleanValue()) {
                    stateofTarget = stateofTarget.func_177231_a((IProperty)BlockBeamRelay.POWERED);
                    this.func_145831_w().func_180501_a(targetPos, stateofTarget, 3);
                }
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public void setBeam1Active(boolean isActive) {
        this.beam_1_active = isActive;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public void setBeam2Active(boolean isActive) {
        this.beam_2_active = isActive;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public void setBeam3Active(boolean isActive) {
        this.beam_3_active = isActive;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public void setBeam4Active(boolean isActive) {
        this.beam_4_active = isActive;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public int getDistanceToObstruction(EnumFacing facing) {
        IBlockState state;
        int distance = 0;
        for (distance = 1; distance < 14 && ((state = this.func_145831_w().func_180495_p(this.func_174877_v().func_177967_a(facing, distance))) == Blocks.field_150350_a.func_176223_P() || state.func_177230_c() instanceof BlockDiagonalEnergyBarrier || state.func_177230_c() instanceof BlockEnergyBarrierMud || state.func_177230_c() instanceof BlockBeamLensSupport || this.isValidBeamTubeLens(state, facing)); ++distance) {
        }
        return distance;
    }

    private boolean isValidBeamTubeLens(IBlockState state, EnumFacing facing) {
        if (!(state.func_177230_c() instanceof BlockBeamTube)) {
            return false;
        }
        if (state.func_177229_b((IProperty)BlockBeamTube.field_176387_N) == facing) {
            return true;
        }
        return state.func_177229_b((IProperty)BlockBeamTube.field_176387_N) == facing.func_176734_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("active", this.active);
        nbt.func_74757_a("beam_1_active", this.beam_1_active);
        nbt.func_74757_a("beam_2_active", this.beam_2_active);
        nbt.func_74757_a("beam_3_active", this.beam_3_active);
        nbt.func_74757_a("beam_4_active", this.beam_4_active);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.active = nbt.func_74767_n("active");
        this.beam_1_active = nbt.func_74767_n("beam_1_active");
        this.beam_2_active = nbt.func_74767_n("beam_2_active");
        this.beam_3_active = nbt.func_74767_n("beam_3_active");
        this.beam_4_active = nbt.func_74767_n("beam_4_active");
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_186662_g(10.0);
    }
}

