/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import thebetweenlands.common.block.container.BlockBarrel;

public class TileEntityBarrel
extends TileEntity
implements IFluidHandler {
    private final FluidTank fluidTank;
    private final IFluidTankProperties[] properties = new IFluidTankProperties[1];

    public TileEntityBarrel() {
        this.fluidTank = new FluidTank(null, 8000);
        this.fluidTank.setTileEntity((TileEntity)this);
        this.properties[0] = new FluidTankPropertiesWrapper(this.fluidTank);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fluidTank.readFromNBT(nbt.func_74775_l("fluidTank"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.fluidTank.readFromNBT(packet.func_148857_g().func_74775_l("fluidTank"));
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        super.handleUpdateTag(nbt);
        this.fluidTank.readFromNBT(nbt.func_74775_l("fluidTank"));
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.field_145850_b != null) {
            boolean isFluidHot;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            boolean bl = isFluidHot = (float)resource.getFluid().getTemperature(resource) > 473.15f || resource.getFluid() == FluidRegistry.LAVA;
            if (!isFluidHot || state.func_177230_c() instanceof BlockBarrel && ((BlockBarrel)state.func_177230_c()).isHeatResistant(this.field_145850_b, this.field_174879_c, state)) {
                int filled = this.fluidTank.fill(resource, doFill);
                if (filled != 0 && doFill) {
                    this.func_70296_d();
                    IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 2);
                }
                return filled;
            }
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (doDrain) {
            this.func_70296_d();
            IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 2);
        }
        return this.fluidTank.drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (doDrain) {
            this.func_70296_d();
            IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 2);
        }
        return this.fluidTank.drain(maxDrain, doDrain);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

