/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.registries;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.properties.EntityProperty;
import net.minecraft.world.storage.loot.properties.EntityPropertyManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.loot.EntityPropertyAnadiaBodyType;
import thebetweenlands.common.loot.EntityPropertyAnadiaHeadType;
import thebetweenlands.common.loot.EntityPropertyAnadiaTailType;
import thebetweenlands.common.loot.EntityPropertyEventActive;
import thebetweenlands.common.loot.EntityPropertyFrogType;
import thebetweenlands.common.loot.EntityPropertyHasItem;
import thebetweenlands.common.loot.EntityPropertyIsBossPeatMummy;
import thebetweenlands.common.loot.EntityPropertyLootModifier;
import thebetweenlands.common.loot.EntityPropertyPeatMummyShimmerstone;
import thebetweenlands.common.loot.EntityPropertyPyradCharging;
import thebetweenlands.common.loot.EntityPropertyRockSnotType;
import thebetweenlands.common.loot.EntityPropertySludgeWormSquashed;
import thebetweenlands.common.loot.LootConditionEventActive;
import thebetweenlands.common.loot.LootConditionFromSharedPool;
import thebetweenlands.common.loot.LootConditionKilledLootModifier;
import thebetweenlands.common.loot.LootConditionOr;
import thebetweenlands.common.loot.LootConditionSharedPool;
import thebetweenlands.common.loot.LootFunctionSetAnadiaProperties;
import thebetweenlands.common.loot.LootFunctionSetCountFromAnadia;
import thebetweenlands.common.loot.LootFunctionSetMetaFromArray;
import thebetweenlands.util.FakeClientWorld;

public class LootTableRegistry {
    public static final ResourceLocation MUSIC_DISC = LootTableRegistry.register("loot/music_disc");
    public static final ResourceLocation SCROLL = LootTableRegistry.register("animator/scroll");
    public static final ResourceLocation FABRICATED_SCROLL = LootTableRegistry.register("animator/fabricated_scroll");
    public static final ResourceLocation PRESENT = LootTableRegistry.register("loot/present_loot");
    public static final ResourceLocation PUFFSHROOM = LootTableRegistry.register("loot/puffshroom");
    public static final ResourceLocation LAKE_CAVERN_SIMULACRUM_OFFERINGS = LootTableRegistry.register("loot/lake_cavern_simulacrum_offerings");
    public static final ResourceLocation DEEPMAN_SIMULACRUM_OFFERINGS = LootTableRegistry.register("loot/deepman_simulacrum_offerings");
    public static final ResourceLocation ROOTMAN_SIMULACRUM_OFFERINGS = LootTableRegistry.register("loot/rootman_simulacrum_offerings");
    public static final ResourceLocation SHARED_LOOT_POOL_TEST = LootTableRegistry.register("loot/shared_loot_pool_test");
    @Deprecated
    public static final ResourceLocation COMMON_POT_LOOT = LootTableRegistry.register("loot/common_pot_loot");
    @Deprecated
    public static final ResourceLocation DUNGEON_CHEST_LOOT = LootTableRegistry.register("loot/dungeon_chest_loot");
    @Deprecated
    public static final ResourceLocation COMMON_CHEST_LOOT = LootTableRegistry.register("loot/common_chest_loot");
    @Deprecated
    public static final ResourceLocation DUNGEON_POT_LOOT = LootTableRegistry.register("loot/dungeon_pot_loot");
    public static final ResourceLocation CAVE_POT = LootTableRegistry.register("loot/cave_pot");
    public static final ResourceLocation SLUDGE_PLAINS_RUINS_URN = LootTableRegistry.register("loot/sludge_plains_ruins_urn");
    public static final ResourceLocation MARSH_RUINS_POT = LootTableRegistry.register("loot/marsh_ruins_pot");
    public static final ResourceLocation SPAWNER_CHEST = LootTableRegistry.register("loot/spawner_chest");
    public static final ResourceLocation IDOL_HEADS_CHEST = LootTableRegistry.register("loot/idol_heads_chest");
    public static final ResourceLocation TAR_POOL_POT = LootTableRegistry.register("loot/tar_pool_pot");
    public static final ResourceLocation UNDERGROUND_RUINS_POT = LootTableRegistry.register("loot/underground_ruins_pot");
    public static final ResourceLocation UNDERWATER_RUINS_POT = LootTableRegistry.register("loot/underwater_ruins_pot");
    public static final ResourceLocation SLUDGE_WORM_DUNGEON_CHEST = LootTableRegistry.register("loot/sludge_worm_dungeon_chest");
    public static final ResourceLocation SLUDGE_WORM_DUNGEON_URN = LootTableRegistry.register("loot/sludge_worm_dungeon_urn");
    public static final ResourceLocation SLUDGE_WORM_DUNGEON_BARRISHEE_CHEST = LootTableRegistry.register("loot/sludge_worm_dungeon_barrishee_chest");
    public static final ResourceLocation SLUDGE_WORM_DUNGEON_CRYPT_URN = LootTableRegistry.register("loot/sludge_worm_dungeon_crypt_urn");
    public static final ResourceLocation SLUDGE_WORM_DUNGEON_ITEM_SHELF = LootTableRegistry.register("loot/sludge_worm_dungeon_item_shelf");
    public static final ResourceLocation CRAGROCK_TOWER_CHEST = LootTableRegistry.register("loot/cragrock_tower_chest");
    public static final ResourceLocation CRAGROCK_TOWER_POT = LootTableRegistry.register("loot/cragrock_tower_pot");
    public static final ResourceLocation WIGHT_FORTRESS_CHEST = LootTableRegistry.register("loot/wight_fortress_chest");
    public static final ResourceLocation WIGHT_FORTRESS_POT = LootTableRegistry.register("loot/wight_fortress_pot");
    public static final ResourceLocation CHIROMAW_NEST_SCATTERED_LOOT = LootTableRegistry.register("loot/chiromaw_nest_scattered_loot");
    public static final ResourceLocation ANGLER = LootTableRegistry.register("entities/angler");
    public static final ResourceLocation OLM = LootTableRegistry.register("entities/olm");
    public static final ResourceLocation BLOOD_SNAIL = LootTableRegistry.register("entities/blood_snail");
    public static final ResourceLocation CHIROMAW = LootTableRegistry.register("entities/chiromaw");
    public static final ResourceLocation DARK_DRUID = LootTableRegistry.register("entities/dark_druid");
    public static final ResourceLocation DRAGONFLY = LootTableRegistry.register("entities/dragonfly");
    public static final ResourceLocation FIREFLY = LootTableRegistry.register("entities/firefly");
    public static final ResourceLocation FROG = LootTableRegistry.register("entities/frog");
    public static final ResourceLocation GAS_CLOUD = LootTableRegistry.register("entities/gas_cloud");
    public static final ResourceLocation GECKO = LootTableRegistry.register("entities/gecko");
    public static final ResourceLocation LEECH = LootTableRegistry.register("entities/leech");
    public static final ResourceLocation LURKER = LootTableRegistry.register("entities/lurker");
    public static final ResourceLocation MIRE_SNAIL_EGG = LootTableRegistry.register("entities/mire_snail_egg");
    public static final ResourceLocation MIRE_SNAIL = LootTableRegistry.register("entities/mire_snail");
    public static final ResourceLocation PEAT_MUMMY = LootTableRegistry.register("entities/peat_mummy");
    public static final ResourceLocation PYRAD = LootTableRegistry.register("entities/pyrad");
    public static final ResourceLocation SILT_CRAB = LootTableRegistry.register("entities/silt_crab");
    public static final ResourceLocation SLUDGE = LootTableRegistry.register("entities/sludge");
    public static final ResourceLocation SPORELING = LootTableRegistry.register("entities/sporeling");
    public static final ResourceLocation SWAMP_HAG = LootTableRegistry.register("entities/swamp_hag");
    public static final ResourceLocation TAR_BEAST = LootTableRegistry.register("entities/tar_beast");
    public static final ResourceLocation TARMINION = LootTableRegistry.register("entities/tarminion");
    public static final ResourceLocation TERMITE = LootTableRegistry.register("entities/termite");
    public static final ResourceLocation TOAD = LootTableRegistry.register("entities/toad");
    public static final ResourceLocation WIGHT = LootTableRegistry.register("entities/wight");
    public static final ResourceLocation SPIRIT_TREE_FACE_SMALL = LootTableRegistry.register("entities/spirit_tree_face_small");
    public static final ResourceLocation SPIRIT_TREE_FACE_LARGE = LootTableRegistry.register("entities/spirit_tree_face_large");
    public static final ResourceLocation BOULDER_SPRITE = LootTableRegistry.register("entities/boulder_sprite");
    public static final ResourceLocation ROOT_SPRITE = LootTableRegistry.register("entities/root_sprite");
    public static final ResourceLocation WALL_LAMPREY = LootTableRegistry.register("entities/wall_lamprey");
    public static final ResourceLocation WALL_LIVING_ROOT = LootTableRegistry.register("entities/wall_living_root");
    public static final ResourceLocation MOVING_SPAWNER_HOLE = LootTableRegistry.register("entities/moving_spawner_hole");
    public static final ResourceLocation TINY_SLUDGE_WORM_HELPER = LootTableRegistry.register("entities/tiny_sludge_worm_helper");
    public static final ResourceLocation TINY_SLUDGE_WORM = LootTableRegistry.register("entities/tiny_sludge_worm");
    public static final ResourceLocation SMALL_SLUDGE_WORM = LootTableRegistry.register("entities/small_sludge_worm");
    public static final ResourceLocation LARGE_SLUDGE_WORM = LootTableRegistry.register("entities/large_sludge_worm");
    public static final ResourceLocation SHAMBLER = LootTableRegistry.register("entities/shambler");
    public static final ResourceLocation ASH_SPRITE = LootTableRegistry.register("entities/ash_sprite");
    public static final ResourceLocation BARRISHEE = LootTableRegistry.register("entities/barrishee");
    public static final ResourceLocation CRYPT_CRAWLER = LootTableRegistry.register("entities/crypt_crawler");
    public static final ResourceLocation EMBERLING = LootTableRegistry.register("entities/emberling");
    public static final ResourceLocation EMBERLING_SHAMAN = LootTableRegistry.register("entities/emberling_shaman");
    public static final ResourceLocation GREEBLING_CORPSE = LootTableRegistry.register("entities/greebling_corpse");
    public static final ResourceLocation CHIROMAW_MATRIARCH = LootTableRegistry.register("entities/chiromaw_matriarch");
    public static final ResourceLocation ANADIA = LootTableRegistry.register("entities/anadia");
    public static final ResourceLocation ANADIA_HEAD = LootTableRegistry.register("entities/anadia_head");
    public static final ResourceLocation ANADIA_BODY = LootTableRegistry.register("entities/anadia_body");
    public static final ResourceLocation ANADIA_TAIL = LootTableRegistry.register("entities/anadia_tail");
    public static final ResourceLocation ANADIA_TREASURE = LootTableRegistry.register("entities/anadia_treasure");
    public static final ResourceLocation ROCK_SNOT = LootTableRegistry.register("entities/rock_snot");
    public static final ResourceLocation FRESHWATER_URCHIN = LootTableRegistry.register("entities/freshwater_urchin");
    public static final ResourceLocation JELLYFISH = LootTableRegistry.register("entities/jellyfish");
    public static final ResourceLocation GREEBLING_CORACLE = LootTableRegistry.register("entities/greebling_coracle");
    public static final ResourceLocation SILT_CRAB_TRIM_1 = LootTableRegistry.register("entities/silt_crab_trim_1");
    public static final ResourceLocation SILT_CRAB_TRIM_2 = LootTableRegistry.register("entities/silt_crab_trim_2");
    public static final ResourceLocation SILT_CRAB_TRIM_3 = LootTableRegistry.register("entities/silt_crab_trim_3");
    public static final ResourceLocation BUBBLER_CRAB_TRIM_1 = LootTableRegistry.register("entities/bubbler_crab_trim_1");
    public static final ResourceLocation BUBBLER_CRAB_TRIM_2 = LootTableRegistry.register("entities/bubbler_crab_trim_2");
    public static final ResourceLocation BUBBLER_CRAB_TRIM_3 = LootTableRegistry.register("entities/bubbler_crab_trim_3");
    public static final ResourceLocation CHIROMAW_HATCHLING = LootTableRegistry.register("entities/chiromaw_hatchling");
    public static final ResourceLocation FORTRESS_BOSS = LootTableRegistry.register("entities/fortress_boss");
    public static final ResourceLocation DREADFUL_PEAT_MUMMY = LootTableRegistry.register("entities/dreadful_peat_mummy");
    public static final ResourceLocation SLUDGE_MENACE = LootTableRegistry.register("entities/sludge_menace");
    public static final ResourceLocation ENTITY_PROPERTY_FROG_TYPE = LootTableRegistry.register(new EntityPropertyFrogType.Serializer());
    public static final ResourceLocation ENTITY_PROPERTY_PEAT_MUMMY_SHIMMERSTONE = LootTableRegistry.register(new EntityPropertyPeatMummyShimmerstone.Serializer());
    public static final ResourceLocation ENTITY_PROPERTY_PYRAD_CHARGING = LootTableRegistry.register(new EntityPropertyPyradCharging.Serializer());
    public static final ResourceLocation ENTITY_PROPERTY_HAS_ITEM = LootTableRegistry.register(new EntityPropertyHasItem.Serializer());
    public static final ResourceLocation ENTITY_PROPERTY_IS_BOSS_MUMMY = LootTableRegistry.register(new EntityPropertyIsBossPeatMummy.Serializer());
    public static final ResourceLocation ENTITY_PROPERTY_IS_EVENT_ACTIVE = LootTableRegistry.register(new EntityPropertyEventActive.Serializer());
    public static final ResourceLocation ENTITY_PROPERTY_LOOT_MODIFIER = LootTableRegistry.register(new EntityPropertyLootModifier.Serializer());
    public static final ResourceLocation ENTITY_PROPERTY_SLUDGE_WORM_SQUASHED = LootTableRegistry.register(new EntityPropertySludgeWormSquashed.Serializer());
    public static final ResourceLocation ENTITY_PROPERTY_ANADIA_HEAD_TYPE = LootTableRegistry.register(new EntityPropertyAnadiaHeadType.Serializer());
    public static final ResourceLocation ENTITY_PROPERTY_ANADIA_BODY_TYPE = LootTableRegistry.register(new EntityPropertyAnadiaBodyType.Serializer());
    public static final ResourceLocation ENTITY_PROPERTY_ANADIA_TAIL_TYPE = LootTableRegistry.register(new EntityPropertyAnadiaTailType.Serializer());
    public static final ResourceLocation ENTITY_ROCK_SNOT_TYPE = LootTableRegistry.register(new EntityPropertyRockSnotType.Serializer());
    public static final ResourceLocation LOOT_CONDITION_OR = LootTableRegistry.register(new LootConditionOr.Serializer());
    public static final ResourceLocation LOOT_CONDITION_EVENT_ACTIVE = LootTableRegistry.register(new LootConditionEventActive.Serializer());
    public static final ResourceLocation LOOT_CONDITION_ENTITY_LOOT_MODIFIER = LootTableRegistry.register(new LootConditionKilledLootModifier.Serializer());
    public static final ResourceLocation LOOT_CONDITION_SHARED_POOL = LootTableRegistry.register(new LootConditionSharedPool.Serializer());
    public static final ResourceLocation LOOT_CONDITION_FROM_SHARED_POOL = LootTableRegistry.register(new LootConditionFromSharedPool.Serializer());
    public static final ResourceLocation LOOT_FUNCTION_SET_META_FROM_ARRAY = LootTableRegistry.register(new LootFunctionSetMetaFromArray.Serializer());
    public static final ResourceLocation LOOT_FUNCTION_SET_COUNT_FROM_ANADIA = LootTableRegistry.register(new LootFunctionSetCountFromAnadia.Serializer());
    public static final ResourceLocation LOOT_FUNCTION_SET_ANADIA_PROPERTIES = LootTableRegistry.register(new LootFunctionSetAnadiaProperties.Serializer());
    private static LootTableManager manager;

    public static void preInit() {
        if (BetweenlandsConfig.DEBUG.debug) {
            TheBetweenlands.logger.info("Loaded loot tables");
        }
    }

    private static ResourceLocation register(String id) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("thebetweenlands", id));
    }

    private static ResourceLocation register(EntityProperty.Serializer<?> serializer) {
        EntityPropertyManager.func_186644_a(serializer);
        return serializer.func_186649_a();
    }

    private static ResourceLocation register(LootCondition.Serializer<?> serializer) {
        LootConditionManager.func_186639_a(serializer);
        return serializer.func_186602_a();
    }

    private static ResourceLocation register(LootFunction.Serializer<?> serializer) {
        LootFunctionManager.func_186582_a(serializer);
        return serializer.func_186529_a();
    }

    public static ArrayList<ItemStack> getItemsFromTable(ResourceLocation lootTable, World world, boolean getCountSpan) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        LootTableManager manager = LootTableRegistry.getManager(world);
        LootTable table = manager.func_186521_a(lootTable);
        LootContext lootContext = new LootContext(0.0f, null, manager, null, null, null);
        Field f = ReflectionHelper.findField(LootTable.class, (String[])new String[]{"pools", "field_186466_c", "c"});
        List pools = null;
        try {
            pools = (List)f.get(table);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (pools != null && pools.size() > 0) {
            for (LootPool pool : pools) {
                Field f2 = ReflectionHelper.findField(LootPool.class, (String[])new String[]{"lootEntries", "field_186453_a", "a"});
                List entries = null;
                try {
                    entries = (List)f2.get(pool);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (entries == null || entries.size() <= 0) continue;
                for (LootEntry entry : entries) {
                    ResourceLocation location;
                    if (entry instanceof LootEntryItem) {
                        LootFunction[] functions = ((LootEntryItem)entry).field_186369_b;
                        ArrayList tmpItems = new ArrayList();
                        entry.func_186363_a(tmpItems, new Random(), lootContext);
                        if (getCountSpan && functions != null && functions.length > 0) {
                            for (LootFunction function : functions) {
                                RandomValueRange valueRange;
                                if (!(function instanceof SetCount) || (valueRange = ((SetCount)function).field_186568_a) == null) continue;
                                if (!((ItemStack)tmpItems.get(0)).func_77942_o()) {
                                    ((ItemStack)tmpItems.get(0)).func_77982_d(new NBTTagCompound());
                                }
                                NBTTagCompound compound = ((ItemStack)tmpItems.get(0)).func_77978_p();
                                compound.func_74776_a("LootCountMin", valueRange.func_186509_a());
                                compound.func_74776_a("LootCountMax", valueRange.func_186512_b());
                                break;
                            }
                        }
                        items.addAll(tmpItems);
                        continue;
                    }
                    if (!(entry instanceof LootEntryTable) || (location = ((LootEntryTable)entry).field_186371_a) == null) continue;
                    items.addAll(LootTableRegistry.getItemsFromTable(location, world, getCountSpan));
                }
            }
        }
        return items;
    }

    public static LootTableManager getManager(@Nullable World world) {
        if (world == null || world.func_184146_ak() == null) {
            if (manager == null) {
                FakeClientWorld.FakeSaveHandler saveHandler = FakeClientWorld.saveHandler;
                manager = new LootTableManager(new File(new File(saveHandler.func_75765_b(), "data"), "loot_tables"));
            }
            return manager;
        }
        return world.func_184146_ak();
    }
}

