/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.misc;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thebetweenlands.api.item.ICorrodible;
import thebetweenlands.common.registries.ItemRegistry;

public class RecipeSapSpitCleanTool
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean func_77569_a(InventoryCrafting crafter, World world) {
        int sap = 0;
        ItemStack tool = ItemStack.field_190927_a;
        for (int i = 0; i < crafter.func_70302_i_(); ++i) {
            ItemStack stack = crafter.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ICorrodible) {
                if (!tool.func_190926_b()) {
                    return false;
                }
                if (((ICorrodible)stack.func_77973_b()).getCorrosion(stack) == 0) {
                    return false;
                }
                tool = stack;
                continue;
            }
            if (stack.func_77973_b() == ItemRegistry.SAP_SPIT) {
                ++sap;
                continue;
            }
            return false;
        }
        return sap > 0 && !tool.func_190926_b();
    }

    public ItemStack func_77572_b(InventoryCrafting crafter) {
        int sap = 0;
        ItemStack tool = ItemStack.field_190927_a;
        for (int i = 0; i < crafter.func_70302_i_(); ++i) {
            ItemStack stack = crafter.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ICorrodible) {
                tool = stack;
                continue;
            }
            if (stack.func_77973_b() != ItemRegistry.SAP_SPIT) continue;
            ++sap;
        }
        tool = tool.func_77946_l();
        ICorrodible corrodible = (ICorrodible)tool.func_77973_b();
        corrodible.setCorrosion(tool, Math.max(0, corrodible.getCorrosion(tool) - MathHelper.func_76123_f((float)((float)(sap * corrodible.getMaxCorrosion(tool)) / 3.0f))));
        return tool;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        ItemStack stack;
        int i;
        NonNullList remaining = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        int requiredSap = 0;
        for (i = 0; i < remaining.size(); ++i) {
            stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICorrodible)) continue;
            ICorrodible corrodible = (ICorrodible)stack.func_77973_b();
            requiredSap += MathHelper.func_76123_f((float)((float)corrodible.getCorrosion(stack) / ((float)corrodible.getMaxCorrosion(stack) / 3.0f)));
        }
        for (i = 0; i < remaining.size(); ++i) {
            stack = inv.func_70301_a(i);
            if (!stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.SAP_SPIT) {
                if (requiredSap > 0) {
                    --requiredSap;
                    continue;
                }
                remaining.set(i, (Object)stack.func_77946_l());
                ((ItemStack)remaining.get(i)).func_190920_e(1);
                continue;
            }
            remaining.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        return remaining;
    }
}

