/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.misc;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thebetweenlands.common.block.terrain.BlockHearthgroveLog;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;

public class HearthgroveTarringRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        boolean tar = false;
        int hearthgroveLogs = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == Item.func_150898_a((Block)BlockRegistry.LOG_HEARTHGROVE)) {
                IBlockState state = BlockRegistry.LOG_HEARTHGROVE.func_176203_a(stack.func_77960_j());
                if (!((Boolean)state.func_177229_b((IProperty)BlockHearthgroveLog.TARRED)).booleanValue()) {
                    ++hearthgroveLogs;
                    continue;
                }
                return false;
            }
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                if (tar) {
                    return false;
                }
                IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                FluidStack drained = cap.drain(new FluidStack(FluidRegistry.TAR, 1000), false);
                if (drained != null && drained.amount == 1000) {
                    tar = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return tar && hearthgroveLogs > 0 && hearthgroveLogs <= 8;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        int tarredLogs = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != Item.func_150898_a((Block)BlockRegistry.LOG_HEARTHGROVE)) continue;
            ++tarredLogs;
        }
        return new ItemStack(BlockRegistry.LOG_HEARTHGROVE, tarredLogs, BlockRegistry.LOG_HEARTHGROVE.func_176201_c(BlockRegistry.LOG_HEARTHGROVE.func_176223_P().func_177226_a((IProperty)BlockHearthgroveLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)BlockHearthgroveLog.TARRED, (Comparable)Boolean.valueOf(true))));
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (cap == null || !stack.func_77973_b().hasContainerItem(stack)) continue;
            cap.drain(new FluidStack(FluidRegistry.TAR, 1000), true);
            ret.set(i, (Object)cap.getContainer());
        }
        return ret;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }
}

