/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thebetweenlands.api.recipes.ICrabPotFilterRecipeBubbler;

public class CrabPotFilterRecipeBubbler
implements ICrabPotFilterRecipeBubbler {
    public static final List<ICrabPotFilterRecipeBubbler> RECIPES = new ArrayList<ICrabPotFilterRecipeBubbler>();
    private ItemStack input;
    private ItemStack output;

    public CrabPotFilterRecipeBubbler(ItemStack output, ItemStack input) {
        this.output = output;
        this.input = input;
    }

    public CrabPotFilterRecipeBubbler(Item output, Item input) {
        this.output = new ItemStack(output, Short.MAX_VALUE);
        this.input = new ItemStack(input, Short.MAX_VALUE);
    }

    public static void addRecipe(ICrabPotFilterRecipeBubbler recipe) {
        RECIPES.add(recipe);
    }

    public static void addRecipe(ItemStack stackOut, ItemStack stackIn) {
        RECIPES.add(new CrabPotFilterRecipeBubbler(stackOut, stackIn));
    }

    public static void addRecipe(Item itemOut, Item itemIn) {
        RECIPES.add(new CrabPotFilterRecipeBubbler(itemOut, itemIn));
    }

    public static void removeRecipe(ICrabPotFilterRecipeBubbler recipe) {
        RECIPES.remove(recipe);
    }

    public static Item getItem(Block block) {
        return Item.func_150898_a((Block)block);
    }

    public static ICrabPotFilterRecipeBubbler getFilterRecipe(ItemStack stack) {
        for (ICrabPotFilterRecipeBubbler filterRecipe : RECIPES) {
            if (!filterRecipe.matchesInput(stack)) continue;
            return filterRecipe;
        }
        return null;
    }

    public static ItemStack getRecipeOutput(ItemStack input) {
        for (ICrabPotFilterRecipeBubbler recipe : RECIPES) {
            if (!recipe.matchesInput(input)) continue;
            return recipe.getOutput(input);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean matchesInput(ItemStack stack) {
        return this.input.func_77952_i() == Short.MAX_VALUE ? this.input.func_77973_b() == stack.func_77973_b() : this.input.func_77973_b() == stack.func_77973_b() && this.input.func_77952_i() == stack.func_77952_i();
    }

    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public ItemStack getInput() {
        return this.input;
    }

    @Override
    public ItemStack getOutput(ItemStack stack) {
        return this.output;
    }

    public static List<ICrabPotFilterRecipeBubbler> getRecipeList() {
        return Collections.unmodifiableList(RECIPES);
    }
}

