/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.censer;

import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.block.ICenser;
import thebetweenlands.api.recipes.ICenserRecipe;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.network.clientbound.MessageCureDecayParticles;
import thebetweenlands.common.recipe.censer.AbstractCenserRecipe;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityDugSoil;

public class CenserRecipePlantTonic
extends AbstractCenserRecipe<Void> {
    private static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "plant_tonic");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public boolean matchesInput(ItemStack stack) {
        return stack.func_77973_b() == ItemRegistry.BL_BUCKET_PLANT_TONIC;
    }

    @Override
    public ItemStack consumeInput(ItemStack stack) {
        return new ItemStack((Item)ItemRegistry.BL_BUCKET, 1, stack.func_77960_j());
    }

    @Override
    public int getConsumptionAmount(Void context, ICenser censer) {
        return 0;
    }

    @Override
    public int update(Void context, ICenser censer) {
        World world = censer.getCenserWorld();
        if (!world.field_72995_K && world.func_82737_E() % 100L == 0L) {
            BlockPos pos = censer.getCenserPos();
            int verticalRange = 4;
            int range = 16;
            int sx = MathHelper.func_76141_d((float)(pos.func_177958_n() - 16)) >> 4;
            int sz = MathHelper.func_76141_d((float)(pos.func_177952_p() - 16)) >> 4;
            int ex = MathHelper.func_76141_d((float)(pos.func_177958_n() + 16)) >> 4;
            int ez = MathHelper.func_76141_d((float)(pos.func_177952_p() + 16)) >> 4;
            int cost = 0;
            for (int cx = sx; cx <= ex; ++cx) {
                for (int cz = sz; cz <= ez; ++cz) {
                    Chunk chunk = world.func_72863_F().func_186026_b(cx, cz);
                    if (chunk == null) continue;
                    Map tiles = chunk.func_177434_r();
                    for (Map.Entry entry : tiles.entrySet()) {
                        BlockPos tePos = (BlockPos)entry.getKey();
                        TileEntity te = (TileEntity)entry.getValue();
                        if (!(te instanceof TileEntityDugSoil) || tePos.func_177958_n() < pos.func_177958_n() - 16 || tePos.func_177958_n() > pos.func_177958_n() + 16 || tePos.func_177956_o() < pos.func_177956_o() - 4 || tePos.func_177956_o() > pos.func_177956_o() + 4 || tePos.func_177952_p() < pos.func_177952_p() - 16 || tePos.func_177952_p() > pos.func_177952_p() + 16 || ((TileEntityDugSoil)te).getDecay() <= 5) continue;
                        ((TileEntityDugSoil)te).setDecay(0);
                        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageCureDecayParticles(tePos.func_177984_a()), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)tePos.func_177958_n(), (double)tePos.func_177956_o(), (double)tePos.func_177952_p(), 32.0));
                        cost += 10;
                    }
                }
            }
            return cost;
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getEffectColor(Void context, ICenser censer, ICenserRecipe.EffectColorType type) {
        return -1196992;
    }
}

