/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.datamanager;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.ReportedException;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ObjectUtils;
import thebetweenlands.api.network.IGenericDataManagerAccess;
import thebetweenlands.common.config.BetweenlandsConfig;

public class GenericDataManager
implements IGenericDataManagerAccess {
    private static final TObjectIntMap<Class<?>> NEXT_ID_MAP = new TObjectIntHashMap();
    private final List<DataEntry<?>> trackedEntries = new ArrayList();
    private final TIntObjectMap<DataEntry<?>> entries = new TIntObjectHashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean empty = true;
    private boolean dirty;
    private final Object owner;

    public GenericDataManager(Object owner) {
        this.owner = owner;
    }

    public static <T> DataParameter<T> createKey(Class<?> clazz, Serializer<T> serializer, Deserializer<T> deserializer) {
        if (BetweenlandsConfig.DEBUG.debug) {
            try {
                Class<?> callerClass = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!callerClass.equals(clazz)) {
                    throw new RuntimeException("GenericDataManager#createKey called for: " + clazz + " from " + callerClass);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return new CustomSerializer(serializer, deserializer).func_187161_a(GenericDataManager.createFreeId(clazz));
    }

    public static <T> DataParameter<T> createKey(Class<?> clazz, DataSerializer<T> serializer) {
        if (BetweenlandsConfig.DEBUG.debug) {
            try {
                Class<?> callerClass = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!callerClass.equals(clazz)) {
                    throw new RuntimeException("GenericDataManager#createKey called for: " + clazz + " from " + callerClass);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return serializer.func_187161_a(GenericDataManager.createFreeId(clazz));
    }

    private static int createFreeId(Class<?> clazz) {
        int freeId;
        if (NEXT_ID_MAP.containsKey(clazz)) {
            freeId = NEXT_ID_MAP.get(clazz) + 1;
        } else {
            int nextId = 0;
            Class<?> hierarchyCls = clazz;
            while ((hierarchyCls = hierarchyCls.getSuperclass()) != null) {
                if (!NEXT_ID_MAP.containsKey(hierarchyCls)) continue;
                nextId = NEXT_ID_MAP.get(hierarchyCls) + 1;
                break;
            }
            freeId = nextId;
        }
        if (freeId > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + freeId + "! (Max is " + 254 + ")");
        }
        NEXT_ID_MAP.put(clazz, freeId);
        return freeId;
    }

    public <T> DataParameter<T> register(DataParameter<T> key, T value) {
        int id = key.func_187155_a();
        if (id > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + id + "! (Max is " + 254 + ")");
        }
        if (this.entries.containsKey(Integer.valueOf(id).intValue())) {
            throw new IllegalArgumentException("Duplicate id value for " + id + "!");
        }
        if (!(key.func_187156_b() instanceof CustomSerializer) && DataSerializers.func_187188_b((DataSerializer)key.func_187156_b()) < 0) {
            throw new IllegalArgumentException("Unregistered serializer " + key.func_187156_b() + " for " + id + "!");
        }
        this.setEntry(key, value);
        return key;
    }

    public <T> DataParameter<T> register(DataParameter<T> key, int trackingTime, T value) {
        this.register(key, value);
        this.setTrackingTime(key, trackingTime);
        return key;
    }

    public <T> DataParameter<T> setTrackingTime(DataParameter<T> key, int time) {
        DataEntry<T> entry = this.getEntry(key);
        if (entry == null) {
            throw new IllegalArgumentException("Data parameter " + key + " is not registered!");
        }
        ((DataEntry)entry).trackingTime = time;
        if (time > 0) {
            if (!this.trackedEntries.contains(entry)) {
                this.trackedEntries.add(entry);
            }
        } else {
            this.trackedEntries.remove(entry);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void setEntry(DataParameter<T> key, T value) {
        DataEntry<T> entry = new DataEntry<T>(this, key, value);
        DataSerializer serializer = entry.getKey().func_187156_b();
        if (serializer instanceof CustomSerializer) {
            ((DataEntry)entry).serializer = ((CustomSerializer)serializer).serializer;
            ((DataEntry)entry).deserializer = ((CustomSerializer)serializer).deserializer;
        }
        this.lock.writeLock().lock();
        try {
            this.entries.put(Integer.valueOf(key.func_187155_a()).intValue(), entry);
            this.empty = false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> DataEntry<T> getEntry(DataParameter<T> key) {
        this.lock.readLock().lock();
        try {
            DataEntry entry;
            try {
                entry = (DataEntry)this.entries.get(Integer.valueOf(key.func_187155_a()).intValue());
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)("Getting synced " + this.owner.getClass().getName() + " data"));
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Synced " + this.owner.getClass().getName() + " data");
                crashreportcategory.func_71507_a("Data ID", key);
                throw new ReportedException(crashreport);
            }
            DataEntry dataEntry = entry;
            return dataEntry;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <T> T get(DataParameter<T> key) {
        DataEntry<T> entry = this.getEntry(key);
        if (entry == null) {
            throw new IllegalArgumentException("Data parameter " + key + " is not registered!");
        }
        return entry.getValue();
    }

    public <T> EntryAccess<T> set(DataParameter<T> key, T value) {
        DataEntry<T> entry = this.getEntry(key);
        if (entry == null) {
            throw new IllegalArgumentException("Data parameter " + key + " is not registered!");
        }
        if (ObjectUtils.notEqual(value, entry.getValue())) {
            if (!(this.owner instanceof IGenericDataManagerAccess.IDataManagedObject) || !((IGenericDataManagerAccess.IDataManagedObject)this.owner).onParameterChange(key, value, false)) {
                entry.setValue(value);
            }
            entry.setDirty(true);
        }
        return ((DataEntry)entry).access;
    }

    public <T> EntryAccess<T> setDirty(DataParameter<T> key) {
        DataEntry<T> entry = this.getEntry(key);
        if (entry == null) {
            throw new IllegalArgumentException("Data parameter " + key + " is not registered!");
        }
        entry.setDirty(true);
        return ((DataEntry)entry).access;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    private <T> void serializeEntry(DataEntry<T> entry, DataEntry<?> copy) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        try {
            ((DataEntry)entry).serializer.serialize(buf, ((DataEntry)entry).value);
            DataEntry.access$802(copy, new byte[buf.readableBytes()]);
            buf.readBytes(((DataEntry)copy).serializedData);
        }
        catch (Exception ex) {
            throw new DecoderException("Failed serializing data with custom serializer " + ((DataEntry)entry).serializer.getClass().getName(), (Throwable)ex);
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<IGenericDataManagerAccess.IDataEntry<?>> getDirty() {
        ArrayList<IGenericDataManagerAccess.IDataEntry> list = null;
        if (this.dirty) {
            this.lock.readLock().lock();
            try {
                for (DataEntry entry : this.entries.valueCollection()) {
                    if (!entry.isDirty()) continue;
                    entry.setDirty(false);
                    if (list == null) {
                        list = new ArrayList<IGenericDataManagerAccess.IDataEntry>();
                    }
                    IGenericDataManagerAccess.IDataEntry copy = entry.copy();
                    list.add(copy);
                    if (entry.serializer == null) continue;
                    this.serializeEntry(entry, (DataEntry<?>)copy);
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        this.dirty = false;
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<IGenericDataManagerAccess.IDataEntry<?>> getAll() {
        ArrayList<IGenericDataManagerAccess.IDataEntry> list = null;
        this.lock.readLock().lock();
        try {
            for (DataEntry entry : this.entries.valueCollection()) {
                if (list == null) {
                    list = new ArrayList<IGenericDataManagerAccess.IDataEntry>();
                }
                IGenericDataManagerAccess.IDataEntry copy = entry.copy();
                list.add(copy);
                if (entry.serializer == null) continue;
                this.serializeEntry(entry, (DataEntry<?>)copy);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return list;
    }

    public static void writeEntries(List<? extends IGenericDataManagerAccess.IDataEntry<?>> entriesIn, PacketBuffer buf) throws IOException {
        if (entriesIn != null) {
            int j = entriesIn.size();
            for (int i = 0; i < j; ++i) {
                DataEntry dataentry = (DataEntry)entriesIn.get(i);
                GenericDataManager.writeEntry(buf, dataentry);
            }
        }
        buf.writeByte(255);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void writeEntry(PacketBuffer buf, DataEntry<T> entry) throws IOException {
        DataParameter<T> parameter = entry.getKey();
        buf.writeByte(parameter.func_187155_a());
        if (((DataEntry)entry).serializedData != null) {
            buf.writeBoolean(true);
            byte[] byArray = ((DataEntry)entry).serializedData;
            synchronized (byArray) {
                buf.func_150787_b(((DataEntry)entry).serializedData.length);
                buf.writeBytes(((DataEntry)entry).serializedData);
            }
        } else {
            buf.writeBoolean(false);
            int i = DataSerializers.func_187188_b((DataSerializer)parameter.func_187156_b());
            if (i < 0) {
                throw new EncoderException("Unknown serializer type " + parameter.func_187156_b());
            }
            buf.func_150787_b(i);
            parameter.func_187156_b().func_187160_a(buf, entry.getValue());
        }
    }

    @Nullable
    public static List<IGenericDataManagerAccess.IDataEntry<?>> readEntries(PacketBuffer buf) throws IOException {
        short key;
        ArrayList<DataEntry<Object>> list = null;
        while ((key = buf.readUnsignedByte()) != 255) {
            CustomSerializer serializer;
            if (list == null) {
                list = new ArrayList<DataEntry<Object>>();
            }
            Object value = null;
            byte[] serializedData = null;
            if (buf.readBoolean()) {
                serializedData = new byte[buf.func_150792_a()];
                buf.readBytes(serializedData);
                serializer = new CustomSerializer(null, null);
            } else {
                int serializerId = buf.func_150792_a();
                serializer = DataSerializers.func_187190_a((int)serializerId);
                if (serializer == null) {
                    throw new DecoderException("Unknown serializer type " + serializerId);
                }
                value = serializer.func_187159_a(buf);
            }
            DataEntry<Object> entry = new DataEntry<Object>(null, serializer.func_187161_a(key), value);
            DataEntry.access$802(entry, serializedData);
            list.add(entry);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    public void setValuesFromPacket(List<? extends IGenericDataManagerAccess.IDataEntry<?>> newEntries) {
        this.lock.writeLock().lock();
        try {
            for (IGenericDataManagerAccess.IDataEntry<?> newEntry : newEntries) {
                Object newValue;
                DataEntry entry = (DataEntry)this.entries.get(Integer.valueOf(newEntry.getKey().func_187155_a()).intValue());
                if (entry == null) continue;
                if (newEntry instanceof DataEntry && entry.deserializer != null) {
                    DataEntry newGenericEntry = (DataEntry)newEntry;
                    if (newGenericEntry.deserializedValue == null) {
                        ByteBuf buf = Unpooled.wrappedBuffer((byte[])newGenericEntry.serializedData);
                        try {
                            newGenericEntry.deserializedValue = entry.deserializer.deserialize(new PacketBuffer(buf));
                        }
                        catch (Exception ex) {
                            throw new DecoderException("Failed deserializing data with custom deserializer " + entry.deserializer.getClass().getName(), (Throwable)ex);
                        }
                        finally {
                            buf.release();
                        }
                    }
                    newValue = newGenericEntry.deserializedValue;
                } else {
                    newValue = newEntry.getValue();
                }
                if (this.owner instanceof IGenericDataManagerAccess.IDataManagedObject && ((IGenericDataManagerAccess.IDataManagedObject)this.owner).onParameterChange(entry.getKey(), newValue, true)) continue;
                this.setEntryValue(entry, newValue);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.dirty = true;
    }

    @SideOnly(value=Side.CLIENT)
    protected <T> void setEntryValue(DataEntry<T> target, Object value) {
        target.setValue(value);
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public void setClean() {
        this.dirty = false;
        this.lock.readLock().lock();
        try {
            for (DataEntry dataentry : this.entries.valueCollection()) {
                dataentry.setDirty(false);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void func_73660_a() {
        if (!this.trackedEntries.isEmpty()) {
            for (DataEntry<?> entry : this.trackedEntries) {
                if (((DataEntry)entry).trackingTimer >= 0) {
                    ((DataEntry)entry).trackingTimer--;
                }
                if (!((DataEntry)entry).queuedDirty || ((DataEntry)entry).trackingTimer >= 0) continue;
                ((DataEntry)entry).trackingTimer = ((DataEntry)entry).trackingTime;
                ((DataEntry)entry).dirty = true;
                this.dirty = true;
                ((DataEntry)entry).queuedDirty = false;
            }
        }
    }

    public static class DataEntry<T>
    implements IGenericDataManagerAccess.IDataEntry<T> {
        private final GenericDataManager dataManager;
        private final DataParameter<T> key;
        private T value;
        private boolean queuedDirty;
        private boolean dirty;
        private int trackingTime;
        private int trackingTimer;
        private EntryAccess<T> access;
        private byte[] serializedData;
        private Object deserializedValue;
        private Serializer<T> serializer;
        private Deserializer<T> deserializer;

        public DataEntry(GenericDataManager dataManager, DataParameter<T> keyIn, T valueIn) {
            this.dataManager = dataManager;
            this.key = keyIn;
            this.value = valueIn;
            this.dirty = true;
            this.access = new EntryAccess(this);
        }

        private DataEntry(GenericDataManager dataManager, DataParameter<T> keyIn, T valueIn, int trackingTime) {
            this.dataManager = dataManager;
            this.key = keyIn;
            this.value = valueIn;
            this.dirty = true;
            this.trackingTime = trackingTime;
            this.access = new EntryAccess(this);
        }

        @Override
        public DataParameter<T> getKey() {
            return this.key;
        }

        @Override
        public void setValue(T valueIn) {
            this.value = valueIn;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }

        @Override
        public void setDirty(boolean dirtyIn) {
            if (this.trackingTime > 0 && dirtyIn) {
                this.queuedDirty = true;
            } else {
                this.queuedDirty = false;
                this.dirty = dirtyIn;
                if (dirtyIn) {
                    this.dataManager.dirty = true;
                }
            }
        }

        @Override
        public DataEntry<T> copy() {
            return new DataEntry<Object>(this.dataManager, this.key, this.key.func_187156_b().func_192717_a(this.value), this.trackingTime);
        }

        static /* synthetic */ byte[] access$802(DataEntry x0, byte[] x1) {
            x0.serializedData = x1;
            return x1;
        }
    }

    public static class EntryAccess<T> {
        private DataEntry<T> entry;

        private EntryAccess(DataEntry<T> entry) {
            this.entry = entry;
        }

        public T getValue() {
            return (T)((DataEntry)this.entry).value;
        }

        public EntryAccess<T> setDirty() {
            this.entry.setDirty(true);
            return this;
        }

        public EntryAccess<T> syncImmediately() {
            if (((DataEntry)this.entry).queuedDirty) {
                ((DataEntry)this.entry).dirty = true;
                ((DataEntry)this.entry).dataManager.dirty = true;
                ((DataEntry)this.entry).queuedDirty = false;
            }
            return this;
        }
    }

    private static final class CustomSerializer<T>
    implements DataSerializer<Object> {
        private final Serializer<T> serializer;
        private final Deserializer<T> deserializer;

        private CustomSerializer(Serializer<T> serializer, Deserializer<T> deserializer) {
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        public void func_187160_a(PacketBuffer buf, Object value) {
        }

        public Object func_187159_a(PacketBuffer buf) throws IOException {
            return null;
        }

        public DataParameter<Object> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Object func_192717_a(Object value) {
            return new CustomSerializer<T>(this.serializer, this.deserializer);
        }
    }

    public static interface Deserializer<T> {
        public T deserialize(PacketBuffer var1) throws IOException;
    }

    public static interface Serializer<T> {
        public void serialize(PacketBuffer var1, T var2) throws IOException;
    }
}

