/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.network.MessageBase;

public class MessageWeedwoodBushRustle
extends MessageBase {
    private BlockPos pos;
    private float strength;

    public MessageWeedwoodBushRustle() {
    }

    public MessageWeedwoodBushRustle(BlockPos pos, float strength) {
        this.pos = pos;
        this.strength = strength;
    }

    @Override
    public void serialize(PacketBuffer buffer) {
        buffer.writeLong(this.pos.func_177986_g());
        buffer.writeFloat(this.strength);
    }

    @Override
    public void deserialize(PacketBuffer buffer) {
        this.pos = BlockPos.func_177969_a((long)buffer.readLong());
        this.strength = buffer.readFloat();
    }

    @Override
    public IMessage process(MessageContext ctx) {
        if (ctx.side.isClient()) {
            this.handle();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handle() {
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        if (world != null) {
            int leafCount = (int)(47.0f * this.getStrength()) + 1;
            float x = (float)this.getPos().func_177958_n() + 0.5f;
            float y = (float)this.getPos().func_177956_o() + 0.5f;
            float z = (float)this.getPos().func_177952_p() + 0.5f;
            while (leafCount-- > 0) {
                float dx = world.field_73012_v.nextFloat() * 2.0f - 1.0f;
                float dy = world.field_73012_v.nextFloat() * 2.0f - 0.5f;
                float dz = world.field_73012_v.nextFloat() * 2.0f - 1.0f;
                float mag = 0.01f + world.field_73012_v.nextFloat() * 0.07f;
                BLParticles.WEEDWOOD_LEAF.spawn((World)world, x, y, z, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(dx * mag, dy * mag, dz * mag));
            }
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public float getStrength() {
        return this.strength;
    }
}

