/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools.bow;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.item.CorrosionHelper;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.api.item.ICorrodible;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.item.tools.bow.ItemBLArrow;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemBLBow
extends ItemBow
implements ICorrodible,
IAnimatorRepairable {
    public ItemBLBow() {
        this.field_77777_bU = 1;
        this.func_77656_e(600);
        this.func_77637_a(BLCreativeTabs.GEARS);
        CorrosionHelper.addCorrosionPropertyOverrides((Item)this);
        this.func_185043_a(new ResourceLocation("pull"), (stack, worldIn, entityIn) -> {
            if (entityIn == null) {
                return 0.0f;
            }
            ItemStack itemStack = entityIn.func_184607_cu();
            return !itemStack.func_190926_b() && itemStack == stack ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
        });
        this.func_185043_a(new ResourceLocation("arrow_type"), (stack, worldIn, entityIn) -> {
            ItemStack arrow;
            if (entityIn instanceof EntityPlayer && (arrow = this.findArrows((EntityPlayer)entityIn)).func_77973_b() instanceof ItemBLArrow) {
                return ((ItemBLArrow)arrow.func_77973_b()).getType().getId();
            }
            return 0.0f;
        });
    }

    protected ItemStack findArrows(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean func_185058_h_(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemArrow;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            boolean infiniteBow = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack arrow = this.findArrows(player);
            int usedTicks = this.func_77626_a(stack) - timeLeft;
            if ((usedTicks = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)entityLiving), (int)usedTicks, (!arrow.func_190926_b() || infiniteBow ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!arrow.func_190926_b() || infiniteBow) {
                if (arrow.func_190926_b()) {
                    arrow = new ItemStack(ItemRegistry.ANGLER_TOOTH_ARROW);
                }
                float strength = ItemBLBow.getArrowVelocity(usedTicks);
                if ((strength *= CorrosionHelper.getModifier(stack)) >= 0.1f) {
                    boolean infiniteArrows;
                    boolean bl = infiniteArrows = player.field_71075_bZ.field_75098_d || arrow.func_77973_b() instanceof ItemArrow && ((ItemArrow)arrow.func_77973_b()).isInfinite(arrow, stack, player);
                    if (!world.field_72995_K) {
                        int k;
                        int j;
                        ItemArrow itemArrow = (ItemArrow)arrow.func_77973_b();
                        EntityArrow entityArrow = itemArrow.func_185052_a(world, arrow, (EntityLivingBase)player);
                        entityArrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, strength * 3.0f, 1.0f);
                        if (strength == 1.0f) {
                            entityArrow.func_70243_d(true);
                        }
                        if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                            entityArrow.func_70239_b(entityArrow.func_70242_d() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                            entityArrow.func_70240_a(k);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            entityArrow.func_70015_d(100);
                        }
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        if (infiniteArrows || player.field_71075_bZ.field_75098_d && (arrow.func_77973_b() == Items.field_185166_h || arrow.func_77973_b() == Items.field_185167_i)) {
                            entityArrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        this.fireArrow(player, stack, entityArrow, strength);
                    }
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + strength * 0.5f);
                    if (!infiniteArrows) {
                        arrow.func_190918_g(1);
                        if (arrow.func_190916_E() == 0) {
                            player.field_71071_by.func_184437_d(arrow);
                        }
                    }
                    player.func_71029_a(StatList.func_188057_b((Item)this));
                }
            }
        }
    }

    protected void fireArrow(EntityPlayer player, ItemStack stack, EntityArrow arrow, float strength) {
        player.field_70170_p.func_72838_d((Entity)arrow);
    }

    public static float getArrowVelocity(int charge) {
        float strength = (float)charge / 20.0f;
        if ((strength = (strength * strength + strength * 2.0f) / 3.0f * 1.15f) > 1.0f) {
            strength = 1.0f;
        }
        return strength;
    }

    public int func_77626_a(ItemStack stack) {
        return 100000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        boolean flag;
        ItemStack itemstack = playerIn.func_184586_b(hand);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)hand, (boolean)(flag = !this.findArrows(playerIn).func_190926_b()));
        if (ret != null) {
            return ret;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return CorrosionHelper.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return CorrosionHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return CorrosionHelper.getDestroySpeed(super.func_150893_a(stack, state), stack, state);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity holder, int slot, boolean isHeldItem) {
        CorrosionHelper.updateCorrosion(itemStack, world, holder, slot, isHeldItem);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        CorrosionHelper.addCorrosionTooltips(stack, tooltip, flagIn.func_194127_a());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onUpdateFov(FOVUpdateEvent event) {
        ItemStack activeItem = event.getEntity().func_184607_cu();
        if (!activeItem.func_190926_b() && activeItem.func_77973_b() instanceof ItemBLBow) {
            int usedTicks = activeItem.func_77973_b().func_77626_a(activeItem) - event.getEntity().func_184605_cv();
            float strength = (float)usedTicks / 20.0f;
            if ((strength = (strength * strength + strength * 2.0f) / 3.0f * 1.15f) > 1.0f) {
                strength = 1.0f;
            }
            event.setNewfov(1.0f - strength * 0.25f);
        }
    }

    @Override
    public int getMinRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairFuelCost(BLMaterialRegistry.TOOL_WEEDWOOD);
    }

    @Override
    public int getFullRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairFuelCost(BLMaterialRegistry.TOOL_WEEDWOOD);
    }

    @Override
    public int getMinRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairLifeCost(BLMaterialRegistry.TOOL_WEEDWOOD);
    }

    @Override
    public int getFullRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairLifeCost(BLMaterialRegistry.TOOL_WEEDWOOD);
    }
}

