/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.block.ISickleHarvestable;
import thebetweenlands.api.item.CorrosionHelper;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.api.item.ICorrodible;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;

public class ItemSickle
extends Item
implements ICorrodible,
IAnimatorRepairable {
    public ItemSickle() {
        this.func_77655_b("thebetweenlands.sickle");
        this.func_77625_d(1);
        this.func_77656_e(2500);
        this.func_77637_a(BLCreativeTabs.GEARS);
        CorrosionHelper.addCorrosionPropertyOverrides(this);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        ISickleHarvestable target;
        boolean shouldDrop;
        boolean bl = shouldDrop = player.field_70170_p.field_73012_v.nextFloat() <= 1.0f * CorrosionHelper.getModifier(itemstack);
        if (player.field_70170_p.field_72995_K || player.field_71075_bZ.field_75098_d || !shouldDrop) {
            return false;
        }
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block instanceof ISickleHarvestable && (target = (ISickleHarvestable)block).isHarvestable(itemstack, (IBlockAccess)player.field_70170_p, pos)) {
            List<ItemStack> drops = target.getHarvestableDrops(itemstack, (IBlockAccess)player.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"fortune"), (ItemStack)itemstack));
            if (drops == null || drops.isEmpty()) {
                return false;
            }
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float offset = 0.7f;
                double rx = (double)(rand.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
                double ry = (double)(rand.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
                double rz = (double)(rand.nextFloat() * offset) + (double)(1.0f - offset) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)pos.func_177958_n() + rx, (double)pos.func_177956_o() + ry, (double)pos.func_177952_p() + rz, stack);
                entityitem.func_174869_p();
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            itemstack.func_77972_a(1, (EntityLivingBase)player);
            block.func_176208_a(player.field_70170_p, pos, player.field_70170_p.func_180495_p(pos), player);
            if (player instanceof EntityPlayerMP) {
                AdvancementCriterionRegistry.SICKLE_USE.trigger((EntityPlayerMP)player);
            }
            player.field_70170_p.func_175698_g(pos);
            player.func_71064_a(StatList.func_188055_a((Block)block), 1);
            return true;
        }
        return false;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return CorrosionHelper.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return CorrosionHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return CorrosionHelper.getDestroySpeed(super.func_150893_a(stack, state), stack, state);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity holder, int slot, boolean isHeldItem) {
        CorrosionHelper.updateCorrosion(itemStack, world, holder, slot, isHeldItem);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        CorrosionHelper.addCorrosionTooltips(stack, tooltip, flagIn.func_194127_a());
    }

    @Override
    public int getMinRepairFuelCost(ItemStack stack) {
        return 6;
    }

    @Override
    public int getFullRepairFuelCost(ItemStack stack) {
        return 16;
    }

    @Override
    public int getMinRepairLifeCost(ItemStack stack) {
        return 12;
    }

    @Override
    public int getFullRepairLifeCost(ItemStack stack) {
        return 32;
    }
}

