/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.entity.EntityTinyWormEggSac;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.entity.mobs.EntityCaveFish;
import thebetweenlands.common.entity.mobs.EntityChiromawHatchling;
import thebetweenlands.common.entity.mobs.EntityChiromawTame;
import thebetweenlands.common.entity.mobs.EntityDragonFly;
import thebetweenlands.common.entity.mobs.EntityFirefly;
import thebetweenlands.common.entity.mobs.EntityFreshwaterUrchin;
import thebetweenlands.common.entity.mobs.EntityGecko;
import thebetweenlands.common.entity.mobs.EntityJellyfish;
import thebetweenlands.common.entity.mobs.EntityMireSnail;
import thebetweenlands.common.entity.mobs.EntityOlm;
import thebetweenlands.common.entity.mobs.EntityTinySludgeWorm;
import thebetweenlands.common.entity.mobs.EntityTinySludgeWormHelper;
import thebetweenlands.common.item.misc.ItemMob;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemNet
extends Item
implements IAnimatorRepairable {
    public static final Multimap<Class<? extends Entity>, Pair<Supplier<? extends ItemMob>, BiPredicate<EntityPlayer, Entity>>> CATCHABLE_ENTITIES = MultimapBuilder.hashKeys().arrayListValues().build();

    public static <T extends Entity> void register(Class<T> cls, Supplier<? extends ItemMob> item, BiPredicate<EntityPlayer, T> predicate) {
        CATCHABLE_ENTITIES.put(cls, (Object)Pair.of(item, predicate));
    }

    public ItemNet() {
        this.field_77777_bU = 1;
        this.func_77656_e(32);
        this.func_77637_a(BLCreativeTabs.GEARS);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        Collection entries = CATCHABLE_ENTITIES.get(target.getClass());
        if (entries != null) {
            for (Pair entry : entries) {
                if (!((BiPredicate)entry.getRight()).test(player, target)) continue;
                ItemMob item = (ItemMob)((Object)((Supplier)entry.getLeft()).get());
                player.func_184609_a(hand);
                if (!player.field_70170_p.field_72995_K) {
                    ItemStack mobItemStack = item.capture((Entity)target);
                    if (mobItemStack.func_190926_b()) continue;
                    target.func_184174_b(false);
                    target.func_70106_y();
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, mobItemStack));
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    item.onCapturedByPlayer(player, hand, mobItemStack, target);
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int getMinRepairFuelCost(ItemStack stack) {
        return 2;
    }

    @Override
    public int getFullRepairFuelCost(ItemStack stack) {
        return 8;
    }

    @Override
    public int getMinRepairLifeCost(ItemStack stack) {
        return 4;
    }

    @Override
    public int getFullRepairLifeCost(ItemStack stack) {
        return 12;
    }

    static {
        ItemNet.register(EntityFirefly.class, () -> ItemRegistry.CRITTER, (p, e) -> true);
        ItemNet.register(EntityGecko.class, () -> ItemRegistry.CRITTER, (p, e) -> true);
        ItemNet.register(EntityDragonFly.class, () -> ItemRegistry.CRITTER, (p, e) -> true);
        ItemNet.register(EntityTinyWormEggSac.class, () -> ItemRegistry.SLUDGE_WORM_EGG_SAC, (p, e) -> true);
        ItemNet.register(EntityChiromawHatchling.class, () -> ItemRegistry.CHIROMAW_EGG, (p, e) -> !e.getHasHatched() && !e.getElectricBoogaloo());
        ItemNet.register(EntityChiromawHatchling.class, () -> ItemRegistry.CHIROMAW_EGG_LIGHTNING, (p, e) -> !e.getHasHatched() && e.getElectricBoogaloo());
        ItemNet.register(EntityChiromawTame.class, () -> ItemRegistry.CHIROMAW_TAME, (p, e) -> e.func_70902_q() == p && !e.getElectricBoogaloo());
        ItemNet.register(EntityChiromawTame.class, () -> ItemRegistry.CHIROMAW_TAME_LIGHTNING, (p, e) -> e.func_70902_q() == p && e.getElectricBoogaloo());
        ItemNet.register(EntityTinySludgeWorm.class, () -> ItemRegistry.TINY_SLUDGE_WORM, (p, e) -> true);
        ItemNet.register(EntityTinySludgeWormHelper.class, () -> ItemRegistry.TINY_SLUDGE_WORM_HELPER, (p, e) -> true);
        ItemNet.register(EntityMireSnail.class, () -> ItemRegistry.CRITTER, (p, e) -> true);
        ItemNet.register(EntityAnadia.class, () -> ItemRegistry.ANADIA, (p, e) -> e.getNettableTimer() > 0);
        ItemNet.register(EntityFreshwaterUrchin.class, () -> ItemRegistry.FRESHWATER_URCHIN, (p, e) -> true);
        ItemNet.register(EntityCaveFish.class, () -> ItemRegistry.CRITTER, (p, e) -> true);
        ItemNet.register(EntityOlm.class, () -> ItemRegistry.CRITTER, (p, e) -> true);
        ItemNet.register(EntityJellyfish.class, () -> ItemRegistry.JELLYFISH, (p, e) -> true);
    }
}

