/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.tools.ItemGreatsword;

public class ItemGreataxe
extends ItemGreatsword {
    public ItemGreataxe(Item.ToolMaterial material) {
        super(material);
        this.setHarvestLevel("axe", 3);
        this.func_77637_a(BLCreativeTabs.GEARS);
        this.func_77656_e(material.func_77997_a() * 2);
    }

    protected double getBlockBreakHalfAngle(EntityLivingBase entity, ItemStack stack) {
        return 45.0;
    }

    protected double getBlockBreakReach(EntityLivingBase entity, ItemStack stack) {
        return 2.6;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity holder, int slot, boolean isHeldItem) {
        EntityPlayerMP player;
        super.func_77663_a(stack, world, holder, slot, isHeldItem);
        if (holder instanceof EntityPlayerMP && !holder.field_70170_p.field_72995_K && (player = (EntityPlayerMP)holder).func_184614_ca() == stack && this.isLongSwingInProgress(stack) && this.getSwingStartCooledAttackStrength(stack) > 0.85f) {
            int ticksElapsed = player.field_70173_aa - this.getSwingStartTicks(stack) - 1;
            float longSwingTickProgress = 1.0f / (this.getLongSwingDuration((EntityLivingBase)player, stack) - 1.0f);
            float longSwingProgressEnd = (float)(ticksElapsed + 1) / (this.getLongSwingDuration((EntityLivingBase)player, stack) - 1.0f);
            ArrayList<BlockPos> targetBlocks = new ArrayList<BlockPos>();
            for (float longSwingProgressStart = Math.max(0.0f, longSwingProgressEnd - Math.max(0.25f, longSwingTickProgress)); longSwingProgressStart < longSwingProgressEnd; longSwingProgressStart += longSwingTickProgress) {
                double breakReach = this.getBlockBreakReach((EntityLivingBase)player, stack);
                int blockReach = MathHelper.func_76143_f((double)breakReach);
                double breakHalfAngle = this.getBlockBreakHalfAngle((EntityLivingBase)player, stack);
                double minAngle = -breakHalfAngle + breakHalfAngle * 2.0 * (double)longSwingProgressStart;
                double maxAngle = -breakHalfAngle + breakHalfAngle * 2.0 * (double)longSwingProgressEnd;
                float yaw = player.field_70177_z;
                float pitch = player.field_70125_A;
                float yc = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                float ys = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                float pc = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
                float ps = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
                Vec3d forward = new Vec3d((double)(ys * pc), (double)ps, (double)(yc * pc)).func_72432_b();
                pc = -MathHelper.func_76134_b((float)(-(pitch - 90.0f) * ((float)Math.PI / 180)));
                ps = MathHelper.func_76126_a((float)(-(pitch - 90.0f) * ((float)Math.PI / 180)));
                Vec3d up = new Vec3d((double)(ys * pc), (double)ps, (double)(yc * pc)).func_72432_b();
                Vec3d right = forward.func_72431_c(up);
                for (int xo = -blockReach; xo <= blockReach; ++xo) {
                    for (int yo = -blockReach; yo <= blockReach; ++yo) {
                        for (int zo = -blockReach; zo <= blockReach; ++zo) {
                            IBlockState state;
                            double verticalRange;
                            double distUp;
                            BlockPos pos = new BlockPos(player.field_70165_t + (double)xo, player.field_70163_u + (double)player.field_70131_O * 0.5 + (double)yo, player.field_70161_v + (double)zo);
                            Vec3d center = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                            double dist = center.func_72438_d(player.func_174824_e(1.0f));
                            if (!(dist < breakReach)) continue;
                            Vec3d dir = center.func_178788_d(player.func_174824_e(1.0f)).func_72432_b();
                            double py = forward.func_72430_b(dir);
                            double px = right.func_72430_b(dir);
                            double angle = Math.toDegrees(-Math.atan2(px, py));
                            if (!(angle >= minAngle) || !(angle < maxAngle) || !((distUp = up.func_72430_b(new Vec3d(center.field_72450_a - player.field_70165_t, center.field_72448_b - player.field_70163_u - (double)player.func_70047_e(), center.field_72449_c - player.field_70161_v))) >= -(verticalRange = 1.0 + 1.5 * (3.0 - MathHelper.func_151237_a((double)dist, (double)0.0, (double)3.0)) / 3.0) - 0.5) || !(distUp <= verticalRange - 0.5) || !(state = player.field_70170_p.func_180495_p(pos)).func_177230_c().isWood((IBlockAccess)player.field_70170_p, pos) && state.func_185904_a() != Material.field_151575_d || !(state.func_185887_b(player.field_70170_p, pos) <= 2.25f) || !(state.func_185903_a((EntityPlayer)player, player.field_70170_p, pos) > 0.01f)) continue;
                            targetBlocks.add(pos);
                        }
                    }
                }
            }
            if (!targetBlocks.isEmpty()) {
                Collections.shuffle(targetBlocks, player.field_70170_p.field_73012_v);
                int playedEffects = 0;
                for (BlockPos pos : targetBlocks) {
                    if (world.func_175623_d(pos)) continue;
                    IBlockState state = player.field_70170_p.func_180495_p(pos);
                    if (!player.field_71134_c.func_180237_b(pos) || ++playedEffects > 3) continue;
                    player.field_70170_p.func_180498_a(null, 2001, pos, Block.func_176210_f((IBlockState)state));
                }
            }
        }
    }

    @Override
    public float getSwingSpeedMultiplier(EntityLivingBase entity, ItemStack stack) {
        return 0.14f;
    }

    @Override
    protected double getAoEReach(EntityLivingBase entityLiving, ItemStack stack) {
        return 0.0;
    }

    @Override
    public double getReach() {
        return 2.5;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.removeAll((Object)SharedMonsterAttributes.field_188790_f.func_111108_a());
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -3.3, 0));
        }
        return multimap;
    }

    public float func_150931_i() {
        return super.func_150931_i() + 2.0f;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        return true;
    }

    @Override
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.COMMON;
    }
}

