/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.entity.projectiles.EntityBLArrow;
import thebetweenlands.common.item.tools.bow.EnumArrowType;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.NBTHelper;

public class ItemChirobarbErupter
extends Item {
    public final boolean electric;
    private static final ImmutableList<String> STACK_NBT_EXCLUSIONS = ImmutableList.of((Object)"shooting", (Object)"rotation");

    public ItemChirobarbErupter(boolean electric) {
        this.electric = electric;
        this.field_77777_bU = 1;
        this.func_77656_e(64);
        this.func_77637_a(BLCreativeTabs.SPECIALS);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.chirobarb_erupter.usage", (Object[])new Object[0]), 0));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeldItem) {
        if (!world.field_72995_K) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.func_77978_p().func_74764_b("shooting")) {
                stack.func_77978_p().func_74757_a("shooting", false);
            }
            if (!stack.func_77978_p().func_74764_b("rotation")) {
                stack.func_77978_p().func_74768_a("rotation", 0);
            }
            if (stack.func_77978_p().func_74767_n("shooting") && entity instanceof EntityLivingBase) {
                stack.func_77978_p().func_74768_a("rotation", stack.func_77978_p().func_74762_e("rotation") + 30);
                if (stack.func_77978_p().func_74762_e("rotation") > 720) {
                    stack.func_77978_p().func_74768_a("rotation", 0);
                    stack.func_77978_p().func_74757_a("shooting", false);
                } else if (stack.func_77978_p().func_74762_e("rotation") % 30 == 0) {
                    float velocity;
                    EntityBLArrow arrow = new EntityBLArrow(world, (EntityLivingBase)entity);
                    arrow.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    arrow.func_70239_b(6.0);
                    if (this.electric) {
                        arrow.setType(EnumArrowType.CHIROMAW_SHOCK_BARB);
                    } else {
                        arrow.setType(EnumArrowType.CHIROMAW_BARB);
                    }
                    double angle = Math.toRadians(entity.field_70177_z + (float)stack.func_77978_p().func_74762_e("rotation") - 30.0f);
                    double dx = -Math.sin(angle);
                    double dz = Math.cos(angle);
                    double offsetX = dx * 1.5;
                    double offsetZ = dz * 1.5;
                    List nearbyEntities = world.func_175674_a(entity, entity.func_174813_aQ().func_72314_b(12.0, 0.0, 12.0), e -> e instanceof EntityLivingBase && e instanceof IMob && Math.abs(e.getEntityData().func_74762_e("thebetweenlands.chirobarb_erupter.lastTargetted") - e.field_70173_aa) >= 60);
                    arrow.func_70107_b(entity.field_70165_t + offsetX, entity.field_70163_u + (double)entity.field_70131_O * 0.75, entity.field_70161_v + offsetZ);
                    Entity closestNearby = null;
                    double closestNearbyAngle = 0.0;
                    double closestNearbyDstSq = Double.MAX_VALUE;
                    for (Entity nearby : nearbyEntities) {
                        Vec3d pos = nearby.func_174791_d().func_72441_c(0.0, (double)(nearby.field_70131_O / 2.0f), 0.0);
                        Vec3d diff = pos.func_178788_d(entity.func_174824_e(1.0f));
                        double dstSq = diff.func_189985_c();
                        Vec3d dir = new Vec3d(diff.field_72450_a, 0.0, diff.field_72449_c).func_72432_b();
                        double angleDiff = Math.acos(dir.field_72450_a * dx + dir.field_72449_c * dz);
                        if (!(dstSq < closestNearbyDstSq) || !(Math.abs(diff.field_72448_b) < 2.0) || !(angleDiff <= Math.toRadians(15.0))) continue;
                        closestNearby = nearby;
                        closestNearbyDstSq = dstSq;
                        Vec3d trajectory = pos.func_178788_d(arrow.func_174791_d()).func_72432_b();
                        closestNearbyAngle = Math.toDegrees(Math.atan2(trajectory.field_72449_c, trajectory.field_72450_a)) - 90.0;
                    }
                    float f = velocity = this.electric ? 1.4f : 1.1f;
                    if (closestNearby != null) {
                        closestNearby.getEntityData().func_74768_a("thebetweenlands.chirobarb_erupter.lastTargetted", closestNearby.field_70173_aa);
                        arrow.func_184547_a(entity, 0.0f, (float)closestNearbyAngle, 1.5f, velocity, 0.0f);
                    } else {
                        arrow.func_184547_a(entity, 0.0f, entity.field_70177_z + (float)stack.func_77978_p().func_74762_e("rotation") - 30.0f, 1.5f, velocity, 0.0f);
                    }
                    world.func_184133_a(null, entity.func_180425_c(), (SoundEvent)SoundRegistry.CHIROMAW_MATRIARCH_BARB_FIRE, SoundCategory.NEUTRAL, 0.25f, 1.0f + (field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.8f);
                    world.func_72838_d((Entity)arrow);
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (!stack.func_77978_p().func_74767_n("shooting")) {
            if (!world.field_72995_K) {
                stack.func_77972_a(1, (EntityLivingBase)player);
                player.func_184811_cZ().func_185145_a((Item)this, 60);
                stack.func_77978_p().func_74757_a("shooting", true);
                stack.func_77978_p().func_74768_a("rotation", 0);
                world.func_184133_a(null, player.func_180425_c(), (SoundEvent)SoundRegistry.CHIROBARB_ERUPTER, SoundCategory.NEUTRAL, 1.0f, 1.0f + (field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.8f);
            }
            player.func_184609_a(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && !NBTHelper.areItemStackTagsEqual(oldStack, newStack, STACK_NBT_EXCLUSIONS);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.electric;
    }
}

