/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.item.CorrosionHelper;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.api.item.ICorrodible;
import thebetweenlands.common.entity.mobs.EntityTinySludgeWorm;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.registries.BlockRegistry;

public class ItemBLShovel
extends ItemSpade
implements ICorrodible,
IAnimatorRepairable {
    public ItemBLShovel(Item.ToolMaterial material) {
        super(material);
        CorrosionHelper.addCorrosionPropertyOverrides((Item)this);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return CorrosionHelper.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return CorrosionHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return CorrosionHelper.getDestroySpeed(super.func_150893_a(stack, state), stack, state);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity holder, int slot, boolean isHeldItem) {
        CorrosionHelper.updateCorrosion(itemStack, world, holder, slot, isHeldItem);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return CorrosionHelper.getAttributeModifiers((Multimap<String, AttributeModifier>)super.getAttributeModifiers(slot, stack), slot, stack, field_111210_e, this.field_77865_bY);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        CorrosionHelper.addCorrosionTooltips(stack, tooltip, flagIn.func_194127_a());
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_185904_a() == Material.field_151585_k) {
            pos = pos.func_177977_b();
            blockState = world.func_180495_p(pos);
            facing = EnumFacing.UP;
        }
        if (facing == EnumFacing.UP) {
            boolean dug = false;
            if (blockState.func_177230_c() == BlockRegistry.COARSE_SWAMP_DIRT) {
                world.func_175656_a(pos, BlockRegistry.DUG_SWAMP_DIRT.func_176223_P());
                dug = true;
            }
            if (blockState.func_177230_c() == BlockRegistry.SWAMP_DIRT) {
                world.func_175656_a(pos, BlockRegistry.DUG_SWAMP_DIRT.func_176223_P());
                dug = true;
                this.checkForWormSpawn(world, pos, player);
            }
            if (blockState.func_177230_c() == BlockRegistry.SWAMP_GRASS) {
                world.func_175656_a(pos, BlockRegistry.DUG_SWAMP_GRASS.func_176223_P());
                dug = true;
                this.checkForWormSpawn(world, pos, player);
            }
            if (blockState.func_177230_c() == BlockRegistry.PURIFIED_SWAMP_DIRT) {
                world.func_175656_a(pos, BlockRegistry.DUG_PURIFIED_SWAMP_DIRT.func_176223_P());
                dug = true;
            }
            if (dug) {
                if (world.field_72995_K) {
                    for (int i = 0; i < 80; ++i) {
                        world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)((float)pos.func_177958_n() + 0.5f), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + 0.5f), (double)((world.field_73012_v.nextFloat() - 0.5f) * 0.1f), (double)(world.field_73012_v.nextFloat() * 0.3f), (double)((world.field_73012_v.nextFloat() - 0.5f) * 0.1f), new int[]{Block.func_176210_f((IBlockState)blockState)});
                    }
                }
                SoundType sound = blockState.func_177230_c().getSoundType(blockState, world, pos, (Entity)player);
                for (int i = 0; i < 3; ++i) {
                    world.func_184148_a(null, (double)((float)pos.func_177958_n() + hitX), (double)((float)pos.func_177956_o() + hitY), (double)((float)pos.func_177952_p() + hitZ), sound.func_185845_c(), SoundCategory.PLAYERS, 1.0f, 0.5f + world.field_73012_v.nextFloat() * 0.5f);
                }
                player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public void checkForWormSpawn(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K && world.func_175659_aa() != EnumDifficulty.PEACEFUL && world.field_73012_v.nextInt(12) == 0) {
            EntityTinySludgeWorm entity = new EntityTinySludgeWorm(world);
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)entity);
            if (player instanceof EntityPlayerMP) {
                AdvancementCriterionRegistry.WORM_FROM_DIRT.trigger((EntityPlayerMP)player);
            }
        }
    }

    @Override
    public int getMinRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairFuelCost(this.field_77862_b);
    }

    @Override
    public int getFullRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairFuelCost(this.field_77862_b);
    }

    @Override
    public int getMinRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairLifeCost(this.field_77862_b);
    }

    @Override
    public int getFullRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairLifeCost(this.field_77862_b);
    }
}

