/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.api.item.IBigSwingAnimation;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.misc.BlockMistBridge;
import thebetweenlands.common.block.misc.BlockShadowWalker;
import thebetweenlands.common.entity.EntityMistBridge;
import thebetweenlands.common.registries.SoundRegistry;

public class ItemShadowStaff
extends Item
implements IBigSwingAnimation {
    public ItemShadowStaff() {
        this.func_77625_d(1);
        this.func_77656_e(64);
        this.func_77637_a(BLCreativeTabs.SPECIALS);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        BlockPos pos = player.func_180425_c();
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (world.func_175623_d(pos)) {
            if (!world.field_72995_K) {
                stack.func_77972_a(2, (EntityLivingBase)player);
                double direction = Math.toRadians(player.field_70177_z);
                Vec3d diag = new Vec3d(Math.sin(direction + 1.5707963267948966), 0.0, Math.cos(direction + 1.5707963267948966)).func_72432_b();
                ArrayList<BlockPos> spawnedPos = new ArrayList<BlockPos>();
                ArrayList<BlockPos> convertPos = new ArrayList<BlockPos>();
                ArrayList<Integer> blockDistance = new ArrayList<Integer>();
                for (int distance = -1; distance <= 16; ++distance) {
                    block1: for (int distance2 = -distance; distance2 <= distance; ++distance2) {
                        for (int yo = 0; yo <= 1; ++yo) {
                            int originZ;
                            int originY;
                            int originX = MathHelper.func_76128_c((double)((double)pos.func_177958_n() + 0.5 - Math.sin(direction) * (double)distance - diag.field_72450_a * (double)distance2 * 0.25));
                            BlockPos origin = new BlockPos(originX, originY = pos.func_177956_o() + yo, originZ = MathHelper.func_76128_c((double)((double)pos.func_177952_p() + 0.5 + Math.cos(direction) * (double)distance + diag.field_72449_c * (double)distance2 * 0.25)));
                            if (spawnedPos.contains(origin)) continue;
                            spawnedPos.add(origin);
                            IBlockState block = world.func_180495_p(new BlockPos(originX, originY, originZ));
                            if (!this.isShadowableBlock(world, player, origin, block)) continue;
                            convertPos.add(origin);
                            blockDistance.add(distance);
                            continue block1;
                        }
                    }
                }
                this.spawnEntity(world, pos, blockDistance, convertPos);
                world.func_184133_a((EntityPlayer)null, pos, (SoundEvent)SoundRegistry.MIST_STAFF_CAST, SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_184811_cZ().func_185145_a((Item)this, 200);
            }
        } else {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        player.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private boolean isShadowableBlock(World world, EntityPlayer player, BlockPos pos, IBlockState state) {
        return (state.func_185915_l() || state.func_177230_c().func_176200_f((IBlockAccess)world, pos)) && !state.func_177230_c().hasTileEntity(state) && (double)state.func_185903_a(player, world, pos) > 1.0E-4 && !(state.func_177230_c() instanceof BlockMistBridge) && !(state.func_177230_c() instanceof BlockShadowWalker) && !world.func_175623_d(pos);
    }

    private void spawnEntity(World world, BlockPos pos, List<Integer> blockDistance, List<BlockPos> convertPos) {
        if (!world.field_72995_K) {
            EntityMistBridge mist_bridge = new EntityMistBridge(world);
            mist_bridge.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            mist_bridge.setBlockList(blockDistance, convertPos, false);
            if (mist_bridge.func_70601_bi()) {
                mist_bridge.func_180482_a(world.func_175649_E(mist_bridge.func_180425_c()), null);
                world.func_72838_d((Entity)mist_bridge);
            }
        }
    }

    @Override
    public boolean shouldUseBigSwingAnimation(ItemStack stack) {
        return true;
    }

    @Override
    public float getSwingSpeedMultiplier(EntityLivingBase entity, ItemStack stack) {
        return 0.35f;
    }
}

