/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.terrain.BlockBetweenstonePebblePile;
import thebetweenlands.common.block.terrain.BlockBetweenstonePebblePileWater;
import thebetweenlands.common.entity.mobs.EntityEmberling;
import thebetweenlands.common.entity.mobs.EntityEmberlingWild;
import thebetweenlands.common.item.IGenericItem;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemMisc
extends Item
implements ItemRegistry.IMultipleItemModelDefinition {
    public ItemMisc() {
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String key = "tooltip.bl.item_misc." + IGenericItem.getFromStack(EnumItemMisc.class, stack).getTranslationKey();
        if (I18n.func_188566_a((String)key)) {
            tooltip.add(I18n.func_135052_a((String)key, (Object[])new Object[0]));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            Stream.of(EnumItemMisc.values()).forEach(t -> list.add((Object)t.create(1)));
        }
    }

    public String func_77667_c(ItemStack stack) {
        try {
            return "item.thebetweenlands." + IGenericItem.getFromStack(EnumItemMisc.class, stack).getTranslationKey();
        }
        catch (Exception e) {
            return "item.thebetweenlands.unknown_generic";
        }
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        HashMap<Integer, ResourceLocation> models = new HashMap<Integer, ResourceLocation>();
        for (EnumItemMisc type : EnumItemMisc.values()) {
            models.put(type.getID(), new ResourceLocation("thebetweenlands", type.getModelName()));
        }
        return models;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (EnumItemMisc.SCROLL.isItemOf(stack) || EnumItemMisc.TAR_BEAST_HEART.isItemOf(stack) || EnumItemMisc.TAR_BEAST_HEART_ANIMATED.isItemOf(stack) || EnumItemMisc.INANIMATE_TARMINION.isItemOf(stack)) {
            return EnumRarity.UNCOMMON;
        }
        if (EnumItemMisc.AMULET_SOCKET.isItemOf(stack) || EnumItemMisc.LOOT_SCRAPS.isItemOf(stack) || EnumItemMisc.FABRICATED_SCROLL.isItemOf(stack)) {
            return EnumRarity.RARE;
        }
        return super.func_77613_e(stack);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (target instanceof EntityEmberlingWild && EnumItemMisc.UNDYING_EMBER.isItemOf(stack)) {
            EntityEmberlingWild oldEmberling = (EntityEmberlingWild)target;
            EntityEmberling newEmberling = new EntityEmberling(player.func_130014_f_());
            if (!player.func_130014_f_().field_72995_K) {
                newEmberling.func_82149_j((Entity)oldEmberling);
                newEmberling.func_193101_c(player);
                player.func_130014_f_().func_72900_e((Entity)oldEmberling);
                player.func_130014_f_().func_72838_d((Entity)newEmberling);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    if (stack.func_190916_E() <= 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                }
                return true;
            }
            oldEmberling.playTameEffect(true);
            return true;
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() == EnumItemMisc.BETWEENSTONE_PEBBLE.getItem() && player.func_184586_b(hand).func_77952_i() == EnumItemMisc.BETWEENSTONE_PEBBLE.getID()) {
            IBlockState iblockstate = world.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();
            if (!block.func_176200_f((IBlockAccess)world, pos) && !(block instanceof BlockBetweenstonePebblePileWater)) {
                pos = pos.func_177972_a(facing);
            }
            Block blockType = world.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? BlockRegistry.BETWEENSTONE_PEBBLE_PILE_WATER : BlockRegistry.BETWEENSTONE_PEBBLE_PILE;
            ItemStack itemstack = player.func_184586_b(hand);
            if (!itemstack.func_190926_b() && player.func_175151_a(pos, facing, itemstack) && world.func_190527_a(blockType, pos, false, facing, (Entity)null)) {
                int i = this.func_77647_b(itemstack.func_77960_j());
                IBlockState iblockstate1 = blockType.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
                if (this.placeBlockAt(itemstack, player, world, pos, facing, hitX, hitY, hitZ, iblockstate1)) {
                    iblockstate1 = world.func_180495_p(pos);
                    SoundType soundtype = iblockstate1.func_177230_c().getSoundType(iblockstate1, world, pos, (Entity)player);
                    world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    itemstack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if ((world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockBetweenstonePebblePileWater || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockBetweenstonePebblePile) && side == EnumFacing.UP) {
            return false;
        }
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == BlockRegistry.BETWEENSTONE_PEBBLE_PILE) {
            BlockRegistry.BETWEENSTONE_PEBBLE_PILE.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
        }
        if (state.func_177230_c() == BlockRegistry.BETWEENSTONE_PEBBLE_PILE_WATER) {
            BlockRegistry.BETWEENSTONE_PEBBLE_PILE_WATER.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
        }
        return true;
    }

    public static enum EnumItemMisc implements IGenericItem
    {
        BLOOD_SNAIL_SHELL(0),
        MIRE_SNAIL_SHELL(1),
        COMPOST(2),
        DRAGONFLY_WING(3),
        LURKER_SKIN(4),
        DRIED_SWAMP_REED(6),
        SWAMP_REED_ROPE(7),
        MUD_BRICK(10),
        SYRMORITE_INGOT(11),
        DRY_BARK(13),
        SLIMY_BONE(14),
        SNAPPER_ROOT(16),
        STALKER_EYE(17),
        SULFUR(18),
        VALONITE_SHARD(19),
        WEEDWOOD_STICK(20),
        ANGLER_TOOTH(21),
        WEEDWOOD_BOWL(22),
        RUBBER_BALL(23),
        TAR_BEAST_HEART(24),
        TAR_BEAST_HEART_ANIMATED(25),
        TAR_DRIP(26),
        LIMESTONE_FLUX(27),
        INANIMATE_TARMINION(29),
        POISON_GLAND(30),
        PARCHMENT(32),
        SHOCKWAVE_SWORD_1(33),
        SHOCKWAVE_SWORD_2(34),
        SHOCKWAVE_SWORD_3(35),
        SHOCKWAVE_SWORD_4(36),
        AMULET_SOCKET(38),
        SCABYST(39),
        SCROLL(40),
        SYRMORITE_NUGGET(41),
        OCTINE_NUGGET(42),
        VALONITE_SPLINTER(43),
        CREMAINS(44),
        UNDYING_EMBER(45),
        INANIMATE_ANGRY_PEBBLE(46),
        ANCIENT_REMNANT(47),
        LOOT_SCRAPS(48),
        FABRICATED_SCROLL(49),
        BETWEENSTONE_PEBBLE(50),
        ANADIA_SWIM_BLADDER(51),
        ANADIA_EYE(52),
        ANADIA_GILLS(53),
        ANADIA_SCALES(54),
        ANADIA_BONES(55),
        ANADIA_REMAINS(56),
        ANADIA_FINS(57),
        SNOT(58),
        URCHIN_SPIKE(59),
        FISHING_FLOAT(60),
        OLMLETTE_MIXTURE(61);

        private final int id;
        private final String unlocalizedName;
        private final String modelName;

        private EnumItemMisc(int id) {
            this.id = id;
            this.unlocalizedName = this.modelName = this.name().toLowerCase(Locale.ENGLISH);
        }

        @Override
        public String getTranslationKey() {
            return this.unlocalizedName;
        }

        @Override
        public String getModelName() {
            return this.modelName;
        }

        @Override
        public int getID() {
            return this.id;
        }

        @Override
        public Item getItem() {
            return ItemRegistry.ITEMS_MISC;
        }
    }
}

