/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.entity.EntityGrapplingHookNode;
import thebetweenlands.common.registries.SoundRegistry;

public class ItemGrapplingHook
extends Item {
    public static final int MIN_GRAPPLING_HOOK_LENGTH = 16;
    public static final int MAX_GRAPPLING_HOOK_LENGTH = 32;

    public ItemGrapplingHook() {
        this.func_77637_a(BLCreativeTabs.GEARS);
        this.func_77625_d(1);
        this.func_77656_e(16);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("grappling_hook_length"), (stack, worldIn, entityIn) -> 16 + stack.func_77952_i());
        this.func_185043_a(new ResourceLocation("extended"), (stack, worldIn, entityIn) -> {
            if (entityIn != null && entityIn.func_184187_bx() instanceof EntityGrapplingHookNode) {
                boolean isMainHand = stack == entityIn.func_184586_b(EnumHand.MAIN_HAND);
                boolean isOffHand = stack == entityIn.func_184586_b(EnumHand.OFF_HAND);
                boolean hasOffHand = !entityIn.func_184586_b(EnumHand.OFF_HAND).func_190926_b() && entityIn.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof ItemGrapplingHook;
                return (isMainHand || isOffHand) && (isMainHand && !hasOffHand || isOffHand) ? 1.0f : 0.0f;
            }
            return 0.0f;
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && !player.func_184218_aH()) {
            ItemStack stack = player.func_184586_b(hand);
            Vec3d dir = player.func_70040_Z();
            int maxNodes = 16 + stack.func_77952_i();
            int thrownNodes = maxNodes / 2;
            EntityGrapplingHookNode mountNode = new EntityGrapplingHookNode(world, thrownNodes + 1, maxNodes);
            mountNode.func_70012_b(player.field_70165_t - (double)(player.field_70130_N / 2.0f), player.field_70163_u, player.field_70161_v - (double)(player.field_70130_N / 2.0f), 0.0f, 0.0f);
            mountNode.field_70159_w = player.field_70159_w;
            mountNode.field_70181_x = player.field_70181_x;
            mountNode.field_70179_y = player.field_70179_y;
            player.func_184220_m((Entity)mountNode);
            EntityGrapplingHookNode prevNode = null;
            for (int i = 0; i < thrownNodes; ++i) {
                EntityGrapplingHookNode node = new EntityGrapplingHookNode(world);
                node.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, 0.0f, 0.0f);
                float velocity = 1.5f * (0.4f + 1.0f * (float)i / (float)thrownNodes) / 32.0f * (float)maxNodes;
                float upwardsVelocity = 1.0f * (0.4f + 0.6f * (float)Math.sin(1.5707963267948966 / (double)thrownNodes * (double)i)) / 32.0f * (float)maxNodes;
                node.field_70159_w = player.field_70159_w + dir.field_72450_a * (double)velocity;
                node.field_70181_x = player.field_70181_x + dir.field_72448_b * (double)velocity + (double)upwardsVelocity + 0.5;
                node.field_70179_y = player.field_70179_y + dir.field_72449_c * (double)velocity;
                if (prevNode == null) {
                    node.setNextNode(mountNode);
                    mountNode.setPreviousNode(node);
                } else {
                    prevNode.setPreviousNode(node);
                    node.setNextNode(prevNode);
                }
                world.func_72838_d((Entity)node);
                prevNode = node;
            }
            mountNode.setNextNode((Entity)player);
            world.func_72838_d((Entity)mountNode);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.ROPE_THROW, SoundCategory.PLAYERS, 1.5f, 0.8f + world.field_73012_v.nextFloat() * 0.3f);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int maxNodes = 16 + stack.func_77952_i();
        tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.grappling_hook", (Object[])new Object[]{maxNodes, maxNodes * 2, maxNodes / 2, maxNodes}), 0));
        if (stack.func_77952_i() < stack.func_77958_k()) {
            tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.grappling_hook.upgrade", (Object[])new Object[0]), 0));
        }
        if (GuiScreen.func_146272_n()) {
            String toolTip = I18n.func_135052_a((String)"tooltip.bl.grappling_hook.more_info", (Object[])new Object[]{Minecraft.func_71410_x().field_71474_y.field_74314_A.getDisplayName(), Minecraft.func_71410_x().field_71474_y.field_74351_w.getDisplayName(), Minecraft.func_71410_x().field_71474_y.field_74368_y.getDisplayName(), Minecraft.func_71410_x().field_71474_y.field_74370_x.getDisplayName(), Minecraft.func_71410_x().field_71474_y.field_74366_z.getDisplayName()});
            tooltip.addAll(ItemTooltipHandler.splitTooltip(toolTip, 1));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.bl.press.shift", (Object[])new Object[0]));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack baseHook = new ItemStack((Item)this);
            items.add((Object)baseHook);
            items.add((Object)new ItemStack((Item)this, 1, baseHook.func_77958_k()));
        }
    }

    public void onGrapplingHookRipped(ItemStack stack, Entity user) {
        if (stack.func_77952_i() > 0) {
            stack.func_77964_b(stack.func_77952_i() - 1);
        }
    }

    public boolean canRideGrapplingHook(ItemStack stack, Entity user) {
        return true;
    }
}

