/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.api.item.IRenamableItem;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.block.structure.BlockWaystone;
import thebetweenlands.common.handler.PlayerRespawnHandler;
import thebetweenlands.common.item.equipment.ItemRing;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;
import thebetweenlands.util.PlayerUtil;

public class ItemBoneWayfinder
extends Item
implements IRenamableItem,
IAnimatorRepairable {
    public ItemBoneWayfinder() {
        this.func_77637_a(BLCreativeTabs.SPECIALS);
        this.func_77656_e(10);
        this.func_77625_d(1);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getBoundWaystone(stack) != null;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state;
        ItemStack stack = player.func_184586_b(hand);
        if (this.getBoundWaystone(stack) == null && stack.func_77952_i() < stack.func_77958_k() && (state = world.func_180495_p(pos)).func_177230_c() == BlockRegistry.WAYSTONE && this.activateWaystone(world, pos, state, stack)) {
            if (!world.field_72995_K) {
                this.setBoundWaystone(stack, pos);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                player.openGui((Object)TheBetweenlands.instance, 13, world, hand == EnumHand.MAIN_HAND ? 0 : 1, 0, 0);
            }
        } else if (stack.func_77952_i() < stack.func_77958_k() && this.getBoundWaystone(stack) != null) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entity) {
        BlockPos waystone;
        if (!worldIn.field_72995_K && stack.func_77952_i() < stack.func_77958_k() && (waystone = this.getBoundWaystone(stack)) != null) {
            BlockPos spawnPoint = PlayerRespawnHandler.getSpawnPointNearPos(worldIn, waystone, 8, false, 4, 0);
            if (spawnPoint != null) {
                if (entity.func_174818_b(spawnPoint) > 24.0) {
                    this.playThunderSounds(worldIn, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                }
                PlayerUtil.teleport((Entity)entity, (double)spawnPoint.func_177958_n() + 0.5, spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5);
                this.playThunderSounds(worldIn, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60, 1));
                stack.func_77972_a(1, entity);
            } else if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).func_146105_b((ITextComponent)new TextComponentTranslation("chat.waystone.obstructed", new Object[0]), true);
            }
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    public void setDamage(ItemStack stack, int damage) {
        int maxDamage = stack.func_77958_k();
        if (damage > maxDamage) {
            damage = maxDamage;
        }
        super.setDamage(stack, damage);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("link", 4)) {
            BlockPos waystone = BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("link"));
            tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_74837_a((String)"tooltip.bl.bone_wayfinder_linked", (Object[])new Object[]{waystone.func_177958_n(), waystone.func_177956_o(), waystone.func_177952_p()}), 0));
        } else {
            tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_74837_a((String)"tooltip.bl.bone_wayfinder", (Object[])new Object[0]), 0));
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int count) {
        if (!entity.field_70170_p.field_72995_K) {
            int removed;
            if (count < 80 && !entity.field_70170_p.func_175678_i(new BlockPos((Vec3i)entity.func_180425_c()))) {
                if (entity instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)entity).func_146105_b((ITextComponent)new TextComponentTranslation("chat.bone_wayfinder.sky_obstructed", new Object[0]), true);
                }
                entity.func_184597_cx();
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, 1.0f);
                return;
            }
            if (entity.field_70737_aN > 0) {
                entity.func_184597_cx();
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            if (entity instanceof EntityPlayer && !((EntityPlayer)entity).func_184812_l_() && count < 60 && entity.field_70173_aa % 3 == 0 && (removed = ItemRing.removeXp((EntityPlayer)entity, 1)) == 0) {
                entity.func_184597_cx();
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            if (count < 90 && count % 20 == 0) {
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundRegistry.PORTAL_TRAVEL, SoundCategory.PLAYERS, 0.05f + 0.4f * (float)MathHelper.func_76125_a((int)(80 - count), (int)1, (int)80) / 80.0f, 0.9f + entity.field_70170_p.field_73012_v.nextFloat() * 0.2f);
            }
        } else {
            Random rand = entity.field_70170_p.field_73012_v;
            for (int i = 0; i < MathHelper.func_76125_a((int)(60 - count), (int)1, (int)60); ++i) {
                entity.field_70170_p.func_175688_a(EnumParticleTypes.SUSPENDED_DEPTH, entity.field_70165_t + (double)(rand.nextBoolean() ? -1 : 1) * Math.pow(rand.nextFloat(), 2.0) * 6.0, entity.field_70163_u + (double)(rand.nextFloat() * 4.0f) - 2.0, entity.field_70161_v + (double)(rand.nextBoolean() ? -1 : 1) * Math.pow(rand.nextFloat(), 2.0) * 6.0, 0.0, 0.2, 0.0, new int[0]);
            }
        }
    }

    protected void playThunderSounds(World world, double x, double y, double z) {
        world.func_184148_a(null, x, y, z, (SoundEvent)SoundRegistry.RIFT_CREAK, SoundCategory.PLAYERS, 2.0f, 1.0f);
        world.func_184148_a(null, x, y, z, SoundEvents.field_187754_de, SoundCategory.PLAYERS, 0.75f, 0.75f);
    }

    protected boolean activateWaystone(World world, BlockPos pos, IBlockState state, ItemStack stack) {
        BlockWaystone block = (BlockWaystone)state.func_177230_c();
        if (block.isValidWaystone(world, pos, state)) {
            BlockWaystone.Part part = (BlockWaystone.Part)((Object)state.func_177229_b(BlockWaystone.PART));
            if (!world.field_72995_K) {
                int startY;
                for (int yo = startY = part == BlockWaystone.Part.BOTTOM ? 0 : (part == BlockWaystone.Part.MIDDLE ? -1 : -2); yo < startY + 3; ++yo) {
                    IBlockState newState = world.func_180495_p(pos.func_177981_b(yo)).func_177226_a((IProperty)BlockWaystone.ACTIVE, (Comparable)Boolean.valueOf(true));
                    world.func_175656_a(pos.func_177981_b(yo), newState);
                    world.func_184138_a(pos.func_177981_b(yo), newState, newState, 2);
                }
                this.playThunderSounds(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                List<LocationStorage> waystoneLocations = BetweenlandsWorldStorage.forWorld(world).getLocalStorageHandler().getLocalStorages(LocationStorage.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + startY), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + startY + 3), (double)(pos.func_177952_p() + 1)), storage -> storage.getType() == EnumLocationType.WAYSTONE);
                if (!waystoneLocations.isEmpty()) {
                    LocationStorage location = waystoneLocations.get(0);
                    if (stack.func_82837_s()) {
                        location.setName(stack.func_82833_r());
                        location.setVisible(true);
                        location.markDirty();
                    } else {
                        location.setName("waystone");
                        location.setVisible(false);
                        location.markDirty();
                    }
                }
            } else {
                this.spawnWaystoneParticles(world, pos, part);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnWaystoneParticles(World world, BlockPos pos, BlockWaystone.Part part) {
        int startY;
        for (int yo = startY = part == BlockWaystone.Part.BOTTOM ? 0 : (part == BlockWaystone.Part.MIDDLE ? -1 : -2); yo < startY + 3; ++yo) {
            for (int i = 0; i < 4; ++i) {
                Vec3d dir = new Vec3d((double)(world.field_73012_v.nextFloat() - 0.5f), (double)(world.field_73012_v.nextFloat() - 0.5f + 0.25f), (double)(world.field_73012_v.nextFloat() - 0.5f));
                dir = dir.func_72432_b().func_186678_a(2.0);
                BLParticles.CORRUPTED.spawn(world, (double)pos.func_177958_n() + 0.5 + (double)(world.field_73012_v.nextFloat() / 2.0f) - 0.25, (double)(pos.func_177956_o() + yo) + 0.5 + (double)(world.field_73012_v.nextFloat() / 2.0f) - 0.25, (double)pos.func_177952_p() + 0.5 + (double)(world.field_73012_v.nextFloat() / 2.0f) - 0.25, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c));
            }
        }
    }

    @Nullable
    public BlockPos getBoundWaystone(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_150297_b("link", 4)) {
            return BlockPos.func_177969_a((long)nbt.func_74763_f("link"));
        }
        return null;
    }

    public void setBoundWaystone(ItemStack stack, @Nullable BlockPos pos) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (pos == null) {
            if (nbt != null) {
                nbt.func_82580_o("link");
                stack.func_77982_d(nbt);
            }
        } else {
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            nbt.func_74772_a("link", pos.func_177986_g());
            stack.func_77982_d(nbt);
        }
    }

    @Override
    public int getMinRepairFuelCost(ItemStack stack) {
        return 8;
    }

    @Override
    public int getFullRepairFuelCost(ItemStack stack) {
        return 32;
    }

    @Override
    public int getMinRepairLifeCost(ItemStack stack) {
        return 16;
    }

    @Override
    public int getFullRepairLifeCost(ItemStack stack) {
        return 38;
    }
}

