/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketMaps;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.item.IRenamableItem;
import thebetweenlands.api.storage.ILocalStorageHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.network.clientbound.MessageAmateMap;
import thebetweenlands.common.registries.BiomeRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.world.storage.AmateMapData;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationCragrockTower;
import thebetweenlands.common.world.storage.location.LocationGuarded;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class ItemAmateMap
extends ItemMap
implements ItemRegistry.ICustomMeshCallback,
IRenamableItem {
    public static final String STR_ID = "amatemap";
    private static final Map<ResourceLocation, BiomeColor> BIOME_COLORS = new HashMap<ResourceLocation, BiomeColor>();

    public ItemAmateMap() {
        this.func_77637_a(BLCreativeTabs.SPECIALS);
    }

    public static ItemStack setupNewMap(World worldIn, double worldX, double worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking) {
        ItemStack itemstack = new ItemStack(ItemRegistry.AMATE_MAP, 1, worldIn.func_72841_b(STR_ID));
        String s = "amatemap_" + itemstack.func_77960_j();
        AmateMapData mapdata = new AmateMapData(s);
        worldIn.func_72823_a(s, (WorldSavedData)mapdata);
        mapdata.field_76197_d = scale;
        mapdata.func_176054_a(worldX, worldZ, mapdata.field_76197_d);
        mapdata.field_76200_c = worldIn.field_73011_w.getDimension();
        mapdata.field_186210_e = trackingPosition;
        mapdata.field_191096_f = unlimitedTracking;
        mapdata.func_76185_a();
        return itemstack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && !world.field_72995_K) {
            player.openGui((Object)TheBetweenlands.instance, 13, world, hand == EnumHand.MAIN_HAND ? 0 : 1, 0, 0);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static AmateMapData loadMapData(int mapId, World worldIn) {
        String s = "amatemap_" + mapId;
        return (AmateMapData)worldIn.func_72943_a(AmateMapData.class, s);
    }

    @Nullable
    public AmateMapData getMapData(ItemStack stack, World worldIn) {
        String s = "amatemap_" + stack.func_77960_j();
        AmateMapData mapdata = (AmateMapData)worldIn.func_72943_a(AmateMapData.class, s);
        if (mapdata == null && !worldIn.field_72995_K) {
            stack.func_77964_b(worldIn.func_72841_b(STR_ID));
            s = "amatemap_" + stack.func_77960_j();
            mapdata = new AmateMapData(s);
            mapdata.field_76197_d = (byte)3;
            mapdata.func_176054_a(worldIn.func_72912_H().func_76079_c(), worldIn.func_72912_H().func_76074_e(), mapdata.field_76197_d);
            mapdata.field_76200_c = worldIn.field_73011_w.getDimension();
            mapdata.func_76185_a();
            worldIn.func_72823_a(s, (WorldSavedData)mapdata);
        }
        return mapdata;
    }

    public void func_77872_a(World world, Entity viewer, MapData data) {
        if (world.field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId && world.field_73011_w.getDimension() == data.field_76200_c && viewer instanceof EntityPlayer && viewer.field_70173_aa % 20 == 0) {
            int blocksPerPixel = 16;
            int centerX = data.field_76201_a;
            int centerZ = data.field_76199_b;
            int viewerBlockX = MathHelper.func_76128_c((double)(viewer.field_70165_t / (double)blocksPerPixel)) * blocksPerPixel;
            int viewerBlockZ = MathHelper.func_76128_c((double)(viewer.field_70161_v / (double)blocksPerPixel)) * blocksPerPixel;
            int viewerOffsetX = viewerBlockX - MathHelper.func_76141_d((float)(centerX / blocksPerPixel)) * blocksPerPixel;
            int viewerOffsetZ = viewerBlockZ - MathHelper.func_76141_d((float)(centerZ / blocksPerPixel)) * blocksPerPixel;
            int viewerPixelX = viewerOffsetX / blocksPerPixel + 64;
            int viewerPixelZ = viewerOffsetZ / blocksPerPixel + 64;
            int viewRadiusPixels = 256 / blocksPerPixel;
            MapData.MapInfo mapInfo = data.func_82568_a((EntityPlayer)viewer);
            ++mapInfo.field_82569_d;
            boolean terrainChanged = false;
            int biomeViewRange = viewRadiusPixels * blocksPerPixel / 4 * 2 + 1;
            int updatedColumns = 0;
            int prevXPixel = 0;
            Biome[][] biomes = new Biome[][]{new Biome[biomeViewRange], new Biome[biomeViewRange]};
            HashMap<Integer, List<Integer>> checkedChunks = new HashMap<Integer, List<Integer>>();
            for (int xPixel = viewerPixelX - viewRadiusPixels + 1; xPixel < viewerPixelX + viewRadiusPixels; ++xPixel) {
                if ((xPixel & 0xF) != (mapInfo.field_82569_d & 0xF) && !terrainChanged) continue;
                terrainChanged = false;
                int primaryBiomesArray = updatedColumns % 2;
                int previousBiomesArray = (updatedColumns + 1) % 2;
                biomes[primaryBiomesArray] = world.func_72959_q().func_76937_a(biomes[primaryBiomesArray], (viewerBlockX + (xPixel - viewerPixelX) * blocksPerPixel) / 4, (viewerBlockZ - (viewRadiusPixels - 1) * blocksPerPixel) / 4, 1, biomeViewRange);
                if (updatedColumns == 0 || xPixel - prevXPixel != 1) {
                    biomes[previousBiomesArray] = world.func_72959_q().func_76937_a(biomes[previousBiomesArray], (viewerBlockX + (xPixel - viewerPixelX - 1) * blocksPerPixel) / 4, (viewerBlockZ - (viewRadiusPixels - 1) * blocksPerPixel) / 4, 1, biomeViewRange);
                }
                for (int zPixel = viewerPixelZ - viewRadiusPixels - 1; zPixel < viewerPixelZ + viewRadiusPixels; ++zPixel) {
                    Biome biomeLeft;
                    Biome biomeUp;
                    if (xPixel < 0 || zPixel < 0 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerPixelX;
                    int zPixelDist = zPixel - viewerPixelZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    int biomeIndex = (zPixel - viewerPixelZ + viewRadiusPixels + 1) * blocksPerPixel / 4;
                    Biome primaryBiome = biomes[primaryBiomesArray][biomeIndex];
                    boolean isEdge = false;
                    if (biomeIndex >= blocksPerPixel / 4 && (biomeUp = biomes[primaryBiomesArray][biomeIndex - blocksPerPixel / 4]) != primaryBiome) {
                        isEdge = true;
                    }
                    if ((biomeLeft = biomes[previousBiomesArray][biomeIndex]) != primaryBiome) {
                        isEdge = true;
                    }
                    BiomeColor colorBrightness = this.getMapColorPerBiome(world, primaryBiome);
                    MapColor mapcolor = colorBrightness.color;
                    int brightness = colorBrightness.brightness;
                    if (zPixel < 0 || xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0) continue;
                    byte oldPixel = data.field_76198_e[xPixel + zPixel * 128];
                    byte newPixel = (byte)(mapcolor.field_76290_q * 4 + brightness);
                    if (isEdge) {
                        newPixel = 116;
                    }
                    if (oldPixel != newPixel) {
                        data.field_76198_e[xPixel + zPixel * 128] = newPixel;
                        data.func_176053_a(xPixel, zPixel);
                        terrainChanged = true;
                    }
                    int worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel;
                    int worldZ = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel;
                    int chunkX = worldX >> 4;
                    int chunkZ = worldZ >> 4;
                    if (checkedChunks.containsKey(chunkX) && (!checkedChunks.containsKey(chunkX) || ((List)checkedChunks.get(chunkX)).contains(chunkZ))) continue;
                    checkedChunks.computeIfAbsent(chunkX, integer -> new ArrayList()).add(chunkZ);
                }
                ++updatedColumns;
                prevXPixel = xPixel;
            }
            this.locateBLLocations(world, checkedChunks, centerX, centerZ, blocksPerPixel, data);
        }
    }

    private void locateBLLocations(World world, Map<Integer, List<Integer>> posList, int centerX, int centerZ, int blocksPerPixel, MapData data) {
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        ILocalStorageHandler handler = worldStorage.getLocalStorageHandler();
        AmateMapData amateMapData = (AmateMapData)data;
        for (Map.Entry<Integer, List<Integer>> chunkX : posList.entrySet()) {
            for (Integer z : chunkX.getValue()) {
                int x = chunkX.getKey();
                List<LocationStorage> localStorages = handler.getLocalStorages(LocationStorage.class, x << 4, z << 4, input -> true);
                if (localStorages.size() <= 0) continue;
                for (LocationStorage storage : localStorages) {
                    LocationGuarded guarded;
                    AxisAlignedBB aabb = storage.getEnclosingBounds();
                    Vec3d center = new Vec3d(aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * 0.5, aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * 0.5, aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * 0.5);
                    byte mapX = (byte)((center.field_72450_a - (double)centerX) / (double)blocksPerPixel * 2.0);
                    byte mapZ = (byte)((center.field_72449_c - (double)centerZ) / (double)blocksPerPixel * 2.0);
                    AmateMapData.BLMapDecoration.Location location = AmateMapData.BLMapDecoration.Location.getLocation(storage);
                    if (location == AmateMapData.BLMapDecoration.Location.NONE) continue;
                    amateMapData.addDecoration(new AmateMapData.BLMapDecoration(location, mapX, mapZ, 8));
                    boolean done = false;
                    if (location == AmateMapData.BLMapDecoration.Location.TOWER) {
                        LocationCragrockTower tower = (LocationCragrockTower)storage;
                        if (tower.isTopConquered()) {
                            done = true;
                        }
                    } else if ((location == AmateMapData.BLMapDecoration.Location.FORTRESS || location == AmateMapData.BLMapDecoration.Location.SPIRIT_TREE || location == AmateMapData.BLMapDecoration.Location.SLUDGE_WORM_DUNGEON) && (guarded = (LocationGuarded)storage).getGuard().isClear(world)) {
                        done = true;
                    }
                    if (!done) continue;
                    amateMapData.addDecoration(new AmateMapData.BLMapDecoration(AmateMapData.BLMapDecoration.Location.CHECK, mapX, mapZ, 8));
                }
            }
        }
    }

    private BiomeColor getMapColorPerBiome(World world, Biome biome) {
        BiomeColor color;
        if (BIOME_COLORS.isEmpty()) {
            ItemAmateMap.setupBiomeColors();
        }
        if ((color = BIOME_COLORS.get(biome.getRegistryName())) != null) {
            return color;
        }
        return new BiomeColor(biome.field_76752_A.func_185909_g((IBlockAccess)world, BlockPos.field_177992_a));
    }

    private static void setupBiomeColors() {
        ItemAmateMap.putBiomeColor(BiomeRegistry.PATCHY_ISLANDS, new BiomeColor(MapColor.field_151671_v, 7));
        ItemAmateMap.putBiomeColor(BiomeRegistry.SWAMPLANDS, new BiomeColor(MapColor.field_151668_h, 1));
        ItemAmateMap.putBiomeColor(BiomeRegistry.DEEP_WATERS, new BiomeColor(MapColor.field_151675_r, 1));
        ItemAmateMap.putBiomeColor(BiomeRegistry.COARSE_ISLANDS, new BiomeColor(MapColor.field_151675_r, 3));
        ItemAmateMap.putBiomeColor(BiomeRegistry.SLUDGE_PLAINS, new BiomeColor(MapColor.field_151653_I, 10));
        ItemAmateMap.putBiomeColor(BiomeRegistry.MARSH_0, new BiomeColor(MapColor.field_151649_A, 10));
        ItemAmateMap.putBiomeColor(BiomeRegistry.MARSH_1, new BiomeColor(MapColor.field_151649_A, 8));
        ItemAmateMap.putBiomeColor(BiomeRegistry.SWAMPLANDS_CLEARING, new BiomeColor(MapColor.field_151673_t, 9));
    }

    private static void putBiomeColor(Biome biome, BiomeColor color) {
        BIOME_COLORS.put(biome.getRegistryName(), color);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
    }

    @Nullable
    public Packet<?> func_150911_c(ItemStack stack, World worldIn, EntityPlayer player) {
        Packet p = super.func_150911_c(stack, worldIn, player);
        if (p instanceof SPacketMaps) {
            AmateMapData mapData = this.getMapData(stack, worldIn);
            return TheBetweenlands.networkWrapper.getPacketFrom((IMessage)new MessageAmateMap(stack.func_77952_i(), mapData, (SPacketMaps)p));
        }
        return p;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return stack -> new ModelResourceLocation(this.getRegistryName(), "inventory");
    }

    private static class BiomeColor {
        public MapColor color;
        public int brightness;

        public BiomeColor(MapColor color, int brightness) {
            this.color = color;
            this.brightness = brightness;
        }

        public BiomeColor(MapColor color) {
            this.color = color;
            this.brightness = 1;
        }
    }
}

