/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.armor.amphibious;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.item.IAmphibiousArmorUpgrade;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.armor.amphibious.AmphibiousArmorEffectsHelper;
import thebetweenlands.common.item.armor.amphibious.AmphibiousArmorUpgrades;
import thebetweenlands.common.item.armor.amphibious.ItemAmphibiousArmor;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemAmphibiousArmourUpgradeTrigger
extends Item {
    AmphibiousArmorEffectsHelper armorEffectsHelper = new AmphibiousArmorEffectsHelper();
    public final Map<IAmphibiousArmorUpgrade, Boolean> ALLOWED_UPGRADES = new HashMap<IAmphibiousArmorUpgrade, Boolean>();

    public ItemAmphibiousArmourUpgradeTrigger() {
        this.field_77777_bU = 1;
        this.func_77656_e(600);
        this.func_77637_a(BLCreativeTabs.GEARS);
        this.initAllowedUpgradeMap();
        this.func_185043_a(new ResourceLocation("selected_effect"), (stack, world, entity) -> {
            if (entity instanceof EntityPlayer) {
                ItemStack chest = entity.func_184582_a(EntityEquipmentSlot.CHEST);
                ArrayList<IAmphibiousArmorUpgrade> upgradeListChest = new ArrayList<IAmphibiousArmorUpgrade>();
                if (chest.func_77973_b() instanceof ItemAmphibiousArmor && chest.func_77973_b() == ItemRegistry.AMPHIBIOUS_CHESTPLATE && !this.getUpgradeList(chest, EntityEquipmentSlot.CHEST).isEmpty()) {
                    for (IAmphibiousArmorUpgrade upgrade : this.getUpgradeList(chest, EntityEquipmentSlot.CHEST)) {
                        if (!this.isValidUpgrade(upgrade)) continue;
                        upgradeListChest.add(upgrade);
                    }
                }
                if (!upgradeListChest.isEmpty() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("scrollPos") && stack.func_77978_p().func_74762_e("scrollPos") != -1) {
                    int scrollPos = stack.func_77978_p().func_74762_e("scrollPos");
                    if (upgradeListChest.get(scrollPos = MathHelper.func_76125_a((int)scrollPos, (int)0, (int)(upgradeListChest.size() - 1))) == AmphibiousArmorUpgrades.URCHIN) {
                        return 1.0f;
                    }
                    if (upgradeListChest.get(scrollPos) == AmphibiousArmorUpgrades.FISH_VORTEX) {
                        return 2.0f;
                    }
                    if (upgradeListChest.get(scrollPos) == AmphibiousArmorUpgrades.ELECTRIC) {
                        return 3.0f;
                    }
                }
                return 0.0f;
            }
            return 0.0f;
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.amphibious_ability.trigger", (Object[])new Object[0]), 0));
    }

    public boolean isValidUpgrade(IAmphibiousArmorUpgrade upgradeIn) {
        return this.ALLOWED_UPGRADES.get(upgradeIn) != null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        NBTTagCompound nbt = player.getEntityData();
        ArrayList<IAmphibiousArmorUpgrade> upgradeListChest = new ArrayList<IAmphibiousArmorUpgrade>();
        if (chest.func_77973_b() instanceof ItemAmphibiousArmor && chest.func_77973_b() == ItemRegistry.AMPHIBIOUS_CHESTPLATE && !this.getUpgradeList(chest, EntityEquipmentSlot.CHEST).isEmpty()) {
            for (IAmphibiousArmorUpgrade upgrade : this.getUpgradeList(chest, EntityEquipmentSlot.CHEST)) {
                if (!this.isValidUpgrade(upgrade)) continue;
                upgradeListChest.add(upgrade);
            }
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("scrollPos", -1);
        }
        if (player.func_70093_af()) {
            if (chest.func_77973_b() instanceof ItemAmphibiousArmor && chest.func_77973_b() == ItemRegistry.AMPHIBIOUS_CHESTPLATE) {
                int scrollSize = upgradeListChest.size();
                if (!upgradeListChest.isEmpty()) {
                    if (stack.func_77978_p().func_74762_e("scrollPos") < scrollSize) {
                        stack.func_77978_p().func_74768_a("scrollPos", stack.func_77978_p().func_74762_e("scrollPos") + 1);
                    }
                    if (stack.func_77978_p().func_74762_e("scrollPos") >= scrollSize) {
                        stack.func_77978_p().func_74768_a("scrollPos", 0);
                    }
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.aa_trigger.selected_effect", new Object[]{this.getUpgradeName((AmphibiousArmorUpgrades)upgradeListChest.get(stack.func_77978_p().func_74762_e("scrollPos")))}), true);
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (chest.func_77973_b() instanceof ItemAmphibiousArmor && chest.func_77973_b() == ItemRegistry.AMPHIBIOUS_CHESTPLATE && stack.func_77978_p().func_74762_e("scrollPos") != -1 && !upgradeListChest.isEmpty()) {
            int vortexCount;
            if (upgradeListChest.get(stack.func_77978_p().func_74762_e("scrollPos")) == AmphibiousArmorUpgrades.URCHIN) {
                int urchinCount = ((ItemAmphibiousArmor)chest.func_77973_b()).getUpgradeCount(chest, AmphibiousArmorUpgrades.URCHIN);
                long urchinAOECooldown = nbt.func_74763_f("thebetweenlands.urchin_aoe_cooldown");
                if (urchinCount >= 1 && world.func_82737_E() >= urchinAOECooldown && !world.field_72995_K && world.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                    this.armorEffectsHelper.spawnUrchinSpikes(world, player, urchinCount);
                    nbt.func_74772_a("thebetweenlands.urchin_aoe_cooldown", world.func_82737_E() + 50L);
                    ((ItemAmphibiousArmor)chest.func_77973_b()).damageUpgrade(chest, AmphibiousArmorUpgrades.URCHIN, 1, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, false);
                }
            }
            if (upgradeListChest.get(stack.func_77978_p().func_74762_e("scrollPos")) == AmphibiousArmorUpgrades.FISH_VORTEX && (vortexCount = ((ItemAmphibiousArmor)chest.func_77973_b()).getUpgradeCount(chest, AmphibiousArmorUpgrades.FISH_VORTEX)) >= 1 && !world.field_72995_K && world.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                this.armorEffectsHelper.activateFishVortex(world, player, vortexCount);
                ((ItemAmphibiousArmor)chest.func_77973_b()).damageUpgrade(chest, AmphibiousArmorUpgrades.FISH_VORTEX, 1, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, false);
            }
            if (upgradeListChest.get(stack.func_77978_p().func_74762_e("scrollPos")) == AmphibiousArmorUpgrades.ELECTRIC) {
                int electricCount = ((ItemAmphibiousArmor)chest.func_77973_b()).getUpgradeCount(chest, AmphibiousArmorUpgrades.ELECTRIC);
                long electricCooldown = nbt.func_74763_f("thebetweenlands.electric_cooldown");
                if (electricCount >= 1 && world.func_82737_E() >= electricCooldown && !world.field_72995_K && world.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                    this.armorEffectsHelper.spawnElectricEntity(world, player, (EntityLivingBase)player, electricCount);
                    nbt.func_74772_a("thebetweenlands.electric_cooldown", world.func_82737_E() + 50L);
                    ((ItemAmphibiousArmor)chest.func_77973_b()).damageUpgrade(chest, AmphibiousArmorUpgrades.ELECTRIC, 1, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, false);
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public List<IAmphibiousArmorUpgrade> getUpgradeList(ItemStack stack, EntityEquipmentSlot slotType) {
        ArrayList<IAmphibiousArmorUpgrade> nameList = new ArrayList<IAmphibiousArmorUpgrade>();
        for (IAmphibiousArmorUpgrade upgrade : AmphibiousArmorUpgrades.getUpgrades(slotType)) {
            int count = ((ItemAmphibiousArmor)stack.func_77973_b()).getUpgradeCount(stack, upgrade);
            if (count <= 0) continue;
            nameList.add(upgrade);
        }
        return nameList;
    }

    private TextComponentTranslation getUpgradeName(AmphibiousArmorUpgrades upgrade) {
        switch (upgrade) {
            case AQUA_GEM: 
            case BREATHING: 
            case BUOYANCY: 
            case CRIMSON_GEM: 
            case DECAY_DECREASE: 
            case GREEN_GEM: 
            case KNOCKBACK_RESISTANCE: 
            case MINING_SPEED: 
            case MOVEMENT_SPEED: 
            case THORNS: 
            case TOUGHNESS: 
            case VISIBILITY: 
            case ASCENT_BOOST: 
            case GLIDE: {
                break;
            }
            case ELECTRIC: {
                return new TextComponentTranslation("chat.aa_item.electric", new Object[0]);
            }
            case FISH_VORTEX: {
                return new TextComponentTranslation("chat.aa_item.vortex", new Object[0]);
            }
            case URCHIN: {
                return new TextComponentTranslation("chat.aa_item.urchin_spikes", new Object[0]);
            }
        }
        return new TextComponentTranslation("", new Object[0]);
    }

    private boolean hasTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return false;
        }
        return true;
    }

    private void initAllowedUpgradeMap() {
        if (this.ALLOWED_UPGRADES.isEmpty()) {
            this.ALLOWED_UPGRADES.put(AmphibiousArmorUpgrades.getUpgrade(EntityEquipmentSlot.CHEST, new ItemStack(ItemRegistry.AA_UPGRADE_VORTEX)), true);
            this.ALLOWED_UPGRADES.put(AmphibiousArmorUpgrades.getUpgrade(EntityEquipmentSlot.CHEST, new ItemStack(ItemRegistry.AA_UPGRADE_URCHIN)), true);
            this.ALLOWED_UPGRADES.put(AmphibiousArmorUpgrades.getUpgrade(EntityEquipmentSlot.CHEST, new ItemStack(ItemRegistry.AA_UPGRADE_ELECTRIC)), true);
        }
    }
}

