/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.armor.amphibious;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.api.item.IAmphibiousArmorAttributeUpgrade;
import thebetweenlands.api.item.IAmphibiousArmorUpgrade;
import thebetweenlands.common.capability.circlegem.CircleGemType;
import thebetweenlands.common.item.armor.amphibious.AdditiveAttributeUpgrade;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public enum AmphibiousArmorUpgrades implements IAmphibiousArmorUpgrade
{
    VISIBILITY(new ResourceLocation("thebetweenlands", "visibility"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_DAMAGE, ItemMisc.EnumItemMisc.ANADIA_EYE::isItemOf, EntityEquipmentSlot.HEAD),
    THORNS(new ResourceLocation("thebetweenlands", "thorns"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_DAMAGE, ItemMisc.EnumItemMisc.URCHIN_SPIKE::isItemOf, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET),
    DECAY_DECREASE(new ResourceLocation("thebetweenlands", "decay_decrease"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_DAMAGE, s -> s.func_77973_b() == ItemRegistry.SAP_SPIT, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET),
    MINING_SPEED(new ResourceLocation("thebetweenlands", "mining_speed"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_DAMAGE, ItemMisc.EnumItemMisc.SNOT::isItemOf, EntityEquipmentSlot.CHEST),
    BREATHING(new ResourceLocation("thebetweenlands", "breathing"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_DAMAGE, ItemMisc.EnumItemMisc.ANADIA_GILLS::isItemOf, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST),
    MOVEMENT_SPEED(new ResourceLocation("thebetweenlands", "movement_speed"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_DAMAGE, ItemMisc.EnumItemMisc.ANADIA_FINS::isItemOf, (IAmphibiousArmorAttributeUpgrade)AdditiveAttributeUpgrade.MOVEMENT_SPEED, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET),
    TOUGHNESS(new ResourceLocation("thebetweenlands", "toughness"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_DAMAGE, ItemMisc.EnumItemMisc.ANADIA_BONES::isItemOf, (IAmphibiousArmorAttributeUpgrade)AdditiveAttributeUpgrade.TOUGHNESS, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET),
    KNOCKBACK_RESISTANCE(new ResourceLocation("thebetweenlands", "knockback_resistance"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_DAMAGE, ItemMisc.EnumItemMisc.LURKER_SKIN::isItemOf, (IAmphibiousArmorAttributeUpgrade)AdditiveAttributeUpgrade.KNOCKBACK_RESISTANCE, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS),
    BUOYANCY(new ResourceLocation("thebetweenlands", "buoyancy"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_DAMAGE, ItemMisc.EnumItemMisc.ANADIA_SWIM_BLADDER::isItemOf, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS),
    FISH_SIGHT(new ResourceLocation("thebetweenlands", "fish_sight"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, s -> s.func_77973_b() == Item.func_150898_a((Block)BlockRegistry.GLOWING_GOOP), EntityEquipmentSlot.HEAD),
    ARMOR(new ResourceLocation("thebetweenlands", "armor"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_DAMAGE, ItemMisc.EnumItemMisc.ANADIA_SCALES::isItemOf, (IAmphibiousArmorAttributeUpgrade)AdditiveAttributeUpgrade.ARMOR, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET),
    ASCENT_BOOST(new ResourceLocation("thebetweenlands", "ascent_boost"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, s -> s.func_77973_b() == ItemRegistry.AA_UPGRADE_LEAP, EntityEquipmentSlot.LEGS),
    FISH_VORTEX(new ResourceLocation("thebetweenlands", "fish_vortex"), 256, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, s -> s.func_77973_b() == ItemRegistry.AA_UPGRADE_VORTEX, EntityEquipmentSlot.CHEST),
    ELECTRIC(new ResourceLocation("thebetweenlands", "electric"), 256, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, s -> s.func_77973_b() == ItemRegistry.AA_UPGRADE_ELECTRIC, EntityEquipmentSlot.CHEST),
    URCHIN(new ResourceLocation("thebetweenlands", "urchin"), 256, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, s -> s.func_77973_b() == ItemRegistry.AA_UPGRADE_URCHIN, EntityEquipmentSlot.CHEST),
    GLIDE(new ResourceLocation("thebetweenlands", "glide"), 256, IAmphibiousArmorUpgrade.DamageEvent.ON_USE, s -> s.func_77973_b() == ItemRegistry.AA_UPGRADE_GLIDE, EntityEquipmentSlot.CHEST),
    AQUA_GEM(new ResourceLocation("thebetweenlands", "aqua_gem"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_DAMAGE, s -> s.func_77973_b() == ItemRegistry.AQUA_MIDDLE_GEM, null, CircleGemType.AQUA.getAmphibiousArmorOnChangedHandler(), (Set<ResourceLocation>)ImmutableSet.of((Object)new ResourceLocation("thebetweenlands", "green_gem"), (Object)new ResourceLocation("thebetweenlands", "crimson_gem")), EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET),
    GREEN_GEM(new ResourceLocation("thebetweenlands", "green_gem"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_DAMAGE, s -> s.func_77973_b() == ItemRegistry.GREEN_MIDDLE_GEM, null, CircleGemType.GREEN.getAmphibiousArmorOnChangedHandler(), (Set<ResourceLocation>)ImmutableSet.of((Object)new ResourceLocation("thebetweenlands", "aqua_gem"), (Object)new ResourceLocation("thebetweenlands", "crimson_gem")), EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET),
    CRIMSON_GEM(new ResourceLocation("thebetweenlands", "crimson_gem"), 64, IAmphibiousArmorUpgrade.DamageEvent.ON_DAMAGE, s -> s.func_77973_b() == ItemRegistry.CRIMSON_MIDDLE_GEM, null, CircleGemType.CRIMSON.getAmphibiousArmorOnChangedHandler(), (Set<ResourceLocation>)ImmutableSet.of((Object)new ResourceLocation("thebetweenlands", "aqua_gem"), (Object)new ResourceLocation("thebetweenlands", "green_gem")), EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET);

    private static final Map<ResourceLocation, IAmphibiousArmorUpgrade> ID_TO_UPGRADE;
    private static final Multimap<EntityEquipmentSlot, IAmphibiousArmorUpgrade> TYPE_TO_UPGRADES;
    private final ResourceLocation id;
    private final int maxDamage;
    private final IAmphibiousArmorUpgrade.DamageEvent damageEvent;
    private final Predicate<ItemStack> matcher;
    private final IAmphibiousArmorAttributeUpgrade attributeUpgrade;
    private final Set<EntityEquipmentSlot> armorTypes;
    private final Consumer<ItemStack> onChanged;
    private final Set<ResourceLocation> blacklist;

    public static boolean register(IAmphibiousArmorUpgrade upgrade) {
        if (ID_TO_UPGRADE.put(upgrade.getId(), upgrade) == null) {
            for (EntityEquipmentSlot armorType : upgrade.getArmorTypes()) {
                TYPE_TO_UPGRADES.put((Object)armorType, (Object)upgrade);
            }
            return true;
        }
        return false;
    }

    public static Collection<IAmphibiousArmorUpgrade> getUpgrades(EntityEquipmentSlot armorType) {
        return TYPE_TO_UPGRADES.get((Object)armorType);
    }

    @Nullable
    public static IAmphibiousArmorUpgrade getUpgrade(EntityEquipmentSlot armorType, ItemStack stack) {
        for (IAmphibiousArmorUpgrade upgrade : AmphibiousArmorUpgrades.getUpgrades(armorType)) {
            if (!upgrade.matches(armorType, stack)) continue;
            return upgrade;
        }
        return null;
    }

    @Nullable
    public static IAmphibiousArmorUpgrade getUpgrade(ResourceLocation id) {
        return ID_TO_UPGRADE.get(id);
    }

    private AmphibiousArmorUpgrades(ResourceLocation id, int maxDamage, IAmphibiousArmorUpgrade.DamageEvent damageEvent, Predicate<ItemStack> matcher, EntityEquipmentSlot ... armorTypes) {
        this(id, maxDamage, damageEvent, matcher, (IAmphibiousArmorAttributeUpgrade)null, armorTypes);
    }

    private AmphibiousArmorUpgrades(ResourceLocation id, int maxDamage, @Nullable IAmphibiousArmorUpgrade.DamageEvent damageEvent, Predicate<ItemStack> matcher, IAmphibiousArmorAttributeUpgrade attributeUpgrade, EntityEquipmentSlot ... armorTypes) {
        this(id, maxDamage, damageEvent, matcher, attributeUpgrade, null, (Set<ResourceLocation>)ImmutableSet.of(), armorTypes);
    }

    private AmphibiousArmorUpgrades(ResourceLocation id, int maxDamage, @Nullable IAmphibiousArmorUpgrade.DamageEvent damageEvent, Predicate<ItemStack> matcher, IAmphibiousArmorAttributeUpgrade attributeUpgrade, Consumer<ItemStack> onChanged, Set<ResourceLocation> blacklist, EntityEquipmentSlot ... armorTypes) {
        this.id = id;
        this.maxDamage = maxDamage;
        this.damageEvent = damageEvent;
        this.matcher = matcher;
        this.attributeUpgrade = attributeUpgrade;
        this.onChanged = onChanged;
        this.blacklist = blacklist;
        this.armorTypes = Collections.unmodifiableSet(new HashSet<EntityEquipmentSlot>(Arrays.asList(armorTypes)));
    }

    @Override
    public boolean matches(EntityEquipmentSlot armorType, ItemStack stack) {
        return !stack.func_190926_b() && this.armorTypes.contains(armorType) && this.matcher.test(stack);
    }

    @Override
    public Set<EntityEquipmentSlot> getArmorTypes() {
        return this.armorTypes;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public void applyAttributeModifiers(EntityEquipmentSlot armorType, ItemStack stack, int count, Map<IAmphibiousArmorUpgrade, Map<EntityEquipmentSlot, Integer>> counts, Multimap<String, AttributeModifier> modifiers) {
        if (this.attributeUpgrade != null) {
            this.attributeUpgrade.applyAttributeModifiers(armorType, stack, count, counts, modifiers);
        }
    }

    @Override
    public void onChanged(EntityEquipmentSlot armorType, ItemStack armor, ItemStack stack) {
        if (this.onChanged != null) {
            this.onChanged.accept(armor);
        }
    }

    @Override
    public boolean isBlacklisted(IAmphibiousArmorUpgrade other) {
        return this.blacklist.contains(other.getId());
    }

    @Override
    public int getMaxDamage() {
        return this.maxDamage;
    }

    @Override
    public boolean isApplicableDamageEvent(IAmphibiousArmorUpgrade.DamageEvent event) {
        return this.damageEvent != IAmphibiousArmorUpgrade.DamageEvent.NONE && (this.damageEvent == IAmphibiousArmorUpgrade.DamageEvent.ALL || event == this.damageEvent);
    }

    @Override
    public boolean canBreak() {
        return true;
    }

    static {
        ID_TO_UPGRADE = new HashMap<ResourceLocation, IAmphibiousArmorUpgrade>();
        TYPE_TO_UPGRADES = MultimapBuilder.enumKeys(EntityEquipmentSlot.class).arrayListValues().build();
        for (AmphibiousArmorUpgrades upgrade : AmphibiousArmorUpgrades.values()) {
            AmphibiousArmorUpgrades.register(upgrade);
        }
    }
}

